/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.AbsQuery;
import com.contentful.java.cda.CDAArray;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAContentType;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDAResourceNotFoundException;
import com.contentful.java.cda.CDAType;
import com.contentful.java.cda.Cache;
import com.contentful.java.cda.ResourceFactory;
import com.contentful.java.cda.Util;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import org.reactivestreams.Publisher;
import retrofit2.Response;

public class ObserveQuery<T extends CDAResource>
extends AbsQuery<T, ObserveQuery<T>> {
    ObserveQuery(Class<T> type, CDAClient client) {
        super(type, client);
    }

    public Flowable<T> one(String id) {
        Flowable flowable = ((ObserveQuery)this.where("sys.id", id)).all().map(array -> {
            if (array.items().size() == 0) {
                throw new CDAResourceNotFoundException(this.type, id);
            }
            CDAType resourceType = Util.typeForClass(this.type);
            if (CDAType.ASSET.equals((Object)resourceType)) {
                return array.assets().get(id);
            }
            if (CDAType.ENTRY.equals((Object)resourceType)) {
                return array.entries().get(id);
            }
            if (CDAType.CONTENTTYPE.equals((Object)resourceType)) {
                return array.items().get(0);
            }
            if (CDAType.LOCALE.equals((Object)resourceType)) {
                T found = this.findById((CDAArray)array, id);
                if (found == null) {
                    throw new CDAResourceNotFoundException(this.type, id);
                }
                return found;
            }
            throw new IllegalArgumentException("Cannot invoke query for type: " + this.type.getName());
        });
        if (CDAType.CONTENTTYPE.equals((Object)Util.typeForClass(this.type))) {
            flowable = flowable.map(t -> {
                if (t != null) {
                    this.client.cache.types().put(t.id(), (CDAContentType)t);
                }
                return t;
            });
        }
        return flowable;
    }

    T findById(CDAArray array, String id) {
        for (int i = 0; i < array.items.size(); ++i) {
            CDAResource item = (CDAResource)array.items.get(i);
            if (!item.id().equals(id)) continue;
            return (T)item;
        }
        return null;
    }

    public Flowable<CDAArray> all() {
        return this.client.cacheAll(false).flatMap((Function)new Function<Cache, Publisher<Response<CDAArray>>>(){

            public Publisher<Response<CDAArray>> apply(Cache cache) {
                return ObserveQuery.this.client.service.array(ObserveQuery.this.client.spaceId, ObserveQuery.this.client.environmentId, ObserveQuery.this.path(), ObserveQuery.this.params);
            }
        }).map((Function)new Function<Response<CDAArray>, CDAArray>(){

            public CDAArray apply(Response<CDAArray> response) {
                return ResourceFactory.array(response, ObserveQuery.this.client);
            }
        });
    }
}

