/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAService;
import com.contentful.java.cda.ClientContext;
import com.contentful.java.cda.ModuleAssets;
import com.contentful.java.cda.ModuleContentTypes;
import com.contentful.java.cda.ModuleEntries;
import com.contentful.java.cda.ModuleSpaces;
import com.contentful.java.cda.ModuleSync;
import com.contentful.java.cda.Platform;
import com.contentful.java.cda.PropertiesReader;
import com.contentful.java.cda.ResourceTypeAdapter;
import com.contentful.java.cda.SpaceWrapper;
import com.contentful.java.cda.model.CDAAsset;
import com.contentful.java.cda.model.CDAContentType;
import com.contentful.java.cda.model.CDAEntry;
import com.contentful.java.cda.model.CDAResource;
import com.contentful.java.cda.model.CDASpace;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDAClient {
    static String sUserAgent;
    final String accessToken;
    final String spaceKey;
    final String httpScheme;
    final Map<String, Class<?>> classMap;
    final PropertiesReader propertiesReader;
    final CDAService service;
    final Gson gson;
    final SpaceWrapper spaceWrapper;
    final Executor callbackExecutor;
    final ModuleAssets moduleAssets;
    final ModuleContentTypes moduleContentTypes;
    final ModuleEntries moduleEntries;
    final ModuleSpaces moduleSpaces;
    final ModuleSync moduleSync;

    private CDAClient(Builder builder) {
        if (builder.accessToken == null) {
            throw new IllegalArgumentException("Access token must be defined.");
        }
        if (builder.spaceKey == null) {
            throw new IllegalArgumentException("Space ID must be defined.");
        }
        this.spaceWrapper = new SpaceWrapper();
        this.propertiesReader = new PropertiesReader();
        this.spaceKey = builder.spaceKey;
        this.accessToken = builder.accessToken;
        this.classMap = this.createClassMap(builder);
        this.httpScheme = this.createHttpScheme(builder);
        this.callbackExecutor = this.createCallbackExecutor(builder);
        this.gson = this.createGson();
        this.service = this.createRetrofitService(builder);
        ClientContext context = new ClientContext(this.service, this.callbackExecutor, this.spaceKey, this.gson, this.spaceWrapper, this.classMap, builder.nullifyUnresolved);
        this.moduleAssets = new ModuleAssets(context);
        this.moduleContentTypes = new ModuleContentTypes(context);
        this.moduleEntries = new ModuleEntries(context);
        this.moduleSpaces = new ModuleSpaces(context);
        this.moduleSync = new ModuleSync(context);
    }

    public CDASpace getSpace() {
        return this.spaceWrapper.get();
    }

    public String getHttpScheme() {
        return this.httpScheme;
    }

    public ModuleAssets assets() {
        return this.moduleAssets;
    }

    public ModuleContentTypes contentTypes() {
        return this.moduleContentTypes;
    }

    public ModuleEntries entries() {
        return this.moduleEntries;
    }

    public ModuleSpaces spaces() {
        return this.moduleSpaces;
    }

    public ModuleSync synchronization() {
        return this.moduleSync;
    }

    String createUserAgent(PropertiesReader reader) {
        if (sUserAgent == null) {
            try {
                String versionName = reader.getField("version.name");
                sUserAgent = String.format("contentful.java/%s", versionName);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to retrieve version name.", e);
            }
        }
        return sUserAgent;
    }

    private Executor createCallbackExecutor(Builder builder) {
        if (builder.callbackExecutor == null) {
            return Platform.get().callbackExecutor();
        }
        return builder.callbackExecutor;
    }

    private String createHttpScheme(Builder builder) {
        if (builder.secure) {
            return "https";
        }
        return "http";
    }

    private Map<String, Class<?>> createClassMap(Builder builder) {
        if (builder.classMap == null) {
            return new HashMap();
        }
        return builder.classMap;
    }

    private CDAService createRetrofitService(Builder builder) {
        RestAdapter.Builder restBuilder = new RestAdapter.Builder().setConverter((Converter)new GsonConverter(this.gson)).setRequestInterceptor(this.createInterceptor());
        this.setEndPoint(builder, restBuilder);
        this.setClientProvider(builder, restBuilder);
        this.setLogLevel(builder, restBuilder);
        return (CDAService)restBuilder.build().create(CDAService.class);
    }

    private Gson createGson() {
        ResourceTypeAdapter rta = new ResourceTypeAdapter(this.spaceWrapper, this.classMap, this.httpScheme);
        return new GsonBuilder().registerTypeAdapter(CDAResource.class, (Object)rta).registerTypeAdapter(CDAAsset.class, (Object)rta).registerTypeAdapter(CDAContentType.class, (Object)rta).registerTypeAdapter(CDAEntry.class, (Object)rta).registerTypeAdapter(CDASpace.class, (Object)rta).create();
    }

    private void setLogLevel(Builder builder, RestAdapter.Builder restBuilder) {
        if (builder.logLevel != null) {
            restBuilder.setLogLevel(builder.logLevel);
        }
    }

    private void setClientProvider(Builder builder, RestAdapter.Builder restBuilder) {
        if (builder.clientProvider != null) {
            restBuilder.setClient(builder.clientProvider);
        }
    }

    private void setEndPoint(Builder builder, RestAdapter.Builder restBuilder) {
        String endpoint = builder.endpoint == null ? "cdn.contentful.com" : builder.endpoint;
        restBuilder.setEndpoint(String.format("%s://%s", this.httpScheme, endpoint));
    }

    private RequestInterceptor createInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade requestFacade) {
                if (CDAClient.this.accessToken != null && !CDAClient.this.accessToken.isEmpty()) {
                    requestFacade.addHeader("Authorization", String.format("Bearer %s", CDAClient.this.accessToken));
                }
                requestFacade.addHeader("User-Agent", CDAClient.this.createUserAgent(CDAClient.this.propertiesReader));
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        String accessToken;
        String spaceKey;
        Client.Provider clientProvider;
        String endpoint;
        RestAdapter.LogLevel logLevel;
        Executor callbackExecutor;
        Map<String, Class<?>> classMap;
        boolean secure = true;
        boolean nullifyUnresolved = false;

        public Builder setAccessToken(String accessToken) {
            if (accessToken == null) {
                throw new IllegalArgumentException("Cannot call setAccessToken() with null.");
            }
            this.accessToken = accessToken;
            return this;
        }

        public Builder setCallbackExecutor(Executor executor) {
            if (executor == null) {
                throw new IllegalArgumentException("Cannot call setCallbackExecutor() with null.");
            }
            this.callbackExecutor = executor;
            return this;
        }

        public Builder setCustomClasses(Map<String, Class<?>> classMap) {
            if (classMap == null) {
                throw new IllegalArgumentException("Cannot call setCustomClasses() with null.");
            }
            this.classMap = new HashMap();
            for (Map.Entry<String, Class<?>> entry : classMap.entrySet()) {
                this.classMap.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder setClient(final Client client) {
            if (client == null) {
                throw new IllegalArgumentException("Cannot call setClient() with null.");
            }
            return this.setClientProvider(new Client.Provider(){

                public Client get() {
                    return client;
                }
            });
        }

        public Builder setClientProvider(Client.Provider clientProvider) {
            if (clientProvider == null) {
                throw new IllegalArgumentException("Cannot call setClientProvider() with null.");
            }
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder setEndpoint(String remoteUrl) {
            if (remoteUrl == null) {
                throw new IllegalArgumentException("Cannot call setEndpoint() with null.");
            }
            this.endpoint = remoteUrl;
            return this;
        }

        public Builder setLogLevel(RestAdapter.LogLevel logLevel) {
            if (logLevel == null) {
                throw new IllegalArgumentException("Cannot call setLogLevel() with null.");
            }
            this.logLevel = logLevel;
            return this;
        }

        public Builder setSpaceKey(String spaceKey) {
            if (spaceKey == null) {
                throw new IllegalArgumentException("Cannot call setSpaceKey() with null.");
            }
            this.spaceKey = spaceKey;
            return this;
        }

        public Builder noSSL() {
            this.secure = false;
            return this;
        }

        public Builder preview() {
            return this.setEndpoint("preview.contentful.com");
        }

        public Builder nullifyUnresolvedLinks() {
            this.nullifyUnresolved = true;
            return this;
        }

        public CDAClient build() {
            return new CDAClient(this);
        }
    }
}

