/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.AbsModule;
import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.ClientContext;
import com.contentful.java.cda.RxExtensions;
import com.contentful.java.cda.SyncProcessor;
import com.contentful.java.cda.Utils;
import com.contentful.java.cda.model.CDASyncedSpace;
import retrofit.RetrofitError;
import rx.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleSync
extends AbsModule<ExtAsync, ExtRxJava> {
    public ModuleSync(ClientContext context) {
        super(context);
    }

    @Override
    public ExtAsync async() {
        return (ExtAsync)this.extAsync;
    }

    @Override
    public ExtRxJava rx() {
        return (ExtRxJava)this.extRxJava;
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    public CDASyncedSpace performInitial() {
        this.ensureSpaceForSync();
        try {
            return this.prepare(this.context.service.performSync(this.context.spaceId, true, null), true);
        }
        catch (Exception e) {
            throw RetrofitError.unexpectedError(null, (Throwable)e);
        }
    }

    public CDASyncedSpace performWithSpace(CDASyncedSpace syncedSpace) {
        this.ensureSpaceForSync();
        String syncToken = syncedSpace.getSyncToken();
        if (syncToken == null) {
            throw new IllegalArgumentException("performWithSpace() called for a space with no sync token.");
        }
        try {
            return this.prepare(syncedSpace, this.context.service.performSync(this.context.spaceId, null, syncToken), true);
        }
        catch (Exception e) {
            throw RetrofitError.unexpectedError(null, (Throwable)e);
        }
    }

    public CDASyncedSpace performWithToken(String syncToken) {
        return this.performWithToken(syncToken, true);
    }

    private CDASyncedSpace performWithToken(String syncToken, boolean iterate) {
        this.ensureSpaceForSync();
        Utils.assertNotNull(syncToken, "syncToken");
        try {
            return this.prepare(this.context.service.performSync(this.context.spaceId, null, syncToken), iterate);
        }
        catch (Exception e) {
            throw RetrofitError.unexpectedError(null, (Throwable)e);
        }
    }

    CDASyncedSpace prepare(CDASyncedSpace syncedSpace, boolean iterate) throws Exception {
        return this.prepare(null, syncedSpace, iterate);
    }

    CDASyncedSpace prepare(CDASyncedSpace originalSpace, CDASyncedSpace updatedSpace, boolean iterate) throws Exception {
        CDASyncedSpace result = SyncProcessor.newInstance(originalSpace, updatedSpace, this.context).call();
        if (iterate) {
            result = this.iterateSpace(result);
        }
        return result;
    }

    void ensureSpaceForSync() {
        this.ensureSpace(true);
    }

    CDASyncedSpace iterateSpace(CDASyncedSpace syncedSpace) throws Exception {
        String nextPageUrl = syncedSpace.getNextPageUrl();
        while (nextPageUrl != null) {
            String syncToken = Utils.getQueryParamFromUrl(nextPageUrl, "sync_token");
            CDASyncedSpace nextPage = this.performWithToken(syncToken, false);
            syncedSpace = SyncProcessor.newInstance(syncedSpace, nextPage, this.context).call();
            nextPageUrl = nextPage.getNextPageUrl();
        }
        return syncedSpace;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExtRxJava
    extends AbsModule.Rx {
        public Observable<CDASyncedSpace> performInitial() {
            return RxExtensions.defer(new RxExtensions.DefFunc<CDASyncedSpace>(){

                @Override
                CDASyncedSpace method() {
                    return ModuleSync.this.performInitial();
                }
            });
        }

        public Observable<CDASyncedSpace> performWithSpace(final CDASyncedSpace syncedSpace) {
            return RxExtensions.defer(new RxExtensions.DefFunc<CDASyncedSpace>(){

                @Override
                CDASyncedSpace method() {
                    return ModuleSync.this.performWithSpace(syncedSpace);
                }
            });
        }

        public Observable<CDASyncedSpace> performWithToken(final String syncToken) {
            return RxExtensions.defer(new RxExtensions.DefFunc<CDASyncedSpace>(){

                @Override
                CDASyncedSpace method() {
                    return ModuleSync.this.performWithToken(syncToken);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExtAsync
    extends AbsModule.Async {
        public CDACallback<CDASyncedSpace> performInitial(CDACallback<CDASyncedSpace> callback) {
            return RxExtensions.subscribe(ModuleSync.this.rx().performInitial(), callback, ModuleSync.this.context);
        }

        public CDACallback<CDASyncedSpace> performWithSpace(CDASyncedSpace syncedSpace, CDACallback<CDASyncedSpace> callback) {
            return RxExtensions.subscribe(ModuleSync.this.rx().performWithSpace(syncedSpace), callback, ModuleSync.this.context);
        }

        public CDACallback<CDASyncedSpace> performWithToken(String syncToken, CDACallback<CDASyncedSpace> callback) {
            return RxExtensions.subscribe(ModuleSync.this.rx().performWithToken(syncToken), callback, ModuleSync.this.context);
        }
    }
}

