/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.ArrayParser;
import com.contentful.java.cda.ClientContext;
import com.contentful.java.cda.Constants;
import com.contentful.java.cda.Utils;
import com.contentful.java.cda.model.CDAResource;
import com.contentful.java.cda.model.CDASyncedSpace;
import java.util.ArrayList;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SyncProcessor
implements Callable<CDASyncedSpace> {
    private final CDASyncedSpace originalSpace;
    private final CDASyncedSpace updatedSpace;
    private final ClientContext context;

    private SyncProcessor(CDASyncedSpace originalSpace, CDASyncedSpace updatedSpace, ClientContext context) {
        this.originalSpace = originalSpace;
        this.updatedSpace = updatedSpace;
        this.context = context;
    }

    public static SyncProcessor newInstance(CDASyncedSpace originalSpace, CDASyncedSpace updatedSpace, ClientContext context) {
        return new SyncProcessor(originalSpace, updatedSpace, context);
    }

    @Override
    public CDASyncedSpace call() throws Exception {
        String nextSyncUrl;
        if (this.originalSpace != null) {
            ArrayList<CDAResource> originalItems = new ArrayList<CDAResource>(this.originalSpace.getItems());
            ArrayList<CDAResource> updatedItems = this.updatedSpace.getItems();
            for (int i = updatedItems.size() - 1; i >= 0; --i) {
                CDAResource item = updatedItems.get(i);
                Constants.CDAResourceType resourceType = Constants.CDAResourceType.valueOf((String)item.getSys().get("type"));
                if (Constants.CDAResourceType.DeletedAsset.equals((Object)resourceType)) {
                    item.getSys().put("type", Constants.CDAResourceType.Asset.toString());
                    originalItems.remove(item);
                    continue;
                }
                if (Constants.CDAResourceType.DeletedEntry.equals((Object)resourceType)) {
                    item.getSys().put("type", Constants.CDAResourceType.Entry.toString());
                    originalItems.remove(item);
                    continue;
                }
                if (!Constants.CDAResourceType.Asset.equals((Object)resourceType) && !Constants.CDAResourceType.Entry.equals((Object)resourceType)) continue;
                originalItems.remove(item);
                originalItems.add(0, item);
            }
            updatedItems.clear();
            updatedItems.addAll(originalItems);
        }
        if ((nextSyncUrl = this.updatedSpace.getNextSyncUrl()) != null) {
            this.updatedSpace.setSyncToken(Utils.getQueryParamFromUrl(nextSyncUrl, "sync_token"));
        }
        return (CDASyncedSpace)new ArrayParser<CDASyncedSpace>(this.updatedSpace, this.context).call();
    }
}

