/*
 * Copyright (C) 2014 Contentful GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.contentful.java.cda;

import java.io.IOException;
import java.util.Properties;

/**
 * PropertiesReader.
 */
class PropertiesReader {
  PropertiesReader() {
  }

  String getField(String field) throws IOException {
    Properties properties = new Properties();
    properties.load(PropertiesReader.class.getClassLoader().getResourceAsStream(
        Constants.SDK_PROPERTIES));
    return properties.getProperty(field);
  }
}
