/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.AbsModule;
import com.contentful.java.cda.ArrayParser;
import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.ClientContext;
import com.contentful.java.cda.RxExtensions;
import com.contentful.java.cda.Utils;
import com.contentful.java.cda.model.CDAArray;
import com.contentful.java.cda.model.CDAResource;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import retrofit.RetrofitError;
import retrofit.client.Response;
import rx.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseModule<T extends CDAResource>
extends AbsModule<ExtAsync, ExtRxJava> {
    public BaseModule(ClientContext context) {
        super(context);
    }

    abstract String getResourcePath();

    abstract T createCdaResource(InputStreamReader var1);

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    public CDAArray fetchAll() {
        return this.fetchAll(null);
    }

    public CDAArray fetchAll(Map<String, String> query) {
        this.ensureSpace();
        return this.fetchArray(this.getResourcePath(), query);
    }

    public T fetchOne(String identifier) {
        this.ensureSpace();
        Utils.assertNotNull(identifier, "identifier");
        Response response = this.context.service.fetchResource(this.context.spaceId, this.getResourcePath(), identifier);
        try {
            return this.prepare((CDAResource)this.createCdaResource(new InputStreamReader(response.getBody().in())));
        }
        catch (Exception e) {
            throw RetrofitError.unexpectedError((String)response.getUrl(), (Throwable)e);
        }
    }

    CDAArray fetchArray(String type, Map<String, String> query) {
        Utils.assertNotNull(type, "type");
        this.ensureSpace();
        Response response = this.context.service.fetchArray(this.context.spaceId, type, query);
        try {
            CDAArray array = (CDAArray)this.context.gson.fromJson((Reader)new InputStreamReader(response.getBody().in()), CDAArray.class);
            array.setOriginalUrl(response.getUrl());
            return (CDAArray)this.prepare(new ArrayParser<CDAArray>(array, this.context).call());
        }
        catch (Exception e) {
            throw RetrofitError.unexpectedError((String)response.getUrl(), (Throwable)e);
        }
    }

    <E extends CDAResource> E prepare(E resource) {
        return resource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExtRxJava
    extends AbsModule.Rx {
        public Observable<CDAArray> fetchAll() {
            return this.fetchAll(null);
        }

        public Observable<CDAArray> fetchAll(final Map<String, String> query) {
            return RxExtensions.defer(new RxExtensions.DefFunc<CDAArray>(){

                @Override
                CDAArray method() {
                    return BaseModule.this.fetchAll(query);
                }
            });
        }

        public Observable<T> fetchOne(final String identifier) {
            return RxExtensions.defer(new RxExtensions.DefFunc<T>(){

                @Override
                T method() {
                    return BaseModule.this.fetchOne(identifier);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExtAsync
    extends AbsModule.Async {
        public CDACallback<CDAArray> fetchAll(CDACallback<CDAArray> callback) {
            return RxExtensions.subscribe(((ExtRxJava)BaseModule.this.rx()).fetchAll(), callback, BaseModule.this.context);
        }

        public CDACallback<CDAArray> fetchAll(Map<String, String> query, CDACallback<CDAArray> callback) {
            return RxExtensions.subscribe(((ExtRxJava)BaseModule.this.rx()).fetchAll(query), callback, BaseModule.this.context);
        }

        public CDACallback<T> fetchOne(String identifier, CDACallback<T> callback) {
            return RxExtensions.subscribe(((ExtRxJava)BaseModule.this.rx()).fetchOne(identifier), callback, BaseModule.this.context);
        }
    }
}

