/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.ClientContext;
import com.contentful.java.cda.Utils;
import java.util.concurrent.Executor;
import retrofit.RetrofitError;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.schedulers.Schedulers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RxExtensions {
    private RxExtensions() {
        throw new UnsupportedOperationException();
    }

    static <R> Observable<R> defer(DefFunc<R> func) {
        return Observable.defer(func).subscribeOn(Schedulers.io());
    }

    static <R> CDACallback<R> subscribe(Observable<R> observable, CDACallback<R> callback, ClientContext context) {
        Utils.assertNotNull(callback, "callback");
        observable.subscribe(new ActionSuccess<R>(context.callbackExecutor, callback), (Action1)new ActionError(context.callbackExecutor, (CDACallback)callback));
        return callback;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class DefFunc<T>
    implements Func0<Observable<T>> {
        DefFunc() {
        }

        public final Observable<T> call() {
            return Observable.just(this.method());
        }

        abstract T method();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActionError
    extends AbsAction<Throwable> {
        public ActionError(Executor executor, CDACallback callback) {
            super(executor, callback);
        }

        public void call(Throwable t) {
            final RetrofitError retrofitError = t instanceof RetrofitError ? (RetrofitError)t : RetrofitError.unexpectedError(null, (Throwable)t);
            if (!this.callback.isCancelled()) {
                this.executor.execute(new Runnable(){

                    public void run() {
                        ActionError.this.callback.onFailure(retrofitError);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActionSuccess<T>
    extends AbsAction<T> {
        public ActionSuccess(Executor executor, CDACallback<T> callback) {
            super(executor, callback);
        }

        public void call(final T t) {
            if (!this.callback.isCancelled()) {
                this.executor.execute(new Runnable(){

                    public void run() {
                        ActionSuccess.this.callback.onSuccess(t);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbsAction<T>
    implements Action1<T> {
        final Executor executor;
        final CDACallback<T> callback;

        public AbsAction(Executor executor, CDACallback<T> callback) {
            this.executor = executor;
            this.callback = callback;
        }
    }
}

