/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import android.os.Build;
import com.contentful.java.cda.Utils;
import java.util.concurrent.Executor;
import retrofit.android.MainThreadExecutor;

abstract class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new Base();
    }

    abstract Executor callbackExecutor();

    private static class Android
    extends Platform {
        private Android() {
        }

        @Override
        Executor callbackExecutor() {
            return new MainThreadExecutor();
        }
    }

    private static class Base
    extends Platform {
        private Base() {
        }

        @Override
        Executor callbackExecutor() {
            return new Utils.SynchronousExecutor();
        }
    }
}

