/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.ArrayResource;
import com.contentful.java.cda.CDAAsset;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.CDAContentType;
import com.contentful.java.cda.CDAEntry;
import com.contentful.java.cda.CDAField;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDASpace;
import com.contentful.java.cda.CDAType;
import com.contentful.java.cda.Constants;
import com.contentful.java.cda.LocalizedResource;
import com.contentful.java.cda.ResourceFactory;
import com.contentful.java.cda.SynchronizedSpace;
import com.contentful.java.cda.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import retrofit.client.Response;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

final class ResourceUtils {
    private ResourceUtils() {
        throw new AssertionError();
    }

    static SynchronizedSpace iterate(Response response, CDAClient client) {
        SynchronizedSpace nextSpace;
        SynchronizedSpace result = ResourceFactory.fromResponse(response, SynchronizedSpace.class);
        List items = result.items;
        while ((nextSpace = ResourceUtils.nextSpace(result, client)) != null) {
            items.addAll(nextSpace.items());
            result = nextSpace;
        }
        result.items = items;
        ResourceUtils.localizeResources(result.items(), client.cache.space());
        return result;
    }

    static SynchronizedSpace nextSpace(SynchronizedSpace space, CDAClient client) {
        String nextPageUrl = space.nextPageUrl();
        if (nextPageUrl == null) {
            return null;
        }
        Response response = (Response)client.service.sync(client.spaceId, null, Util.queryParam(nextPageUrl, "sync_token")).toBlocking().first();
        return ResourceFactory.fromResponse(response, SynchronizedSpace.class);
    }

    static void resolveLinks(ArrayResource array, CDAClient client) {
        for (CDAEntry entry : array.entries().values()) {
            ResourceUtils.ensureContentType(entry, client);
            for (CDAField field : entry.contentType().fields()) {
                if (field.linkType() != null) {
                    ResourceUtils.resolveSingleLink(entry, field, array);
                    continue;
                }
                if (!"Array".equals(field.type) || !"Link".equals(field.items().get("type"))) continue;
                ResourceUtils.resolveArrayOfLinks(entry, field, array);
            }
        }
    }

    static void ensureContentType(CDAEntry entry, CDAClient client) {
        CDAContentType contentType = entry.contentType();
        if (contentType != null) {
            return;
        }
        String id = (String)Util.extractNested(entry.attrs(), "contentType", "sys", "id");
        contentType = (CDAContentType)client.cacheTypeWithId(id).toBlocking().first();
        if (contentType == null) {
            throw new RuntimeException(String.format("Entry '%s' has non-existing content type mapping '%s'.", entry.id(), id));
        }
        entry.setContentType(contentType);
    }

    static void resolveArrayOfLinks(CDAEntry entry, CDAField field, ArrayResource array) {
        CDAType linkType = CDAType.valueOf(((String)field.items().get("linkType")).toUpperCase(Constants.LOCALE));
        Map value = (Map)entry.fields.get(field.id());
        if (value == null) {
            return;
        }
        for (String locale : value.keySet()) {
            List links = (List)value.get(locale);
            if (links == null) continue;
            ArrayList<CDAResource> resolved = new ArrayList<CDAResource>();
            for (int i = 0; i < links.size(); ++i) {
                CDAResource resource;
                String linkId = ResourceUtils.getLinkId(links.get(i));
                if (linkId == null || (resource = ResourceUtils.findLinkedResource(array, linkType, linkId)) == null) continue;
                resolved.add(resource);
            }
            value.put(locale, resolved);
        }
    }

    static void resolveSingleLink(CDAEntry entry, CDAField field, ArrayResource array) {
        CDAType linkType = CDAType.valueOf(field.linkType().toUpperCase(Constants.LOCALE));
        Map value = (Map)entry.fields.get(field.id());
        if (value == null) {
            return;
        }
        for (String locale : value.keySet()) {
            String linkId = ResourceUtils.getLinkId(value.get(locale));
            if (linkId == null) continue;
            CDAResource resource = ResourceUtils.findLinkedResource(array, linkType, linkId);
            if (resource == null) {
                value.remove(locale);
                continue;
            }
            value.put(locale, resource);
        }
    }

    static String getLinkId(Object link) {
        if (link == null) {
            return null;
        }
        if (link instanceof CDAResource) {
            return ((CDAResource)link).id();
        }
        return (String)Util.extractNested((Map)link, "sys", "id");
    }

    static CDAResource findLinkedResource(ArrayResource array, CDAType linkType, String id) {
        if (CDAType.ASSET.equals((Object)linkType)) {
            return array.assets().get(id);
        }
        if (CDAType.ENTRY.equals((Object)linkType)) {
            return array.entries().get(id);
        }
        return null;
    }

    static void mapResources(Collection<? extends CDAResource> resources, Map<String, CDAAsset> assets, Map<String, CDAEntry> entries) {
        for (CDAResource cDAResource : resources) {
            CDAType type = cDAResource.type();
            String id = cDAResource.id();
            if (CDAType.ASSET.equals((Object)type)) {
                assets.put(id, (CDAAsset)cDAResource);
                continue;
            }
            if (CDAType.DELETEDASSET.equals((Object)type)) {
                assets.remove(id);
                continue;
            }
            if (CDAType.DELETEDENTRY.equals((Object)type)) {
                entries.remove(id);
                continue;
            }
            if (!CDAType.ENTRY.equals((Object)type)) continue;
            entries.put(id, (CDAEntry)cDAResource);
        }
    }

    static void mapDeletedResources(SynchronizedSpace space) {
        final HashSet<Object> assets = space.deletedAssets == null ? new HashSet() : new HashSet<String>(space.deletedAssets);
        final HashSet<Object> entries = space.deletedEntries == null ? new HashSet() : new HashSet<String>(space.deletedEntries);
        Observable.from((Iterable)space.items()).filter((Func1)new Func1<CDAResource, Boolean>(){

            public Boolean call(CDAResource resource) {
                CDAType type = resource.type();
                return CDAType.DELETEDASSET.equals((Object)type) || CDAType.DELETEDENTRY.equals((Object)type);
            }
        }).subscribe((Action1)new Action1<CDAResource>(){

            public void call(CDAResource resource) {
                if (CDAType.DELETEDASSET.equals((Object)resource.type())) {
                    assets.add(resource.id());
                } else {
                    entries.add(resource.id());
                }
            }
        });
        space.deletedAssets = assets;
        space.deletedEntries = entries;
    }

    static void localizeResources(Collection<? extends CDAResource> resources, CDASpace space) {
        for (CDAResource cDAResource : resources) {
            CDAType type = cDAResource.type();
            if (!CDAType.ASSET.equals((Object)type) && !CDAType.ENTRY.equals((Object)type)) continue;
            ResourceUtils.localize((LocalizedResource)cDAResource, space);
        }
    }

    static void localize(LocalizedResource resource, CDASpace space) {
        resource.setDefaultLocale(space.defaultLocale().code());
        String resourceLocale = (String)resource.getAttribute("locale");
        if (resourceLocale == null) {
            resource.setLocale(resource.defaultLocale());
        } else {
            resource.setLocale(resourceLocale);
            ResourceUtils.normalizeFields(resource);
        }
    }

    static void normalizeFields(LocalizedResource resource) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (String key : resource.fields.keySet()) {
            Object value = resource.fields.get(key);
            if (value == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(resource.locale(), value);
            fields.put(key, map);
        }
        resource.fields = fields;
    }

    static void setRawFields(ArrayResource array) {
        for (CDAAsset asset : array.assets().values()) {
            ResourceUtils.setRawFields(asset);
        }
        for (CDAEntry entry : array.entries().values()) {
            ResourceUtils.setRawFields(entry);
        }
    }

    private static void setRawFields(LocalizedResource resource) {
        HashMap<String, Object> rawFields = new HashMap<String, Object>();
        for (String key : resource.fields.keySet()) {
            HashMap map = new HashMap();
            map.putAll((Map)resource.fields.get(key));
            rawFields.put(key, map);
        }
        resource.rawFields = rawFields;
    }
}

