/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAArray;
import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.CDAContentType;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDAService;
import com.contentful.java.cda.CDASpace;
import com.contentful.java.cda.Cache;
import com.contentful.java.cda.Callbacks;
import com.contentful.java.cda.FetchQuery;
import com.contentful.java.cda.Interceptor;
import com.contentful.java.cda.ObserveQuery;
import com.contentful.java.cda.Platform;
import com.contentful.java.cda.ResourceFactory;
import com.contentful.java.cda.SyncQuery;
import com.contentful.java.cda.SynchronizedSpace;
import com.contentful.java.cda.Util;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.Response;
import rx.Observable;
import rx.functions.Func1;

public final class CDAClient {
    final String spaceId;
    final String token;
    final CDAService service;
    final Cache cache;
    final Executor callbackExecutor;

    private CDAClient(Builder builder) {
        this.validate(builder);
        this.spaceId = builder.space;
        this.token = builder.token;
        this.service = this.createService(builder);
        this.cache = new Cache();
        this.callbackExecutor = Platform.get().callbackExecutor();
    }

    private void validate(Builder builder) {
        Util.checkNotNull(builder.space, "Space ID must be provided.", new Object[0]);
        Util.checkNotNull(builder.token, "Access token must be provided.", new Object[0]);
    }

    private CDAService createService(Builder clientBuilder) {
        String endpoint = clientBuilder.endpoint;
        if (endpoint == null) {
            endpoint = "https://cdn.contentful.com";
        }
        RestAdapter.Builder restBuilder = new RestAdapter.Builder().setEndpoint(endpoint).setRequestInterceptor((RequestInterceptor)new Interceptor(this.token));
        this.setLogLevel(restBuilder, clientBuilder);
        this.setClient(restBuilder, clientBuilder);
        return (CDAService)restBuilder.build().create(CDAService.class);
    }

    private void setClient(RestAdapter.Builder restBuilder, Builder clientBuilder) {
        if (clientBuilder.client != null) {
            restBuilder.setClient(clientBuilder.client);
        }
    }

    private void setLogLevel(RestAdapter.Builder restBuilder, Builder clientBuilder) {
        if (clientBuilder.logLevel != null) {
            restBuilder.setLogLevel(clientBuilder.logLevel);
        }
    }

    public <T extends CDAResource> FetchQuery<T> fetch(Class<T> type) {
        return new FetchQuery<T>(type, this);
    }

    public <T extends CDAResource> ObserveQuery<T> observe(Class<T> type) {
        return new ObserveQuery<T>(type, this);
    }

    public SyncQuery sync() {
        return this.sync(null, null);
    }

    public SyncQuery sync(String syncToken) {
        return this.sync(syncToken, null);
    }

    public SyncQuery sync(SynchronizedSpace synchronizedSpace) {
        return this.sync(null, synchronizedSpace);
    }

    private SyncQuery sync(String syncToken, SynchronizedSpace synchronizedSpace) {
        SyncQuery.Builder builder = SyncQuery.builder().setClient(this);
        if (synchronizedSpace != null) {
            builder.setSpace(synchronizedSpace);
        }
        if (syncToken != null) {
            builder.setSyncToken(syncToken);
        }
        return builder.build();
    }

    public CDASpace fetchSpace() {
        return (CDASpace)this.observeSpace().toBlocking().first();
    }

    public <C extends CDACallback<CDASpace>> C fetchSpace(C callback) {
        return (C)Callbacks.subscribeAsync(this.observeSpace(), callback, this);
    }

    public Observable<CDASpace> observeSpace() {
        return this.cacheSpace(true);
    }

    Observable<Cache> cacheAll(final boolean invalidate) {
        return this.cacheSpace(invalidate).flatMap((Func1)new Func1<CDASpace, Observable<Map<String, CDAContentType>>>(){

            public Observable<Map<String, CDAContentType>> call(CDASpace cdaSpace) {
                return CDAClient.this.cacheTypes(invalidate);
            }
        }).map((Func1)new Func1<Map<String, CDAContentType>, Cache>(){

            public Cache call(Map<String, CDAContentType> stringCDAContentTypeMap) {
                return CDAClient.this.cache;
            }
        });
    }

    Observable<CDASpace> cacheSpace(boolean invalidate) {
        CDASpace space;
        CDASpace cDASpace = space = invalidate ? null : this.cache.space();
        if (space == null) {
            return this.service.space(this.spaceId).map((Func1)new Func1<Response, CDASpace>(){

                public CDASpace call(Response response) {
                    CDASpace tmp = ResourceFactory.space(response);
                    CDAClient.this.cache.setSpace(tmp);
                    return tmp;
                }
            });
        }
        return Observable.just((Object)space);
    }

    Observable<Map<String, CDAContentType>> cacheTypes(boolean invalidate) {
        Map<String, CDAContentType> types;
        Map<String, CDAContentType> map = types = invalidate ? null : this.cache.types();
        if (types == null) {
            return this.service.array(this.spaceId, "content_types", null).map((Func1)new Func1<Response, Map<String, CDAContentType>>(){

                public Map<String, CDAContentType> call(Response response) {
                    CDAArray array = ResourceFactory.array(response, CDAClient.this);
                    ConcurrentHashMap<String, CDAContentType> tmp = new ConcurrentHashMap<String, CDAContentType>();
                    for (CDAResource resource : array.items()) {
                        tmp.put(resource.id(), (CDAContentType)resource);
                    }
                    CDAClient.this.cache.setTypes(tmp);
                    return tmp;
                }
            });
        }
        return Observable.just(types);
    }

    Observable<CDAContentType> cacheTypeWithId(String id) {
        CDAContentType contentType = this.cache.types().get(id);
        if (contentType == null) {
            return this.observe(CDAContentType.class).one(id).map((Func1)new Func1<CDAContentType, CDAContentType>(){

                public CDAContentType call(CDAContentType resource) {
                    if (resource != null) {
                        CDAClient.this.cache.types().put(resource.id(), resource);
                    }
                    return resource;
                }
            });
        }
        return Observable.just((Object)contentType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String space;
        String token;
        String endpoint;
        RestAdapter.LogLevel logLevel;
        Client client;

        private Builder() {
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setLogLevel(RestAdapter.LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder preview() {
            return this.setEndpoint("https://preview.contentful.com");
        }

        public Builder setClient(Client client) {
            this.client = client;
            return this;
        }

        public CDAClient build() {
            return new CDAClient(this);
        }
    }
}

