/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.CDAClient;
import com.contentful.java.cda.Cache;
import com.contentful.java.cda.Callbacks;
import com.contentful.java.cda.ResourceFactory;
import com.contentful.java.cda.SynchronizedSpace;
import com.contentful.java.cda.Util;
import retrofit.client.Response;
import rx.Observable;
import rx.functions.Func1;

public class SyncQuery {
    final CDAClient client;
    final String syncToken;
    final SynchronizedSpace space;
    final boolean initial;

    private SyncQuery(Builder builder) {
        this.client = Util.checkNotNull(builder.client, "Client must not be null.", new Object[0]);
        this.syncToken = builder.syncToken;
        this.space = builder.space;
        this.initial = this.space == null && this.syncToken == null;
    }

    public Observable<SynchronizedSpace> observe() {
        String token;
        if (this.space != null) {
            String nextSyncUrl = this.space.nextSyncUrl();
            if (nextSyncUrl == null) {
                throw new IllegalArgumentException("Provided space for synchronization is corrupt.");
            }
            token = Util.queryParam(this.space.nextSyncUrl(), "sync_token");
        } else {
            token = this.syncToken;
        }
        return this.client.cacheAll(true).flatMap((Func1)new Func1<Cache, Observable<Response>>(){

            public Observable<Response> call(Cache cache) {
                return SyncQuery.this.client.service.sync(SyncQuery.this.client.spaceId, SyncQuery.this.initial ? Boolean.valueOf(SyncQuery.this.initial) : null, token);
            }
        }).map((Func1)new Func1<Response, SynchronizedSpace>(){

            public SynchronizedSpace call(Response response) {
                return ResourceFactory.sync(response, SyncQuery.this.space, SyncQuery.this.client);
            }
        });
    }

    public SynchronizedSpace fetch() {
        return (SynchronizedSpace)this.observe().toBlocking().first();
    }

    public <C extends CDACallback<SynchronizedSpace>> C fetch(C callback) {
        return (C)Callbacks.subscribeAsync(this.observe(), callback, this.client);
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        CDAClient client;
        String syncToken;
        SynchronizedSpace space;

        Builder() {
        }

        Builder setClient(CDAClient client) {
            this.client = client;
            return this;
        }

        Builder setSyncToken(String syncToken) {
            this.syncToken = syncToken;
            return this;
        }

        Builder setSpace(SynchronizedSpace space) {
            this.space = space;
            return this;
        }

        SyncQuery build() {
            return new SyncQuery(this);
        }
    }
}

