/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import java.util.Locale;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;

public class CDAHttpException
extends RuntimeException {
    private final Request request;
    private final Response response;

    public CDAHttpException(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public String toString() {
        return String.format(Locale.getDefault(), "FAILED REQUEST:\n\t%s\n\t\u21b3 Header{%s}\n\t%s\n\t\u21b3 Header{%s}", this.request.toString(), this.headersToString(this.request.headers()), this.response.toString(), this.headersToString(this.response.headers()));
    }

    public int responseCode() {
        return this.response.code();
    }

    public String responseMessage() {
        return this.response.message();
    }

    public int rateLimitHourLimit() {
        return this.parseRateLimitHeader("X-Contentful-RateLimit-Hour-Limit");
    }

    public int rateLimitHourRemaining() {
        return this.parseRateLimitHeader("X-Contentful-RateLimit-Hour-Remaining");
    }

    public int rateLimitSecondLimit() {
        return this.parseRateLimitHeader("X-Contentful-RateLimit-Second-Limit");
    }

    public int rateLimitSecondRemaining() {
        return this.parseRateLimitHeader("X-Contentful-RateLimit-Second-Remaining");
    }

    public int rateLimitReset() {
        return this.parseRateLimitHeader("X-Contentful-RateLimit-Reset");
    }

    private String headersToString(Headers headers) {
        StringBuilder builder = new StringBuilder();
        String divider = "";
        for (String name : headers.names()) {
            String value = headers.get(name);
            builder.append(divider);
            builder.append(name);
            builder.append(": ");
            builder.append(value);
            if (!"".equals(divider)) continue;
            divider = ", ";
        }
        return builder.toString();
    }

    private int parseRateLimitHeader(String name) {
        try {
            return Integer.parseInt(this.response.header(name));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

