/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import java.io.IOException;
import java.util.Locale;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;

public class CDAHttpException
extends RuntimeException {
    private final Request request;
    private final Response response;
    private final String responseBody;
    private final String stringRepresentation;

    public CDAHttpException(Request request, Response response) {
        this.request = request;
        this.response = response;
        this.responseBody = this.readResponseBody(response);
        this.stringRepresentation = this.createString();
    }

    private String readResponseBody(Response response) {
        try {
            return response.body().string();
        }
        catch (IOException ioException) {
            return "<io exception while parsing body: " + ioException.toString() + ">";
        }
    }

    private String createString() {
        return String.format(Locale.getDefault(), "FAILED REQUEST:\n\t%s\n\t\u2570\u2192 Header{%s}\n\t%s\n\t\u251c\u2192 Body{%s}\n\t\u2570\u2192 Header{%s}", this.request.toString(), this.headersToString(this.request.headers()), this.response.toString(), this.responseBody, this.headersToString(this.response.headers()));
    }

    @Override
    public String toString() {
        return this.stringRepresentation;
    }

    public int responseCode() {
        return this.response.code();
    }

    public String responseMessage() {
        return this.response.message();
    }

    public String responseBody() {
        return this.responseBody;
    }

    public int rateLimitHourLimit() {
        return this.parseRateLimitHeader("X-Contentful-RateLimit-Hour-Limit");
    }

    public int rateLimitHourRemaining() {
        return this.parseRateLimitHeader("X-Contentful-RateLimit-Hour-Remaining");
    }

    public int rateLimitSecondLimit() {
        return this.parseRateLimitHeader("X-Contentful-RateLimit-Second-Limit");
    }

    public int rateLimitSecondRemaining() {
        return this.parseRateLimitHeader("X-Contentful-RateLimit-Second-Remaining");
    }

    public int rateLimitReset() {
        return this.parseRateLimitHeader("X-Contentful-RateLimit-Reset");
    }

    private String headersToString(Headers headers) {
        StringBuilder builder = new StringBuilder();
        String divider = "";
        for (String name : headers.names()) {
            String value = headers.get(name);
            builder.append(divider);
            builder.append(name);
            builder.append(": ");
            builder.append(value);
            if (!"".equals(divider)) continue;
            divider = ", ";
        }
        return builder.toString();
    }

    private int parseRateLimitHeader(String name) {
        try {
            return Integer.parseInt(this.response.header(name));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

