/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda.interceptor;

import com.contentful.java.cda.interceptor.HeaderInterceptor;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentfulUserAgentHeaderInterceptor
extends HeaderInterceptor {
    public static final String HEADER_NAME = "X-Contentful-User-Agent";

    public ContentfulUserAgentHeaderInterceptor(Section ... sections) {
        super(HEADER_NAME, ContentfulUserAgentHeaderInterceptor.sectionsToString(ContentfulUserAgentHeaderInterceptor.checkSections(sections)));
    }

    private static Section[] checkSections(Section[] sections) {
        if (sections == null || sections.length <= 0) {
            throw new IllegalArgumentException("sections cannot be empty.");
        }
        return sections;
    }

    private static String sectionsToString(Section[] sections) {
        LinkedHashMap<String, Section> mappedSections = new LinkedHashMap<String, Section>();
        for (Section section : sections) {
            if (section == null) continue;
            String identifier = section.getIdentifier();
            mappedSections.put(identifier, section);
        }
        StringBuilder builder = new StringBuilder();
        for (Section section : mappedSections.values()) {
            builder.append(section.toString());
        }
        return builder.toString();
    }

    public static class Section {
        private static final String APP = "app";
        private static final String INTEGRATION = "integration";
        private static final String SDK = "sdk";
        private static final String PLATFORM = "platform";
        private static final String OS = "os";
        private final String identifier;
        private final String name;
        private final Version version;

        public static Section integration(String name, Version version) {
            return new Section(INTEGRATION, name, version);
        }

        public static Section sdk(String name, Version version) {
            return new Section(SDK, name, version);
        }

        public static Section platform(String name, Version version) {
            return new Section(PLATFORM, name, version);
        }

        public static Section os(String name, Version version) {
            return new Section(OS, name, version);
        }

        public static Section app(String name, Version version) {
            return new Section(APP, Section.check(name).replace(" ", ""), version);
        }

        private static String check(String name) {
            if (name == null || name.length() <= 0) {
                throw new IllegalArgumentException("Cannot have an empty name for a section.");
            }
            return name;
        }

        private Section(String identifier, String name, Version version) {
            this.identifier = identifier;
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            if (this.getVersion() == null) {
                return String.format(Locale.getDefault(), "%s %s; ", this.getIdentifier(), this.getName());
            }
            return String.format(Locale.getDefault(), "%s %s/%s; ", this.getIdentifier(), this.getName(), this.getVersion().toString());
        }

        public static class Version {
            private static final String VERSION_REGEX = "^([0-9]+).([0-9]+).([0-9]+)(.*)?$";
            private static final Pattern VERSION_PATTERN = Pattern.compile("^([0-9]+).([0-9]+).([0-9]+)(.*)?$");
            private static final String STABILITY_REGEX = "^([a-zA-Z]+[0-9]*).*";
            private static final Pattern STABILITY_PATTERN = Pattern.compile("^([a-zA-Z]+[0-9]*).*");
            private final int major;
            private final int minor;
            private final int patch;
            private final String stability;

            public static Version parse(String version) {
                Matcher matcher = VERSION_PATTERN.matcher(version);
                if (matcher.find() && matcher.groupCount() == 4) {
                    int major = Integer.parseInt(matcher.group(1));
                    int minor = Integer.parseInt(matcher.group(2));
                    int patch = Integer.parseInt(matcher.group(3));
                    String stability = Version.parseStability(matcher.group(4));
                    return new Version(major, minor, patch, stability);
                }
                throw new IllegalArgumentException("Could not parse version: " + version);
            }

            private static String parseStability(String stability) {
                if (!stability.startsWith("-")) {
                    return null;
                }
                Matcher matcher = STABILITY_PATTERN.matcher(stability = stability.substring(1));
                if (matcher.find()) {
                    return matcher.group(0);
                }
                return null;
            }

            public Version(int major, int minor, int patch) {
                this(major, minor, patch, null);
            }

            public Version(int major, int minor, int patch, String stability) {
                this.major = major;
                this.minor = minor;
                this.patch = patch;
                this.stability = stability;
            }

            public int getMajor() {
                return this.major;
            }

            public int getMinor() {
                return this.minor;
            }

            public int getPatch() {
                return this.patch;
            }

            public String getStability() {
                return this.stability;
            }

            public String toString() {
                if (this.stability == null) {
                    return String.format(Locale.getDefault(), "%d.%d.%d", this.major, this.minor, this.patch);
                }
                return String.format(Locale.getDefault(), "%d.%d.%d-%s", this.major, this.minor, this.patch, this.stability);
            }
        }
    }
}

