/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda;

import com.contentful.java.cda.CDAArray;
import com.contentful.java.cda.CDACallback;
import com.contentful.java.cda.CDAContentType;
import com.contentful.java.cda.CDAResource;
import com.contentful.java.cda.CDAService;
import com.contentful.java.cda.CDASpace;
import com.contentful.java.cda.Cache;
import com.contentful.java.cda.Callbacks;
import com.contentful.java.cda.FetchQuery;
import com.contentful.java.cda.Logger;
import com.contentful.java.cda.ObserveQuery;
import com.contentful.java.cda.Platform;
import com.contentful.java.cda.ResourceFactory;
import com.contentful.java.cda.SyncQuery;
import com.contentful.java.cda.SynchronizedSpace;
import com.contentful.java.cda.TLSSocketFactory;
import com.contentful.java.cda.Util;
import com.contentful.java.cda.interceptor.AuthorizationHeaderInterceptor;
import com.contentful.java.cda.interceptor.ContentfulUserAgentHeaderInterceptor;
import com.contentful.java.cda.interceptor.ErrorInterceptor;
import com.contentful.java.cda.interceptor.LogInterceptor;
import com.contentful.java.cda.interceptor.UserAgentHeaderInterceptor;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import rx.Observable;
import rx.functions.Func1;

public class CDAClient {
    final String spaceId;
    final String token;
    final CDAService service;
    final Cache cache;
    final Executor callbackExecutor;
    final boolean preview;

    private CDAClient(Builder builder) {
        this(new Cache(), Platform.get().callbackExecutor(), CDAClient.createService(builder), builder);
        this.validate(builder);
    }

    CDAClient(Cache cache, Executor executor, CDAService service, Builder builder) {
        this.cache = cache;
        this.callbackExecutor = executor;
        this.service = service;
        this.spaceId = builder.space;
        this.token = builder.token;
        this.preview = builder.preview;
    }

    private void validate(Builder builder) {
        Util.checkNotNull(builder.space, "Space ID must be provided.", new Object[0]);
        if (builder.callFactory == null) {
            Util.checkNotNull(builder.token, "A token must be provided, if no call factory is specified.", new Object[0]);
        }
    }

    private static CDAService createService(Builder clientBuilder) {
        String endpoint = clientBuilder.endpoint;
        if (endpoint == null) {
            endpoint = "https://cdn.contentful.com/";
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ResourceFactory.GSON)).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).callFactory(clientBuilder.createOrGetCallFactory(clientBuilder)).baseUrl(endpoint);
        return (CDAService)retrofitBuilder.build().create(CDAService.class);
    }

    public <T extends CDAResource> FetchQuery<T> fetch(Class<T> type) {
        return new FetchQuery<T>(type, this);
    }

    public <T extends CDAResource> ObserveQuery<T> observe(Class<T> type) {
        return new ObserveQuery<T>(type, this);
    }

    public SyncQuery sync() {
        return this.sync(null, null);
    }

    public SyncQuery sync(String syncToken) {
        return this.sync(syncToken, null);
    }

    public SyncQuery sync(SynchronizedSpace synchronizedSpace) {
        return this.sync(null, synchronizedSpace);
    }

    private SyncQuery sync(String syncToken, SynchronizedSpace synchronizedSpace) {
        if (this.preview) {
            syncToken = null;
            synchronizedSpace = null;
        }
        SyncQuery.Builder builder = SyncQuery.builder().setClient(this);
        if (synchronizedSpace != null) {
            builder.setSpace(synchronizedSpace);
        }
        if (syncToken != null) {
            builder.setSyncToken(syncToken);
        }
        return builder.build();
    }

    public CDASpace fetchSpace() {
        return (CDASpace)this.observeSpace().toBlocking().first();
    }

    public <C extends CDACallback<CDASpace>> C fetchSpace(C callback) {
        return (C)Callbacks.subscribeAsync(this.observeSpace(), callback, this);
    }

    public Observable<CDASpace> observeSpace() {
        return this.cacheSpace(true);
    }

    Observable<Cache> cacheAll(final boolean invalidate) {
        return this.cacheSpace(invalidate).flatMap((Func1)new Func1<CDASpace, Observable<Map<String, CDAContentType>>>(){

            public Observable<Map<String, CDAContentType>> call(CDASpace cdaSpace) {
                return CDAClient.this.cacheTypes(invalidate);
            }
        }).map((Func1)new Func1<Map<String, CDAContentType>, Cache>(){

            public Cache call(Map<String, CDAContentType> stringCDAContentTypeMap) {
                return CDAClient.this.cache;
            }
        });
    }

    Observable<CDASpace> cacheSpace(boolean invalidate) {
        CDASpace space;
        CDASpace cDASpace = space = invalidate ? null : this.cache.space();
        if (space == null) {
            return this.service.space(this.spaceId).map((Func1)new Func1<Response<CDASpace>, CDASpace>(){

                public CDASpace call(Response<CDASpace> response) {
                    CDASpace space = ResourceFactory.space(response);
                    CDAClient.this.cache.setSpace(space);
                    return space;
                }
            });
        }
        return Observable.just((Object)space);
    }

    Observable<Map<String, CDAContentType>> cacheTypes(boolean invalidate) {
        Map<String, CDAContentType> types;
        Map<String, CDAContentType> map = types = invalidate ? null : this.cache.types();
        if (types == null) {
            return this.service.array(this.spaceId, "content_types", new HashMap<String, String>()).map((Func1)new Func1<Response<CDAArray>, Map<String, CDAContentType>>(){

                public Map<String, CDAContentType> call(Response<CDAArray> arrayResponse) {
                    CDAArray array = ResourceFactory.array(arrayResponse, CDAClient.this);
                    ConcurrentHashMap<String, CDAContentType> tmp = new ConcurrentHashMap<String, CDAContentType>();
                    for (CDAResource resource : array.items()) {
                        tmp.put(resource.id(), (CDAContentType)resource);
                    }
                    CDAClient.this.cache.setTypes(tmp);
                    return tmp;
                }
            });
        }
        return Observable.just(types);
    }

    Observable<CDAContentType> cacheTypeWithId(String id) {
        CDAContentType contentType = this.cache.types().get(id);
        if (contentType == null) {
            return this.observe(CDAContentType.class).one(id).map((Func1)new Func1<CDAContentType, CDAContentType>(){

                public CDAContentType call(CDAContentType resource) {
                    if (resource != null) {
                        CDAClient.this.cache.types().put(resource.id(), resource);
                    }
                    return resource;
                }
            });
        }
        return Observable.just((Object)contentType);
    }

    public CDAClient clearCache() {
        this.cache.clear();
        return this;
    }

    static String createUserAgent() {
        Properties properties = System.getProperties();
        return String.format("contentful.java/%s(%s %s) %s/%s", Util.getProperty("version.name"), properties.getProperty("java.runtime.name"), properties.getProperty("java.runtime.version"), properties.getProperty("os.name"), properties.getProperty("os.version"));
    }

    static ContentfulUserAgentHeaderInterceptor.Section[] createCustomHeaderSections(ContentfulUserAgentHeaderInterceptor.Section application, ContentfulUserAgentHeaderInterceptor.Section integration) {
        Properties properties = System.getProperties();
        return new ContentfulUserAgentHeaderInterceptor.Section[]{ContentfulUserAgentHeaderInterceptor.Section.sdk("contentful.java", ContentfulUserAgentHeaderInterceptor.Section.Version.parse(Util.getProperty("version.name"))), ContentfulUserAgentHeaderInterceptor.Section.platform("java", ContentfulUserAgentHeaderInterceptor.Section.Version.parse(properties.getProperty("java.runtime.version"))), ContentfulUserAgentHeaderInterceptor.Section.os(ContentfulUserAgentHeaderInterceptor.Section.OperatingSystem.parse(properties.getProperty("os.name")), ContentfulUserAgentHeaderInterceptor.Section.Version.parse(properties.getProperty("os.version"))), application, integration};
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String space;
        String token;
        String endpoint;
        Logger logger;
        Logger.Level logLevel = Logger.Level.NONE;
        Call.Factory callFactory;
        boolean preview;
        boolean useTLS12;
        ContentfulUserAgentHeaderInterceptor.Section application;
        ContentfulUserAgentHeaderInterceptor.Section integration;

        private Builder() {
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setLogLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder setLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder preview() {
            this.preview = true;
            return this.setEndpoint("https://preview.contentful.com/");
        }

        public Builder setCallFactory(Call.Factory callFactory) {
            this.callFactory = callFactory;
            return this;
        }

        private Call.Factory createOrGetCallFactory(Builder clientBuilder) {
            Object callFactory = clientBuilder.callFactory == null ? this.defaultCallFactoryBuilder().build() : clientBuilder.callFactory;
            return callFactory;
        }

        private OkHttpClient.Builder setLogger(OkHttpClient.Builder okBuilder) {
            if (this.logger != null) {
                switch (this.logLevel) {
                    case NONE: {
                        break;
                    }
                    case BASIC: {
                        return okBuilder.addInterceptor((Interceptor)new LogInterceptor(this.logger));
                    }
                    case FULL: {
                        return okBuilder.addNetworkInterceptor((Interceptor)new LogInterceptor(this.logger));
                    }
                }
            } else if (this.logLevel != Logger.Level.NONE) {
                throw new IllegalArgumentException("Cannot log to a null logger. Please set either logLevel to None, or do set a Logger");
            }
            return okBuilder;
        }

        private OkHttpClient.Builder useTLS12IfWanted(OkHttpClient.Builder okBuilder) {
            if (this.useTLS12) {
                try {
                    okBuilder.sslSocketFactory((SSLSocketFactory)new TLSSocketFactory());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot create TLSSocketFactory for TLS 1.2", e);
                }
            }
            return okBuilder;
        }

        public OkHttpClient.Builder defaultCallFactoryBuilder() {
            ContentfulUserAgentHeaderInterceptor.Section[] sections = CDAClient.createCustomHeaderSections(this.application, this.integration);
            OkHttpClient.Builder okBuilder = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthorizationHeaderInterceptor(this.token)).addInterceptor((Interceptor)new UserAgentHeaderInterceptor(CDAClient.createUserAgent())).addInterceptor((Interceptor)new ContentfulUserAgentHeaderInterceptor(sections)).addInterceptor((Interceptor)new ErrorInterceptor());
            this.setLogger(okBuilder);
            this.useTLS12IfWanted(okBuilder);
            return okBuilder;
        }

        public Builder useTLS12() {
            this.useTLS12 = true;
            return this;
        }

        public Builder setApplication(String name, String version) {
            this.application = ContentfulUserAgentHeaderInterceptor.Section.app(name, ContentfulUserAgentHeaderInterceptor.Section.Version.parse(version));
            return this;
        }

        public Builder setIntegration(String name, String version) {
            this.integration = ContentfulUserAgentHeaderInterceptor.Section.integration(name, ContentfulUserAgentHeaderInterceptor.Section.Version.parse(version));
            return this;
        }

        public CDAClient build() {
            return new CDAClient(this);
        }
    }
}

