/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cda.interceptor;

import com.contentful.java.cda.interceptor.HeaderInterceptor;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentfulUserAgentHeaderInterceptor
extends HeaderInterceptor {
    public static final String HEADER_NAME = "X-Contentful-User-Agent";

    public ContentfulUserAgentHeaderInterceptor(Section ... sections) {
        super(HEADER_NAME, ContentfulUserAgentHeaderInterceptor.sectionsToString(ContentfulUserAgentHeaderInterceptor.checkSections(sections)));
    }

    private static Section[] checkSections(Section[] sections) {
        if (sections == null || sections.length <= 0) {
            throw new IllegalArgumentException("sections cannot be empty.");
        }
        return sections;
    }

    private static String sectionsToString(Section[] sections) {
        LinkedHashMap<String, Section> mappedSections = new LinkedHashMap<String, Section>();
        for (Section section : sections) {
            if (section == null) continue;
            String identifier = section.getIdentifier();
            mappedSections.put(identifier, section);
        }
        StringBuilder builder = new StringBuilder();
        for (Section section : mappedSections.values()) {
            builder.append(section.toString());
        }
        return builder.toString();
    }

    public static class Section {
        private static final String APP = "app";
        private static final String INTEGRATION = "integration";
        private static final String SDK = "sdk";
        private static final String PLATFORM = "platform";
        private static final String OS = "os";
        private final String identifier;
        private final String name;
        private final Version version;

        public static Section integration(String name, Version version) {
            return new Section(INTEGRATION, name, version);
        }

        public static Section sdk(String name, Version version) {
            return new Section(SDK, name, version);
        }

        public static Section platform(String name, Version version) {
            return new Section(PLATFORM, name, version);
        }

        public static Section os(OperatingSystem os, Version version) {
            return new Section(OS, os.name(), version);
        }

        public static Section app(String name, Version version) {
            if ((name = Section.check(name)) == null) {
                return null;
            }
            return new Section(APP, name, version);
        }

        private static String check(String name) {
            if (name == null || name.length() <= 0) {
                return null;
            }
            return name.replace(" ", "-").toLowerCase();
        }

        private Section(String identifier, String name, Version version) {
            this.identifier = identifier;
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            if (this.getVersion() == null) {
                return String.format(Locale.getDefault(), "%s %s; ", this.getIdentifier(), this.getName());
            }
            return String.format(Locale.getDefault(), "%s %s/%s; ", this.getIdentifier(), this.getName(), this.getVersion().toString());
        }

        public static class Version {
            private static final String VERSION_REGEX = "^([0-9]+).([0-9]+).([0-9]+)(.*)?$";
            private static final Pattern VERSION_PATTERN = Pattern.compile("^([0-9]+).([0-9]+).([0-9]+)(.*)?$");
            private static final String STABILITY_REGEX = "^([a-zA-Z]+[0-9]*).*";
            private static final Pattern STABILITY_PATTERN = Pattern.compile("^([a-zA-Z]+[0-9]*).*");
            private final int major;
            private final int minor;
            private final int patch;
            private final String stability;

            public static Version parse(String version) {
                Matcher matcher;
                if (version == null || version.length() <= 0) {
                    return null;
                }
                if (!version.contains(".")) {
                    return null;
                }
                if (version.indexOf(".") == version.lastIndexOf(".")) {
                    version = version + ".0";
                }
                if ((matcher = VERSION_PATTERN.matcher(version)).find() && matcher.groupCount() == 4) {
                    int major = Version.extractNumberFromGroup(matcher, 1);
                    int minor = Version.extractNumberFromGroup(matcher, 2);
                    int patch = Version.extractNumberFromGroup(matcher, 3);
                    if (major == minor && minor == patch && patch == 0) {
                        return null;
                    }
                    String stability = Version.parseStability(matcher.group(4));
                    return new Version(major, minor, patch, stability);
                }
                return null;
            }

            private static int extractNumberFromGroup(Matcher matcher, int group) {
                try {
                    return Integer.parseInt(matcher.group(group));
                }
                catch (IllegalArgumentException e) {
                    return 0;
                }
            }

            private static String parseStability(String stability) {
                if (!stability.startsWith("-")) {
                    return null;
                }
                Matcher matcher = STABILITY_PATTERN.matcher(stability = stability.substring(1));
                if (matcher.find()) {
                    return matcher.group(0);
                }
                return null;
            }

            public Version(int major, int minor, int patch) {
                this(major, minor, patch, null);
            }

            public Version(int major, int minor, int patch, String stability) {
                this.major = major;
                this.minor = minor;
                this.patch = patch;
                this.stability = stability;
            }

            public int getMajor() {
                return this.major;
            }

            public int getMinor() {
                return this.minor;
            }

            public int getPatch() {
                return this.patch;
            }

            public String getStability() {
                return this.stability;
            }

            public String toString() {
                if (this.stability == null) {
                    return String.format(Locale.getDefault(), "%d.%d.%d", this.major, this.minor, this.patch);
                }
                return String.format(Locale.getDefault(), "%d.%d.%d-%s", this.major, this.minor, this.patch, this.stability);
            }
        }

        public static enum OperatingSystem {
            iOS,
            tvOS,
            watchOS,
            macOS,
            Windows,
            Linux,
            Android;


            public static OperatingSystem parse(String string) {
                if (string.startsWith("Windows")) {
                    return Windows;
                }
                if (string.startsWith("Mac OS")) {
                    return macOS;
                }
                if (string.startsWith("Android")) {
                    return Android;
                }
                return Linux;
            }
        }
    }
}

