/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client.rest.client.jdk;

import com.contentgrid.opa.client.rest.RestClientConfiguration;
import com.contentgrid.opa.client.rest.client.jdk.RequestLoggerConfiguration;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

class DefaultRestClientConfiguration
implements RestClientConfiguration {
    private final Consumer<URI> uriCallback;
    private final Consumer<RequestLoggerConfiguration> logConfig;

    DefaultRestClientConfiguration(Consumer<URI> uriConfig, Consumer<RequestLoggerConfiguration> logConfig) {
        this.uriCallback = uriConfig;
        this.logConfig = logConfig;
    }

    @Override
    public RestClientConfiguration baseUrl(String baseUrl) {
        this.uriCallback.accept(URI.create(baseUrl));
        return this;
    }

    @Override
    public RestClientConfiguration logging(Consumer<RestClientConfiguration.LogSpecification> callback) {
        DefaultLogSpecification logSpec = new DefaultLogSpecification();
        callback.accept(logSpec);
        this.logConfig.accept(logSpec.build());
        return this;
    }

    static class DefaultLogSpecification
    implements RestClientConfiguration.LogSpecification {
        private final Set<RequestLoggerConfiguration.LogDetail> details = new HashSet<RequestLoggerConfiguration.LogDetail>();

        DefaultLogSpecification() {
        }

        @Override
        public RestClientConfiguration.LogSpecification none() {
            this.details.clear();
            return this;
        }

        @Override
        public RestClientConfiguration.LogSpecification all() {
            return this.verbose().requestBody().requestHeaders();
        }

        @Override
        public RestClientConfiguration.LogSpecification verbose() {
            return this.requestLine().statusCode().responseHeaders().responseBody();
        }

        @Override
        public RestClientConfiguration.LogSpecification requestLine() {
            this.details.add(RequestLoggerConfiguration.LogDetail.REQUEST_LINE);
            return this;
        }

        @Override
        public RestClientConfiguration.LogSpecification requestHeaders() {
            this.details.add(RequestLoggerConfiguration.LogDetail.REQUEST_HEADERS);
            return this;
        }

        @Override
        public RestClientConfiguration.LogSpecification responseHeaders() {
            this.details.add(RequestLoggerConfiguration.LogDetail.RESPONSE_HEADERS);
            return this;
        }

        @Override
        public RestClientConfiguration.LogSpecification statusCode() {
            this.details.add(RequestLoggerConfiguration.LogDetail.RESPONSE_STATUS);
            return this;
        }

        @Override
        public RestClientConfiguration.LogSpecification requestBody() {
            this.details.add(RequestLoggerConfiguration.LogDetail.REQUEST_BODY);
            return this;
        }

        @Override
        public RestClientConfiguration.LogSpecification responseBody() {
            this.details.add(RequestLoggerConfiguration.LogDetail.RESPONSE_BODY);
            return this;
        }

        RequestLoggerConfiguration build() {
            return new RequestLoggerConfiguration(this.details);
        }
    }
}

