/*
 * Decompiled with CFR 0.152.
 */
package com.contentgrid.opa.client.rest.client.jdk.converter;

import com.contentgrid.opa.client.rest.client.jdk.converter.HttpBodyConverter;
import com.contentgrid.opa.client.rest.http.MediaType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class JacksonBodyConverter
implements HttpBodyConverter {
    private static final List<MediaType> MEDIA_TYPES = List.of(MediaType.APPLICATION_JSON, new MediaType("application", "*+json"));
    private final ObjectMapper objectMapper;

    public JacksonBodyConverter() {
        this(((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build());
    }

    public JacksonBodyConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> boolean canRead(HttpBodyConverter.DeserializationContext context, Class<T> type) {
        AtomicReference causeRef;
        Objects.requireNonNull(context, "Argument 'context' cannot be null");
        Objects.requireNonNull(type, "Argument 'type' cannot be null");
        if (!this.supportsMediaType(context.getContentType())) {
            return false;
        }
        JavaType javaType = this.objectMapper.constructType(type);
        return this.objectMapper.canDeserialize(javaType, causeRef = new AtomicReference());
    }

    @Override
    public Collection<MediaType> getSupportedMediaTypes() {
        return MEDIA_TYPES;
    }

    @Override
    public <T> T read(HttpBodyConverter.DeserializationContext context, Class<T> type) {
        Objects.requireNonNull(context, "Argument 'context' cannot be null");
        Objects.requireNonNull(type, "Argument 'type' cannot be null");
        try {
            return (T)this.objectMapper.readValue(context.getSource(), type);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public boolean canWrite(HttpBodyConverter.SerializationContext context) {
        Objects.requireNonNull(context, "Argument 'context' cannot be null");
        if (!this.supportsMediaType(context.getContentType())) {
            return false;
        }
        AtomicReference causeRef = new AtomicReference();
        return this.objectMapper.canSerialize(context.getSource().getClass());
    }

    @Override
    public byte[] write(HttpBodyConverter.SerializationContext context) {
        Objects.requireNonNull(context, "Argument 'context' cannot be null");
        try {
            return this.objectMapper.writeValueAsBytes(context.getSource());
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

