/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.AssetLibrary;
import com.contentstack.sdk.CSConnectionRequest;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.Query;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import com.contentstack.sdk.utility.CSAppConstants;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.json.JSONObject;

class CSBackgroundTask {
    public CSBackgroundTask(Query queryInstance, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, LinkedHashMap<String, Object> urlQueries, JSONObject jsonMain, String requestInfo, CSAppConstants.RequestMethod method, ResultCallBack callback) {
        if (CSAppConstants.isNetworkAvailable()) {
            if (headers != null && headers.size() > 0) {
                String URL2 = stackInstance.URLSCHEMA + stackInstance.URL + url;
                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(queryInstance);
                csConnectionRequest.setQueryInstance(queryInstance);
                csConnectionRequest.setURLQueries(urlQueries);
                csConnectionRequest.setParams(new Object[]{URL2, method, controller, jsonMain, headers, requestInfo, callback});
            } else {
                this.sendErrorForHeader(callback);
            }
        } else {
            this.sendErrorToUser(callback);
        }
    }

    public CSBackgroundTask(Entry entryInstance, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, HashMap<String, Object> urlQueries, JSONObject jsonMain, String requestInfo, boolean isOffline, CSAppConstants.RequestMethod method, ResultCallBack callBack) {
        if (CSAppConstants.isNetworkAvailable()) {
            if (headers != null && headers.size() > 0) {
                String URL2 = stackInstance.URLSCHEMA + stackInstance.URL + url;
                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(entryInstance);
                csConnectionRequest.setURLQueries(urlQueries);
                csConnectionRequest.setParams(new Object[]{URL2, method, controller, jsonMain, headers, requestInfo, callBack});
            } else {
                this.sendErrorForHeader(callBack);
            }
        } else {
            this.sendErrorToUser(callBack);
        }
    }

    public CSBackgroundTask(AssetLibrary assetLibrary, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, HashMap<String, Object> urlQueries, JSONObject jsonMain, String requestInfo, boolean isOffline, CSAppConstants.RequestMethod method, ResultCallBack callback) {
        if (CSAppConstants.isNetworkAvailable()) {
            if (headers != null && headers.size() > 0) {
                String URL2 = stackInstance.URLSCHEMA + stackInstance.URL + url;
                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(assetLibrary);
                csConnectionRequest.setURLQueries(urlQueries);
                csConnectionRequest.setParams(new Object[]{URL2, method, controller, jsonMain, headers, requestInfo, callback});
            } else {
                this.sendErrorForHeader(callback);
            }
        } else {
            this.sendErrorToUser(callback);
        }
    }

    public CSBackgroundTask(Asset asset, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, HashMap<String, Object> urlQueries, JSONObject jsonMain, String requestInfo, boolean isOffline, CSAppConstants.RequestMethod method, ResultCallBack callback) {
        if (CSAppConstants.isNetworkAvailable()) {
            if (headers != null && headers.size() > 0) {
                String URL2 = stackInstance.URLSCHEMA + stackInstance.URL + url;
                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(asset);
                csConnectionRequest.setURLQueries(urlQueries);
                csConnectionRequest.setParams(new Object[]{URL2, method, controller, jsonMain, headers, requestInfo, callback});
            } else {
                this.sendErrorForHeader(callback);
            }
        } else {
            this.sendErrorToUser(callback);
        }
    }

    public CSBackgroundTask(Stack stackInstance, String controller, String url, HashMap<String, Object> headers, HashMap<String, Object> urlParams, JSONObject jsonMain, String requestInfo, boolean b, CSAppConstants.RequestMethod method, ResultCallBack callback) {
        if (CSAppConstants.isNetworkAvailable()) {
            if (headers != null && headers.size() > 0) {
                String URL2 = stackInstance.URLSCHEMA + stackInstance.URL + url;
                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(stackInstance);
                csConnectionRequest.setStackInstance(stackInstance);
                csConnectionRequest.setURLQueries(urlParams);
                csConnectionRequest.setParams(new Object[]{URL2, method, controller, jsonMain, headers, requestInfo, callback});
            } else {
                this.sendErrorForHeader(callback);
            }
        } else {
            this.sendErrorToUser(callback);
        }
    }

    private void sendErrorToUser(ResultCallBack callbackObject) {
        Error error = new Error();
        error.setErrorCode(408);
        error.setErrorMessage("Network not available.");
        if (callbackObject != null) {
            callbackObject.onRequestFail(ResponseType.UNKNOWN, error);
        }
    }

    private void sendErrorForHeader(ResultCallBack callbackObject) {
        Error error = new Error();
        error.setErrorMessage("You must called Contentstack.stack() first");
        if (callbackObject != null) {
            callbackObject.onRequestFail(ResponseType.UNKNOWN, error);
        }
    }
}

