/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.IRequestModelHTTP;
import com.contentstack.sdk.IURLRequestHTTP;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.utility.CSAppConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CSHttpConnection
implements IURLRequestHTTP {
    private static final String TAG = "CSHttpConnection";
    private String urlPath;
    private String controller;
    private LinkedHashMap<String, Object> headers;
    private String info;
    private JSONObject requestJSON;
    private IRequestModelHTTP connectionRequest;
    private ResultCallBack callBackObject;
    private CSAppConstants.RequestMethod requestMethod;
    private JSONObject responseJSON;
    private HashMap<String, Object> formParams;
    private boolean treatDuplicateKeysAsArrayItems;

    public HashMap<String, Object> getFormParams() {
        return this.formParams;
    }

    public void setFormParams(HashMap<String, Object> formParams) {
        this.formParams = formParams;
    }

    public CSHttpConnection(String urlToCall, IRequestModelHTTP csConnectionRequest) {
        this.urlPath = urlToCall;
        this.connectionRequest = csConnectionRequest;
    }

    @Override
    public void setController(String controller) {
        this.controller = controller;
    }

    @Override
    public String getController() {
        return this.controller;
    }

    @Override
    public void setHeaders(LinkedHashMap headers) {
        this.headers = headers;
    }

    @Override
    public LinkedHashMap getHeaders() {
        return this.headers;
    }

    @Override
    public void setInfo(String info) {
        this.info = info;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    public void setFormParamsPOST(JSONObject requestJSON) {
        this.requestJSON = null;
        this.requestJSON = requestJSON;
    }

    @Override
    public void setCallBackObject(ResultCallBack callBackObject) {
        this.callBackObject = callBackObject;
    }

    @Override
    public ResultCallBack getCallBackObject() {
        return this.callBackObject;
    }

    @Override
    public void setTreatDuplicateKeysAsArrayItems(boolean treatDuplicateKeysAsArrayItems) {
        this.treatDuplicateKeysAsArrayItems = treatDuplicateKeysAsArrayItems;
    }

    @Override
    public boolean getTreatDuplicateKeysAsArrayItems() {
        return this.treatDuplicateKeysAsArrayItems;
    }

    @Override
    public void setRequestMethod(CSAppConstants.RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    @Override
    public CSAppConstants.RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public JSONObject getResponse() {
        return this.responseJSON;
    }

    public String setFormParamsGET(HashMap<String, Object> params) {
        if (params != null && params.size() > 0) {
            String urlParams = null;
            String string = urlParams = this.info.equalsIgnoreCase(CSAppConstants.callController.QUERY.name()) || this.info.equalsIgnoreCase(CSAppConstants.callController.ENTRY.name()) ? this.getParams(params) : null;
            if (urlParams == null) {
                for (Map.Entry<String, Object> e : params.entrySet()) {
                    if (urlParams == null) {
                        urlParams = "?" + e.getKey() + "=" + e.getValue();
                        continue;
                    }
                    urlParams = urlParams + "&" + e.getKey() + "=" + e.getValue();
                }
            }
            return urlParams;
        }
        return null;
    }

    private String getParams(HashMap<String, Object> params) {
        String urlParams = "?";
        for (Map.Entry<String, Object> e : params.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            try {
                int i;
                JSONArray array;
                String innerKey;
                JSONObject onlyJSON;
                JSONArray array2;
                if (key.equalsIgnoreCase("include[]")) {
                    key = URLEncoder.encode(key, "UTF-8");
                    array2 = (JSONArray)value;
                    for (int i2 = 0; i2 < array2.length(); ++i2) {
                        urlParams = urlParams + (urlParams.equals("?") ? key + "=" + array2.opt(i2) : "&" + key + "=" + array2.opt(i2));
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("only[BASE][]")) {
                    key = URLEncoder.encode(key, "UTF-8");
                    array2 = (JSONArray)value;
                    for (int i3 = 0; i3 < array2.length(); ++i3) {
                        urlParams = urlParams + (urlParams.equals("?") ? key + "=" + array2.opt(i3) : "&" + key + "=" + array2.opt(i3));
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("except[BASE][]")) {
                    key = URLEncoder.encode(key, "UTF-8");
                    array2 = (JSONArray)value;
                    for (int i4 = 0; i4 < array2.length(); ++i4) {
                        urlParams = urlParams + (urlParams.equals("?") ? key + "=" + array2.opt(i4) : "&" + key + "=" + array2.opt(i4));
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("only")) {
                    onlyJSON = (JSONObject)value;
                    Iterator iter = onlyJSON.keys();
                    while (iter.hasNext()) {
                        innerKey = (String)iter.next();
                        array = onlyJSON.optJSONArray(innerKey);
                        innerKey = URLEncoder.encode("only[" + innerKey + "][]", "UTF-8");
                        for (i = 0; i < array.length(); ++i) {
                            urlParams = urlParams + (urlParams.equals("?") ? innerKey + "=" + array.opt(i) : "&" + innerKey + "=" + array.opt(i));
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("except")) {
                    onlyJSON = (JSONObject)value;
                    Iterator iter = onlyJSON.keys();
                    while (iter.hasNext()) {
                        innerKey = (String)iter.next();
                        array = onlyJSON.optJSONArray(innerKey);
                        innerKey = URLEncoder.encode("except[" + innerKey + "][]", "UTF-8");
                        for (i = 0; i < array.length(); ++i) {
                            urlParams = urlParams + (urlParams.equals("?") ? innerKey + "=" + array.opt(i) : "&" + innerKey + "=" + array.opt(i));
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("query")) {
                    JSONObject queryJSON = (JSONObject)value;
                    urlParams = urlParams + (urlParams.equals("?") ? key + "=" + URLEncoder.encode(queryJSON.toString(), "UTF-8") : "&" + key + "=" + URLEncoder.encode(queryJSON.toString(), "UTF-8"));
                    continue;
                }
                urlParams = urlParams + (urlParams.equals("?") ? key + "=" + value : "&" + key + "=" + value);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return urlParams;
    }

    @Override
    public void send() {
        Object params;
        String url = null;
        String httpsORhttp = CSAppConstants.URLSCHEMA_HTTPS;
        int requestId = this.getRequestId(this.requestMethod);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        int count = this.headers.size();
        url = this.requestMethod == CSAppConstants.RequestMethod.GET ? ((params = this.setFormParamsGET(this.formParams)) != null ? this.urlPath + (String)params : this.urlPath) : this.urlPath;
        if (url.contains(CSAppConstants.URLSCHEMA_HTTPS)) {
            httpsORhttp = CSAppConstants.URLSCHEMA_HTTPS;
        }
        for (Map.Entry entry : this.headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            headers.put(key, value);
        }
        headers.put("Content-Type", "application/json");
        headers.put("User-Agent", this.defaultUserAgent() + "/" + "1.3.1");
        try {
            this.requestJSON.put("_method", (Object)this.getRequestMethod().toString());
            this.callNetworkRequest(url, this.getRequestMethod().toString(), this.requestJSON, headers);
        }
        catch (IOException | JSONException e) {
            System.out.println("Localized Message : " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private String getRequest(String urlString, String requestMethod) {
        try {
            String line;
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(requestMethod);
            conn.setRequestProperty("Accept", "application/json");
            conn.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            StringBuilder sb = new StringBuilder(2048);
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            conn.disconnect();
            return sb.toString();
        }
        catch (IOException ex) {
            Logger.getLogger(CSHttpConnection.class.getName()).log(Level.SEVERE, null, ex);
            return ex.toString();
        }
    }

    private void callNetworkRequest(String url, String requestMethod, JSONObject jsonParam, Map<String, String> reqHeaders) throws IOException {
        URL objURL = new URL(url);
        HttpURLConnection con = (HttpURLConnection)objURL.openConnection();
        con.setRequestMethod(requestMethod);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : reqHeaders.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            con.setRequestProperty(key, value);
            stringBuilder.append(key + ":" + value + ",");
        }
        con.setDoOutput(true);
        con.setDoInput(true);
        OutputStream outputStream = con.getOutputStream();
        String paramString = jsonParam.toString().trim();
        if (!paramString.isEmpty()) {
            byte[] postParams = paramString.getBytes("UTF-8");
            outputStream.write(postParams);
        }
        outputStream.flush();
        outputStream.close();
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader inputStreamReader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = inputStreamReader.readLine()) != null) {
                response.append(inputLine);
            }
            inputStreamReader.close();
            try {
                this.responseJSON = new JSONObject(response.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (this.responseJSON != null) {
                this.connectionRequest.onRequestFinished(this);
            }
        } else {
            this.generateBuiltError(con);
        }
    }

    private int getRequestId(CSAppConstants.RequestMethod requestMethod) {
        switch (requestMethod) {
            case GET: {
                return 0;
            }
            case POST: {
                return 1;
            }
            case PUT: {
                return 2;
            }
            case DELETE: {
                return 3;
            }
        }
        return 1;
    }

    private String defaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? agent : "Java" + System.getProperty("java.version");
    }

    private void generateBuiltError(HttpURLConnection connection) {
        try {
            int statusCode = 0;
            this.responseJSON = new JSONObject();
            this.responseJSON.put("error_message", (Object)"Oops! Something went wrong. Please try again.");
            if (connection != null) {
                String responseMessage = connection.getResponseMessage();
                statusCode = connection.getResponseCode();
                try {
                    if (connection.getResponseMessage() == null && connection.getResponseMessage().equalsIgnoreCase("")) {
                        statusCode = connection.getResponseCode();
                        this.responseJSON.put("error_message", (Object)"Oops! Something went wrong. Please try again.");
                    } else {
                        if (responseMessage.toString().equalsIgnoreCase("NoConnectionError")) {
                            this.responseJSON.put("error_message", (Object)"Connection error");
                        } else if (responseMessage.toString().equalsIgnoreCase("AuthFailureError")) {
                            this.responseJSON.put("error_message", (Object)"Authentication Not present.");
                        } else if (responseMessage.toString().equalsIgnoreCase("NetworkError")) {
                            this.responseJSON.put("error_message", (Object)"Network not available.");
                        } else if (responseMessage.toString().equalsIgnoreCase("ParseError")) {
                            this.responseJSON.put("error_message", (Object)"Parsing Error.");
                        } else if (responseMessage.toString().equalsIgnoreCase("ServerError")) {
                            this.responseJSON.put("error_message", (Object)"Server interaction went wrong, Please try again.");
                        } else if (responseMessage.toString().equalsIgnoreCase("TimeoutError")) {
                            this.responseJSON.put("error_message", (Object)"Server interaction went wrong, Please try again.");
                        } else if (responseMessage != null) {
                            this.responseJSON.put("error_message", (Object)responseMessage);
                        }
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("errors", (Object)responseMessage.toString());
                        this.responseJSON.put("errors", (Object)jsonObject);
                    }
                    this.connectionRequest.onRequestFailed(this.responseJSON, statusCode, this.callBackObject);
                }
                catch (Exception e) {
                    this.connectionRequest.onRequestFailed(this.responseJSON, 0, this.callBackObject);
                }
            } else {
                this.connectionRequest.onRequestFailed(this.responseJSON, 0, this.callBackObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

