/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.ContentTypesCallback;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.Query;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import com.contentstack.sdk.utility.CSAppConstants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONObject;

public class ContentType {
    protected String contentTypeName = null;
    protected Stack stackInstance = null;
    private LinkedHashMap<String, Object> localHeader = null;
    private LinkedHashMap<String, Object> stackHeader = null;

    private ContentType() {
    }

    protected ContentType(String contentTypeName) {
        this.contentTypeName = contentTypeName;
        this.localHeader = new LinkedHashMap();
    }

    protected void setStackInstance(Stack stack) {
        this.stackInstance = stack;
        this.stackHeader = stack.localHeader;
    }

    public void setHeader(String key, String value) {
        if (!key.isEmpty() && !value.isEmpty()) {
            this.localHeader.put(key, value);
        }
    }

    public void removeHeader(String key) {
        if (!key.isEmpty()) {
            this.localHeader.remove(key);
        }
    }

    public Entry entry(String entryUid) {
        Entry entry = new Entry(this.contentTypeName);
        entry.formHeader = this.getHeader(this.localHeader);
        entry.setContentTypeInstance(this);
        entry.setUid(entryUid);
        return entry;
    }

    protected Entry entry() {
        Entry entry = new Entry(this.contentTypeName);
        entry.formHeader = this.getHeader(this.localHeader);
        entry.setContentTypeInstance(this);
        return entry;
    }

    public Query query() {
        Query query = new Query(this.contentTypeName);
        query.formHeader = this.getHeader(this.localHeader);
        query.setContentTypeInstance(this);
        return query;
    }

    public void fetch(ContentTypesCallback callback) {
        try {
            String URL2 = "/" + this.stackInstance.VERSION + "/content_types/" + this.contentTypeName;
            LinkedHashMap<String, Object> headers = this.getHeader(this.localHeader);
            JSONObject param = new JSONObject();
            if (headers.containsKey("environment")) {
                param.put("environment", ((HashMap)headers).get("environment"));
            }
            if (this.contentTypeName != null) {
                this.fetchContentTypes(URL2, param, headers, callback);
            } else {
                Error error = new Error();
                error.setErrorMessage("Please provide valid JSON.");
                callback.onRequestFail(ResponseType.UNKNOWN, error);
            }
        }
        catch (Exception e) {
            Error error = new Error();
            error.setErrorMessage("Please provide valid JSON.");
            callback.onRequestFail(ResponseType.UNKNOWN, error);
        }
    }

    private void fetchContentTypes(String urlString, JSONObject content_type_param, HashMap<String, Object> headers, ContentTypesCallback callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(content_type_param);
            new CSBackgroundTask(this, this.stackInstance, "getContentTypes", urlString, headers, urlParams, new JSONObject(), CSAppConstants.callController.CONTENTTYPES.toString(), false, CSAppConstants.RequestMethod.GET, (ResultCallBack)callback);
        }
    }

    private LinkedHashMap<String, Object> getHeader(LinkedHashMap<String, Object> localHeader) {
        LinkedHashMap<String, Object> mainHeader = this.stackHeader;
        LinkedHashMap<String, Object> classHeaders = new LinkedHashMap<String, Object>();
        if (localHeader != null && localHeader.size() > 0) {
            if (mainHeader != null && mainHeader.size() > 0) {
                String key;
                for (Map.Entry<String, Object> entry : localHeader.entrySet()) {
                    key = entry.getKey();
                    classHeaders.put(key, entry.getValue());
                }
                for (Map.Entry<String, Object> entry : mainHeader.entrySet()) {
                    key = entry.getKey();
                    if (classHeaders.containsKey(key)) continue;
                    classHeaders.put(key, entry.getValue());
                }
                return classHeaders;
            }
            return localHeader;
        }
        return this.stackHeader;
    }

    private HashMap<String, Object> getUrlParams(JSONObject urlQueriesJSON) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (urlQueriesJSON != null && urlQueriesJSON.length() > 0) {
            Iterator iter = urlQueriesJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    Object value = urlQueriesJSON.opt(key);
                    hashMap.put(key, value);
                }
                catch (Exception e) {
                    System.out.println("------setQueryJson" + e.toString());
                }
            }
            return hashMap;
        }
        return null;
    }
}

