/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.EntryModel;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.INotifyClass;
import com.contentstack.sdk.Language;
import com.contentstack.sdk.LanguageCode;
import com.contentstack.sdk.QueryResult;
import com.contentstack.sdk.QueryResultsCallBack;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.SingleQueryResultCallback;
import com.contentstack.sdk.Stack;
import com.contentstack.sdk.utility.CSAppConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Query
implements INotifyClass {
    private static final String TAG = Query.class.getSimpleName();
    private JSONObject mainJSON = null;
    private String formName = null;
    protected ContentType contentTypeInstance = null;
    private JSONObject urlQueries = null;
    private LinkedHashMap<String, Object> localHeader = null;
    protected LinkedHashMap<String, Object> formHeader = null;
    private QueryResultsCallBack queryResultCallback;
    private SingleQueryResultCallback singleQueryResultCallback;
    private JSONObject queryValueJSON = null;
    private JSONObject queryValue = null;
    private JSONArray objectUidForInclude = null;
    private JSONArray objectUidForExcept = null;
    private JSONArray objectUidForOnly = null;
    private boolean isJsonProper = true;
    private String errorString;
    private HashMap<String, Object> errorHashMap;
    private JSONObject onlyJsonObject;
    private JSONObject exceptJsonObject;

    protected Query(String formName) {
        this.formName = formName;
        this.localHeader = new LinkedHashMap();
        this.urlQueries = new JSONObject();
        this.queryValue = new JSONObject();
        this.queryValueJSON = new JSONObject();
        this.mainJSON = new JSONObject();
    }

    protected void setContentTypeInstance(ContentType contentTypeInstance) {
        this.contentTypeInstance = contentTypeInstance;
    }

    public void setHeader(String key, String value) {
        if (!key.isEmpty() && !value.isEmpty()) {
            this.localHeader.put(key, value);
        }
    }

    public void removeHeader(String key) {
        if (!key.isEmpty()) {
            this.localHeader.remove(key);
        }
    }

    public String getContentType() {
        return this.contentTypeInstance.contentTypeName;
    }

    public Query where(String key, Object value) {
        try {
            if (key != null && value != null) {
                this.queryValueJSON.put(key, value);
            } else {
                this.throwException("where", "Please provide valid params.", null);
            }
        }
        catch (Exception e) {
            this.throwException("where", "Please provide valid params.", e);
        }
        return this;
    }

    public Query addQuery(String key, String value) {
        try {
            if (key != null && value != null) {
                this.urlQueries.put(key, (Object)value);
            } else {
                this.throwException("and", "Please provide valid params.", null);
            }
        }
        catch (Exception e) {
            this.throwException("and", "Please provide valid params.", e);
        }
        return this;
    }

    public Query removeQuery(String key) {
        try {
            if (this.urlQueries.has(key)) {
                this.urlQueries.remove(key);
            }
        }
        catch (Exception e) {
            this.throwException("and", "Please provide valid params.", e);
        }
        return this;
    }

    public Query and(ArrayList<Query> queryObjects) {
        if (queryObjects != null && queryObjects.size() > 0) {
            try {
                JSONArray orValueJson = new JSONArray();
                int count = queryObjects.size();
                for (int i = 0; i < count; ++i) {
                    orValueJson.put((Object)queryObjects.get((int)i).queryValueJSON);
                }
                this.queryValueJSON.put("$and", (Object)orValueJson);
            }
            catch (Exception e) {
                this.throwException("and", "Please provide valid params.", e);
            }
        } else {
            this.throwException("and", "Please provide valid params.", null);
        }
        return this;
    }

    public Query or(ArrayList<Query> queryObjects) {
        if (queryObjects != null && queryObjects.size() > 0) {
            try {
                JSONArray orValueJson = new JSONArray();
                int count = queryObjects.size();
                for (int i = 0; i < count; ++i) {
                    orValueJson.put((Object)queryObjects.get((int)i).queryValueJSON);
                }
                this.queryValueJSON.put("$or", (Object)orValueJson);
            }
            catch (Exception e) {
                this.throwException("or", "Please provide valid params.", e);
            }
        } else {
            this.throwException("or", "Please provide valid params.", null);
        }
        return this;
    }

    public Query lessThan(String key, Object value) {
        if (key != null && value != null) {
            try {
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$lt", value);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$lt", value);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("lessThan", "Please provide valid params.", e);
            }
        } else {
            this.throwException("lessThan", "Please provide valid params.", null);
        }
        return this;
    }

    public Query lessThanOrEqualTo(String key, Object value) {
        if (key != null && value != null) {
            try {
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$lte", value);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$lte", value);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("lessThanOrEqualTo", "Please provide valid params.", e);
            }
        } else {
            this.throwException("lessThanOrEqualTo", "Please provide valid params.", null);
        }
        return this;
    }

    public Query greaterThan(String key, Object value) {
        if (key != null && value != null) {
            try {
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$gt", value);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$gt", value);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("greaterThan", "Please provide valid params.", e);
            }
        } else {
            this.throwException("greaterThan", "Please provide valid params.", null);
        }
        return this;
    }

    public Query greaterThanOrEqualTo(String key, Object value) {
        if (key != null && value != null) {
            try {
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$gte", value);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$gte", value);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("greaterThanOrEqualTo", "Please provide valid params.", e);
            }
        } else {
            this.throwException("greaterThanOrEqualTo", "Please provide valid params.", null);
        }
        return this;
    }

    public Query notEqualTo(String key, Object value) {
        if (key != null && value != null) {
            try {
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$ne", value);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$ne", value);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("notEqualTo", null, e);
            }
        } else {
            this.throwException("notEqualTo", "Please provide valid params.", null);
        }
        return this;
    }

    public Query containedIn(String key, Object[] values) {
        if (key != null && values != null) {
            try {
                JSONArray valuesArray = new JSONArray();
                int length = values.length;
                for (int i = 0; i < length; ++i) {
                    valuesArray.put(values[i]);
                }
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$in", (Object)valuesArray);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$in", (Object)valuesArray);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("containedIn", "Please provide valid params.", e);
            }
        } else {
            this.throwException("containedIn", "Please provide valid params.", null);
        }
        return this;
    }

    public Query notContainedIn(String key, Object[] values) {
        if (key != null && values != null) {
            try {
                JSONArray valuesArray = new JSONArray();
                int length = values.length;
                for (int i = 0; i < length; ++i) {
                    valuesArray.put(values[i]);
                }
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$nin", (Object)valuesArray);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$nin", (Object)valuesArray);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("containedIn", "Please provide valid params.", e);
            }
        } else {
            this.throwException("containedIn", "Please provide valid params.", null);
        }
        return this;
    }

    public Query exists(String key) {
        if (key != null) {
            try {
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$exists", true);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$exists", true);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("exists", "Please provide valid params.", e);
            }
        } else {
            this.throwException("exists", "Please provide valid params.", null);
        }
        return this;
    }

    public Query notExists(String key) {
        if (key != null) {
            try {
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$exists", false);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$exists", false);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("notExists", "Please provide valid params.", e);
            }
        } else {
            this.throwException("notExists", "Please provide valid params.", null);
        }
        return this;
    }

    public Query includeReference(String key) {
        if (this.objectUidForInclude == null) {
            this.objectUidForInclude = new JSONArray();
        }
        this.objectUidForInclude.put((Object)key);
        return this;
    }

    public Query tags(String[] tags) {
        try {
            if (tags != null) {
                String tagsvalue = null;
                int count = tags.length;
                for (int i = 0; i < count; ++i) {
                    tagsvalue = tagsvalue + "," + tags[i];
                }
                this.urlQueries.put("tags", tagsvalue);
            } else {
                this.throwException("tags", "Please provide valid params.", null);
            }
        }
        catch (Exception e) {
            this.throwException("tags", "Please provide valid params.", e);
        }
        return this;
    }

    public Query ascending(String key) {
        if (key != null) {
            try {
                this.urlQueries.put("asc", (Object)key);
            }
            catch (Exception e) {
                this.throwException("ascending", "Please provide valid params.", e);
            }
        } else {
            this.throwException("ascending", "Please provide valid params.", null);
        }
        return this;
    }

    public Query descending(String key) {
        if (key != null) {
            try {
                this.urlQueries.put("desc", (Object)key);
            }
            catch (Exception e) {
                this.throwException("descending", "Please provide valid params.", e);
            }
        } else {
            this.throwException("descending", "Please provide valid params.", null);
        }
        return this;
    }

    public Query except(ArrayList<String> fieldUid) {
        try {
            if (fieldUid != null && fieldUid.size() > 0) {
                if (this.objectUidForExcept == null) {
                    this.objectUidForExcept = new JSONArray();
                }
                int count = fieldUid.size();
                for (int i = 0; i < count; ++i) {
                    this.objectUidForExcept.put((Object)fieldUid.get(i));
                }
            } else {
                this.throwException("except", "Please provide valid params.", null);
            }
        }
        catch (Exception e) {
            this.throwException("except", "Please provide valid params.", e);
        }
        return this;
    }

    public Query except(String[] fieldUids) {
        try {
            if (fieldUids != null && fieldUids.length > 0) {
                if (this.objectUidForExcept == null) {
                    this.objectUidForExcept = new JSONArray();
                }
                int count = fieldUids.length;
                for (int i = 0; i < count; ++i) {
                    this.objectUidForExcept.put((Object)fieldUids[i]);
                }
            } else {
                this.throwException("except", "Please provide valid params.", null);
            }
        }
        catch (Exception e) {
            this.throwException("except", "Please provide valid params.", e);
        }
        return this;
    }

    public Query only(String[] fieldUid) {
        try {
            if (fieldUid != null && fieldUid.length > 0) {
                if (this.objectUidForOnly == null) {
                    this.objectUidForOnly = new JSONArray();
                }
                int count = fieldUid.length;
                for (int i = 0; i < count; ++i) {
                    this.objectUidForOnly.put((Object)fieldUid[i]);
                }
            } else {
                this.throwException("only", "Please provide valid params.", null);
            }
        }
        catch (Exception e) {
            this.throwException("only", "Please provide valid params.", e);
        }
        return this;
    }

    public Query onlyWithReferenceUid(ArrayList<String> fieldUid, String referenceFieldUid) {
        try {
            if (fieldUid != null && referenceFieldUid != null) {
                if (this.onlyJsonObject == null) {
                    this.onlyJsonObject = new JSONObject();
                }
                JSONArray fieldValueArray = new JSONArray();
                int count = fieldUid.size();
                for (int i = 0; i < count; ++i) {
                    fieldValueArray.put((Object)fieldUid.get(i));
                }
                this.onlyJsonObject.put(referenceFieldUid, (Object)fieldValueArray);
                if (this.objectUidForInclude == null) {
                    this.objectUidForInclude = new JSONArray();
                }
                this.objectUidForInclude.put((Object)referenceFieldUid);
            } else {
                this.throwException("onlyWithReferenceUid", "Please provide valid params.", null);
            }
        }
        catch (Exception e) {
            this.throwException("onlyWithReferenceUid", "Please provide valid params.", e);
        }
        return this;
    }

    public Query exceptWithReferenceUid(ArrayList<String> fieldUid, String referenceFieldUid) {
        try {
            if (fieldUid != null && referenceFieldUid != null) {
                if (this.exceptJsonObject == null) {
                    this.exceptJsonObject = new JSONObject();
                }
                JSONArray fieldValueArray = new JSONArray();
                int count = fieldUid.size();
                for (int i = 0; i < count; ++i) {
                    fieldValueArray.put((Object)fieldUid.get(i));
                }
                this.exceptJsonObject.put(referenceFieldUid, (Object)fieldValueArray);
                if (this.objectUidForInclude == null) {
                    this.objectUidForInclude = new JSONArray();
                }
                this.objectUidForInclude.put((Object)referenceFieldUid);
            } else {
                this.throwException("exceptWithReferenceUid", "Please provide valid params.", null);
            }
        }
        catch (Exception e) {
            this.throwException("exceptWithReferenceUid", "Please provide valid params.", e);
        }
        return this;
    }

    public Query count() {
        try {
            this.urlQueries.put("count", (Object)"true");
        }
        catch (Exception e) {
            this.throwException("count", "Please provide valid params.", e);
        }
        return this;
    }

    public Query includeCount() {
        try {
            this.urlQueries.put("include_count", (Object)"true");
        }
        catch (Exception e) {
            this.throwException("includeCount", "Please provide valid params.", e);
        }
        return this;
    }

    public Query includeContentType() {
        try {
            if (this.urlQueries.has("include_schema")) {
                this.urlQueries.remove("include_schema");
            }
            this.urlQueries.put("include_content_type", true);
        }
        catch (Exception e) {
            this.throwException("include_content_type", "Please provide valid params.", e);
        }
        return this;
    }

    public Query includeOwner() {
        try {
            this.urlQueries.put("include_owner", true);
        }
        catch (Exception e) {
            this.throwException("includeUser", "Please provide valid params.", e);
        }
        return this;
    }

    private Query beforeUid(String uid) {
        if (uid != null) {
            try {
                this.urlQueries.put("before_uid", (Object)uid);
            }
            catch (Exception e) {
                this.throwException("beforeUid", "Please provide valid params.", e);
            }
        } else {
            this.throwException("beforeUid", "Please provide valid params.", null);
        }
        return this;
    }

    private Query afterUid(String uid) {
        if (uid != null) {
            try {
                this.urlQueries.put("after_uid", (Object)uid);
            }
            catch (Exception e) {
                this.throwException("afterUid", "Please provide valid params.", e);
            }
        } else {
            this.throwException("afterUid", "Please provide valid params.", null);
        }
        return this;
    }

    public Query skip(int number) {
        try {
            this.urlQueries.put("skip", number);
        }
        catch (Exception e) {
            this.throwException("skip", "Please provide valid params.", e);
        }
        return this;
    }

    public Query limit(int number) {
        try {
            this.urlQueries.put("limit", number);
        }
        catch (Exception e) {
            this.throwException("limit", "Please provide valid params.", e);
        }
        return this;
    }

    public Query regex(String key, String regex) {
        if (key != null && regex != null) {
            try {
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$regex", (Object)regex);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$regex", (Object)regex);
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("matches", "Please provide valid params.", e);
            }
        } else {
            this.throwException("matches", "Please provide valid params.", null);
        }
        return this;
    }

    public Query regex(String key, String regex, String modifiers) {
        if (key != null && regex != null) {
            try {
                if (this.queryValueJSON.isNull(key)) {
                    if (this.queryValue.length() > 0) {
                        this.queryValue = new JSONObject();
                    }
                    this.queryValue.put("$regex", (Object)regex);
                    if (modifiers != null) {
                        this.queryValue.put("$options", (Object)modifiers);
                    }
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                } else if (this.queryValueJSON.has(key)) {
                    this.queryValue.put("$regex", (Object)regex);
                    if (modifiers != null) {
                        this.queryValue.put("$options", (Object)modifiers);
                    }
                    this.queryValueJSON.put(key, (Object)this.queryValue);
                }
            }
            catch (Exception e) {
                this.throwException("matches", "Please provide valid params.", e);
            }
        } else {
            this.throwException("matches", "Please provide valid params.", null);
        }
        return this;
    }

    @Deprecated
    public Query language(Language language) {
        if (language != null) {
            try {
                Language languageName = Language.valueOf(language.name());
                int localeValue = languageName.ordinal();
                LanguageCode[] languageCodeValues = LanguageCode.values();
                String localeCode = languageCodeValues[localeValue].name();
                localeCode = localeCode.replace("_", "-");
                if (this.urlQueries != null) {
                    this.urlQueries.put("locale", (Object)localeCode);
                }
            }
            catch (Exception e) {
                this.throwException("language", "Please provide valid params.", e);
            }
        } else {
            this.throwException("language", "Please provide valid params.", null);
        }
        return this;
    }

    public Query locale(String locale) {
        if (locale != null && this.urlQueries != null) {
            try {
                this.urlQueries.put("locale", (Object)locale);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public Query search(String value) {
        if (value != null) {
            try {
                if (this.urlQueries.isNull(value)) {
                    this.urlQueries.put("typeahead", (Object)value);
                }
            }
            catch (Exception e) {
                this.throwException("value", "Please provide valid params.", e);
            }
        } else {
            this.throwException("value", "Please provide valid params.", null);
        }
        return this;
    }

    public Query find(QueryResultsCallBack callback) {
        Error error = null;
        try {
            if (this.isJsonProper) {
                if (!this.formName.isEmpty()) {
                    this.execQuery(null, callback, false);
                } else {
                    this.throwException("find", "Please set contentType name.", null);
                    error = new Error();
                    error.setErrorMessage(this.errorString);
                    error.setErrors(this.errorHashMap);
                }
            } else {
                error = new Error();
                error.setErrorMessage(this.errorString);
                error.setErrors(this.errorHashMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.throwException("find", "Please provide valid JSON.", null);
            error = new Error();
            error.setErrorMessage(this.errorString);
            error.setErrors(this.errorHashMap);
        }
        if (error != null && callback != null) {
            callback.onRequestFail(ResponseType.UNKNOWN, error);
        }
        return this;
    }

    public Query findOne(SingleQueryResultCallback callBack) {
        Error error = null;
        try {
            if (this.isJsonProper) {
                if (!this.formName.isEmpty()) {
                    int limit = -1;
                    if (this.urlQueries != null && this.urlQueries.has("limit")) {
                        limit = (Integer)this.urlQueries.get("limit");
                    }
                    this.urlQueries.put("limit", 1);
                    this.execQuery(callBack, null, false);
                    if (limit != -1) {
                        this.urlQueries.put("limit", limit);
                    }
                } else {
                    this.throwException("find", "Please set contentType name.", null);
                    error = new Error();
                    error.setErrorMessage(this.errorString);
                    error.setErrors(this.errorHashMap);
                }
            } else {
                error = new Error();
                error.setErrorMessage(this.errorString);
                error.setErrors(this.errorHashMap);
            }
        }
        catch (Exception e) {
            this.throwException("find", "Please provide valid JSON.", null);
            error = new Error();
            error.setErrorMessage(this.errorString);
            error.setErrors(this.errorHashMap);
        }
        if (error != null && callBack != null) {
            callBack.onRequestFail(ResponseType.UNKNOWN, error);
        }
        return this;
    }

    private void throwException(String queryName, String messageString, Exception e) {
        this.isJsonProper = false;
        this.errorString = messageString;
        this.errorHashMap = new HashMap();
        if (e != null) {
            this.errorHashMap.put(queryName, e.toString());
        }
    }

    protected void setQueryJson(QueryResultsCallBack callback) {
        try {
            if (this.queryValueJSON != null && this.queryValueJSON.length() > 0) {
                this.urlQueries.put("query", (Object)this.queryValueJSON);
            }
            if (this.objectUidForExcept != null && this.objectUidForExcept.length() > 0) {
                this.urlQueries.put("except[BASE][]", (Object)this.objectUidForExcept);
                this.objectUidForExcept = null;
            }
            if (this.objectUidForOnly != null && this.objectUidForOnly.length() > 0) {
                this.urlQueries.put("only[BASE][]", (Object)this.objectUidForOnly);
                this.objectUidForOnly = null;
            }
            if (this.onlyJsonObject != null && this.onlyJsonObject.length() > 0) {
                this.urlQueries.put("only", (Object)this.onlyJsonObject);
                this.onlyJsonObject = null;
            }
            if (this.exceptJsonObject != null && this.exceptJsonObject.length() > 0) {
                this.urlQueries.put("except", (Object)this.exceptJsonObject);
                this.exceptJsonObject = null;
            }
            if (this.objectUidForInclude != null && this.objectUidForInclude.length() > 0) {
                this.urlQueries.put("include[]", (Object)this.objectUidForInclude);
                this.objectUidForInclude = null;
            }
        }
        catch (Exception e) {
            this.throwException("find", "Please provide valid params.", e);
        }
    }

    protected void execQuery(SingleQueryResultCallback callBack, QueryResultsCallBack callback, boolean isFromLocal) {
        try {
            String URL = "/" + this.contentTypeInstance.stackInstance.VERSION + "/content_types/" + this.formName + "/entries";
            this.queryResultCallback = callback;
            this.singleQueryResultCallback = callBack;
            this.setQueryJson(callback);
            LinkedHashMap<String, Object> headers = this.getHeader(this.localHeader);
            if (headers.size() < 1) {
                this.throwException("find", "You must called Contentstack.stack() first", null);
            } else {
                if (headers.containsKey("environment")) {
                    this.urlQueries.put("environment", headers.get("environment"));
                }
                this.mainJSON.put("query", (Object)this.urlQueries);
                this.mainJSON.put("_method", (Object)CSAppConstants.RequestMethod.GET.toString());
                this.fetchFromNetwork(URL, headers, this.mainJSON, callback, callBack);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.throwException("find", "Please provide valid params.", e);
        }
    }

    private void fetchFromNetwork(String URL, LinkedHashMap<String, Object> headers, JSONObject jsonMain, ResultCallBack callback, SingleQueryResultCallback resultCallback) {
        LinkedHashMap<String, Object> urlParams = this.getUrlParams(jsonMain);
        if (resultCallback != null) {
            new CSBackgroundTask(this, this.contentTypeInstance.stackInstance, "getSingleQueryEntries", URL, headers, urlParams, new JSONObject(), CSAppConstants.callController.QUERY.toString(), CSAppConstants.RequestMethod.GET, (ResultCallBack)resultCallback);
        } else {
            new CSBackgroundTask(this, this.contentTypeInstance.stackInstance, "getQueryEntries", URL, headers, urlParams, new JSONObject(), CSAppConstants.callController.QUERY.toString(), CSAppConstants.RequestMethod.GET, callback);
        }
    }

    private LinkedHashMap<String, Object> getUrlParams(JSONObject jsonMain) {
        JSONObject queryJSON = jsonMain.optJSONObject("query");
        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<String, Object>();
        if (queryJSON != null && queryJSON.length() > 0) {
            Iterator iter = queryJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    Object value = queryJSON.opt(key);
                    hashMap.put(key, value);
                }
                catch (Exception e) {
                    Stack.log(TAG, "----------------setQueryJson" + e.getLocalizedMessage());
                }
            }
            return hashMap;
        }
        return null;
    }

    @Override
    public void getResult(Object object, String controller) {
    }

    @Override
    public void getResultObject(List<Object> objects, JSONObject jsonObject, boolean isSingleEntry) {
        ArrayList<Entry> objectList = new ArrayList<Entry>();
        int countObject = objects.size();
        for (int i = 0; i < countObject; ++i) {
            Entry entry = null;
            try {
                entry = this.contentTypeInstance.stackInstance.contentType(this.formName).entry(((EntryModel)objects.get((int)i)).entryUid);
            }
            catch (Exception e) {
                entry = new Entry(this.formName);
            }
            entry.setUid(((EntryModel)objects.get((int)i)).entryUid);
            entry.resultJson = ((EntryModel)objects.get((int)i)).jsonObject;
            entry.ownerEmailId = ((EntryModel)objects.get((int)i)).ownerEmailId;
            entry.ownerUid = ((EntryModel)objects.get((int)i)).ownerUid;
            entry.title = ((EntryModel)objects.get((int)i)).title;
            entry.url = ((EntryModel)objects.get((int)i)).url;
            if (((EntryModel)objects.get((int)i)).ownerMap != null) {
                entry.owner = new HashMap<String, Object>(((EntryModel)objects.get((int)i)).ownerMap);
            }
            if (((EntryModel)objects.get((int)i))._metadata != null) {
                entry._metadata = new HashMap<String, Object>(((EntryModel)objects.get((int)i))._metadata);
            }
            entry.setTags(((EntryModel)objects.get((int)i)).tags);
            objectList.add(entry);
        }
        if (isSingleEntry) {
            Entry entry = this.contentTypeInstance.entry();
            if (objectList != null && objectList.size() > 0) {
                entry = (Entry)objectList.get(0);
            }
            if (this.singleQueryResultCallback != null) {
                this.singleQueryResultCallback.onRequestFinish(ResponseType.NETWORK, entry);
            }
        } else {
            QueryResult queryResultObject = new QueryResult();
            queryResultObject.setJSON(jsonObject, objectList);
            if (this.queryResultCallback != null) {
                this.queryResultCallback.onRequestFinish(ResponseType.NETWORK, queryResultObject);
            }
        }
    }

    private LinkedHashMap<String, Object> getHeader(LinkedHashMap<String, Object> localHeader) {
        LinkedHashMap<String, Object> mainHeader = this.formHeader;
        LinkedHashMap<String, Object> classHeaders = new LinkedHashMap<String, Object>();
        if (localHeader != null && localHeader.size() > 0) {
            if (mainHeader != null && mainHeader.size() > 0) {
                String key;
                for (Map.Entry<String, Object> entry : localHeader.entrySet()) {
                    key = entry.getKey();
                    classHeaders.put(key, entry.getValue());
                }
                for (Map.Entry<String, Object> entry : mainHeader.entrySet()) {
                    key = entry.getKey();
                    if (classHeaders.containsKey(key)) continue;
                    classHeaders.put(key, entry.getValue());
                }
                return classHeaders;
            }
            return localHeader;
        }
        return this.formHeader;
    }

    public Query addParam(String key, String value) {
        try {
            if (key != null && value != null) {
                this.urlQueries.put(key, (Object)value);
            } else {
                this.throwException("and", "Please provide valid params.", null);
            }
        }
        catch (Exception e) {
            this.throwException("and", "Please provide valid params.", e);
        }
        return this;
    }

    public Query includeReferenceContentTypUid() {
        try {
            this.urlQueries.put("include_reference_content_type_uid", (Object)"true");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }
}

