/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.IRequestModelHTTP;
import com.contentstack.sdk.IURLRequestHTTP;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import com.contentstack.sdk.utility.CSAppConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CSHttpConnection
implements IURLRequestHTTP {
    private static final String TAG = "CSHttpConnection";
    private String urlPath;
    private String controller;
    private LinkedHashMap<String, Object> headers;
    private String info;
    private JSONObject requestJSON;
    private IRequestModelHTTP connectionRequest;
    private ResultCallBack callBackObject;
    private CSAppConstants.RequestMethod requestMethod;
    private JSONObject responseJSON;
    private HashMap<String, Object> formParams;
    private boolean treatDuplicateKeysAsArrayItems;

    public HashMap<String, Object> getFormParams() {
        return this.formParams;
    }

    public void setFormParams(HashMap<String, Object> formParams) {
        this.formParams = formParams;
    }

    public CSHttpConnection(String urlToCall, IRequestModelHTTP csConnectionRequest) {
        this.urlPath = urlToCall;
        this.connectionRequest = csConnectionRequest;
    }

    @Override
    public void setController(String controller) {
        this.controller = controller;
    }

    @Override
    public String getController() {
        return this.controller;
    }

    @Override
    public void setHeaders(LinkedHashMap headers) {
        this.headers = headers;
    }

    @Override
    public LinkedHashMap getHeaders() {
        return this.headers;
    }

    @Override
    public void setInfo(String info) {
        this.info = info;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    public void setFormParamsPOST(JSONObject requestJSON) {
        this.requestJSON = null;
        this.requestJSON = requestJSON;
    }

    @Override
    public void setCallBackObject(ResultCallBack callBackObject) {
        this.callBackObject = callBackObject;
    }

    @Override
    public ResultCallBack getCallBackObject() {
        return this.callBackObject;
    }

    @Override
    public void setTreatDuplicateKeysAsArrayItems(boolean treatDuplicateKeysAsArrayItems) {
        this.treatDuplicateKeysAsArrayItems = treatDuplicateKeysAsArrayItems;
    }

    @Override
    public boolean getTreatDuplicateKeysAsArrayItems() {
        return this.treatDuplicateKeysAsArrayItems;
    }

    @Override
    public void setRequestMethod(CSAppConstants.RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    @Override
    public CSAppConstants.RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public JSONObject getResponse() {
        return this.responseJSON;
    }

    public String setFormParamsGET(HashMap<String, Object> params) {
        if (params != null && params.size() > 0) {
            String urlParams = null;
            String string = urlParams = this.info.equalsIgnoreCase(CSAppConstants.callController.QUERY.name()) || this.info.equalsIgnoreCase(CSAppConstants.callController.ENTRY.name()) ? this.getParams(params) : null;
            if (urlParams == null) {
                for (Map.Entry<String, Object> e : params.entrySet()) {
                    if (urlParams == null) {
                        urlParams = "?" + e.getKey() + "=" + e.getValue();
                        continue;
                    }
                    urlParams = urlParams + "&" + e.getKey() + "=" + e.getValue();
                }
            }
            return urlParams;
        }
        return null;
    }

    private String getParams(HashMap<String, Object> params) {
        String urlParams = "?";
        for (Map.Entry<String, Object> e : params.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            try {
                int i;
                JSONArray array;
                String innerKey;
                JSONObject onlyJSON;
                JSONArray array2;
                if (key.equalsIgnoreCase("include[]")) {
                    key = URLEncoder.encode(key, "UTF-8");
                    array2 = (JSONArray)value;
                    for (int i2 = 0; i2 < array2.length(); ++i2) {
                        urlParams = urlParams + (urlParams.equals("?") ? key + "=" + array2.opt(i2) : "&" + key + "=" + array2.opt(i2));
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("only[BASE][]")) {
                    key = URLEncoder.encode(key, "UTF-8");
                    array2 = (JSONArray)value;
                    for (int i3 = 0; i3 < array2.length(); ++i3) {
                        urlParams = urlParams + (urlParams.equals("?") ? key + "=" + array2.opt(i3) : "&" + key + "=" + array2.opt(i3));
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("except[BASE][]")) {
                    key = URLEncoder.encode(key, "UTF-8");
                    array2 = (JSONArray)value;
                    for (int i4 = 0; i4 < array2.length(); ++i4) {
                        urlParams = urlParams + (urlParams.equals("?") ? key + "=" + array2.opt(i4) : "&" + key + "=" + array2.opt(i4));
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("only")) {
                    onlyJSON = (JSONObject)value;
                    Iterator iter = onlyJSON.keys();
                    while (iter.hasNext()) {
                        innerKey = (String)iter.next();
                        array = onlyJSON.optJSONArray(innerKey);
                        innerKey = URLEncoder.encode("only[" + innerKey + "][]", "UTF-8");
                        for (i = 0; i < array.length(); ++i) {
                            urlParams = urlParams + (urlParams.equals("?") ? innerKey + "=" + array.opt(i) : "&" + innerKey + "=" + array.opt(i));
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("except")) {
                    onlyJSON = (JSONObject)value;
                    Iterator iter = onlyJSON.keys();
                    while (iter.hasNext()) {
                        innerKey = (String)iter.next();
                        array = onlyJSON.optJSONArray(innerKey);
                        innerKey = URLEncoder.encode("except[" + innerKey + "][]", "UTF-8");
                        for (i = 0; i < array.length(); ++i) {
                            urlParams = urlParams + (urlParams.equals("?") ? innerKey + "=" + array.opt(i) : "&" + innerKey + "=" + array.opt(i));
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("query")) {
                    JSONObject queryJSON = (JSONObject)value;
                    urlParams = urlParams + (urlParams.equals("?") ? key + "=" + URLEncoder.encode(queryJSON.toString(), "UTF-8") : "&" + key + "=" + URLEncoder.encode(queryJSON.toString(), "UTF-8"));
                    continue;
                }
                urlParams = urlParams + (urlParams.equals("?") ? key + "=" + value : "&" + key + "=" + value);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return urlParams;
    }

    @Override
    public void send() {
        String params;
        String url = null;
        url = this.requestMethod == CSAppConstants.RequestMethod.GET ? ((params = this.setFormParamsGET(this.formParams)) != null ? this.urlPath + params : this.urlPath) : this.urlPath;
        try {
            this.sendGET(url);
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
    }

    private void sendGET(String GET_URL) throws IOException, JSONException {
        URL obj = new URL(GET_URL);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        if (this.headers.containsKey("api_key")) {
            con.setRequestProperty("api_key", this.headers.get("api_key").toString());
        }
        if (this.headers.containsKey("access_token")) {
            con.setRequestProperty("access_token", this.headers.get("access_token").toString());
        }
        if (this.headers.containsKey("environment")) {
            con.setRequestProperty("environment", this.headers.get("environment").toString());
        }
        con.setRequestProperty("X-User-Agent", this.defaultUserAgent() + "/" + "1.5.0");
        con.setRequestProperty("Content-Type", "application/json");
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                StringBuilder stringBuilder = response.append(inputLine);
            }
            in.close();
            this.responseJSON = new JSONObject(response.toString());
            this.connectionRequest.onRequestFinished(this);
        } else {
            Stack.log(TAG, "GET request not worked");
            this.generateBuiltError(con);
        }
    }

    private String defaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? agent : "Java" + System.getProperty("java.version");
    }

    private void generateBuiltError(HttpURLConnection connection) {
        try {
            int statusCode = 0;
            this.responseJSON = new JSONObject();
            this.responseJSON.put("error_message", (Object)"Oops! Something went wrong. Please try again.");
            if (connection != null) {
                String responseMessage = connection.getResponseMessage();
                statusCode = connection.getResponseCode();
                try {
                    if (connection.getResponseMessage() == null && connection.getResponseMessage().equalsIgnoreCase("")) {
                        statusCode = connection.getResponseCode();
                        this.responseJSON.put("error_message", (Object)"Oops! Something went wrong. Please try again.");
                    } else {
                        if (responseMessage.toString().equalsIgnoreCase("NoConnectionError")) {
                            this.responseJSON.put("error_message", (Object)"Connection error");
                        } else if (responseMessage.toString().equalsIgnoreCase("AuthFailureError")) {
                            this.responseJSON.put("error_message", (Object)"Authentication Not present.");
                        } else if (responseMessage.toString().equalsIgnoreCase("NetworkError")) {
                            this.responseJSON.put("error_message", (Object)"Network not available.");
                        } else if (responseMessage.toString().equalsIgnoreCase("ParseError")) {
                            this.responseJSON.put("error_message", (Object)"Parsing Error.");
                        } else if (responseMessage.toString().equalsIgnoreCase("ServerError")) {
                            this.responseJSON.put("error_message", (Object)"Server interaction went wrong, Please try again.");
                        } else if (responseMessage.toString().equalsIgnoreCase("TimeoutError")) {
                            this.responseJSON.put("error_message", (Object)"Server interaction went wrong, Please try again.");
                        } else {
                            this.responseJSON.put("error_message", (Object)responseMessage);
                        }
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("errors", (Object)responseMessage.toString());
                        this.responseJSON.put("errors", (Object)jsonObject);
                    }
                    this.connectionRequest.onRequestFailed(this.responseJSON, statusCode, this.callBackObject);
                }
                catch (Exception e) {
                    this.connectionRequest.onRequestFailed(this.responseJSON, 0, this.callBackObject);
                }
            } else {
                this.connectionRequest.onRequestFailed(this.responseJSON, 0, this.callBackObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

