/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.EntryModel;
import com.contentstack.sdk.EntryResultCallBack;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.Group;
import com.contentstack.sdk.Language;
import com.contentstack.sdk.LanguageCode;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import com.contentstack.sdk.utility.CSAppConstants;
import com.contentstack.sdk.utility.ContentstackUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Entry {
    private static final String TAG = "Entry";
    private String contentTypeName = null;
    private LinkedHashMap<String, Object> localHeader = null;
    protected LinkedHashMap<String, Object> formHeader = null;
    protected HashMap<String, Object> owner = null;
    protected HashMap<String, Object> _metadata = null;
    private ContentType contentTypeInstance = null;
    private String[] tags = null;
    protected String uid = null;
    protected JSONObject resultJson = null;
    protected String ownerEmailId = null;
    protected String ownerUid = null;
    protected String title = null;
    protected String url = null;
    protected String language = null;
    private JSONArray referenceArray;
    private JSONObject otherPostJSON;
    private JSONArray objectUidForOnly;
    private JSONArray objectUidForExcept;
    private JSONObject onlyJsonObject;
    private JSONObject exceptJsonObject;

    private Entry() {
    }

    protected Entry(String contentTypeName) {
        this.contentTypeName = contentTypeName;
        this.localHeader = new LinkedHashMap();
        this.otherPostJSON = new JSONObject();
    }

    protected void setContentTypeInstance(ContentType contentTypeInstance) {
        this.contentTypeInstance = contentTypeInstance;
    }

    public Entry configure(JSONObject jsonObject) {
        EntryModel model = new EntryModel(jsonObject, null, true, false, false);
        this.resultJson = model.jsonObject;
        this.ownerEmailId = model.ownerEmailId;
        this.ownerUid = model.ownerUid;
        this.title = model.title;
        this.url = model.url;
        this.language = model.language;
        if (model.ownerMap != null) {
            this.owner = new HashMap<String, Object>(model.ownerMap);
        }
        if (model._metadata != null) {
            this._metadata = new HashMap<String, Object>(model._metadata);
        }
        this.uid = model.entryUid;
        this.setTags(model.tags);
        model = null;
        return this;
    }

    public void setHeader(String key, String value) {
        if (!key.isEmpty() && !value.isEmpty()) {
            this.localHeader.put(key, value);
        }
    }

    public void removeHeader(String key) {
        if (!key.isEmpty()) {
            this.localHeader.remove(key);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getURL() {
        return this.url;
    }

    public String[] getTags() {
        return this.tags;
    }

    public String getContentType() {
        return this.contentTypeName;
    }

    public String getUid() {
        return this.uid;
    }

    private HashMap<String, Object> getMetadata() {
        return this._metadata;
    }

    @Deprecated
    public Language getLanguage() {
        String localeCode = null;
        if (this._metadata != null && this._metadata.size() > 0 && this._metadata.containsKey("locale")) {
            localeCode = (String)this._metadata.get("locale");
        } else if (this.resultJson.has("locale")) {
            localeCode = this.resultJson.optString("locale");
        }
        if (localeCode != null) {
            localeCode = localeCode.replace("-", "_");
            LanguageCode codeValue = LanguageCode.valueOf(localeCode);
            int localeValue = codeValue.ordinal();
            Language[] language = Language.values();
            return language[localeValue];
        }
        return null;
    }

    public Entry setLocale(String locale) {
        if (locale != null) {
            try {
                this.otherPostJSON.put("locale", (Object)locale);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public String getLocale() {
        return this.language;
    }

    public HashMap<String, Object> getOwner() {
        return this.owner;
    }

    public JSONObject toJSON() {
        return this.resultJson;
    }

    public Object get(String key) {
        try {
            if (this.resultJson != null && key != null) {
                return this.resultJson.get(key);
            }
            return null;
        }
        catch (Exception e) {
            Stack.log(TAG, e.getLocalizedMessage());
            return null;
        }
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public JSONArray getJSONArray(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return null;
    }

    public JSONObject getJSONObject(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return null;
    }

    public Number getNumber(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof Number) {
            return (Number)value;
        }
        return null;
    }

    public int getInt(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.intValue();
        }
        return 0;
    }

    public float getFloat(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.floatValue();
        }
        return 0.0f;
    }

    public double getDouble(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.doubleValue();
        }
        return 0.0;
    }

    public long getLong(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.longValue();
        }
        return 0L;
    }

    public short getShort(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.shortValue();
        }
        return 0;
    }

    public Calendar getDate(String key) {
        try {
            String value = this.getString(key);
            return ContentstackUtil.parseDate(value, null);
        }
        catch (Exception e) {
            Stack.log(TAG, e.getLocalizedMessage());
            return null;
        }
    }

    public Calendar getCreateAt() {
        try {
            String value = this.getString("created_at");
            return ContentstackUtil.parseDate(value, null);
        }
        catch (Exception e) {
            Stack.log(TAG, e.getLocalizedMessage());
            return null;
        }
    }

    public String getCreatedBy() {
        return this.getString("created_by");
    }

    public Calendar getUpdateAt() {
        try {
            String value = this.getString("updated_at");
            return ContentstackUtil.parseDate(value, null);
        }
        catch (Exception e) {
            Stack.log(TAG, e.getLocalizedMessage());
            return null;
        }
    }

    public String getUpdatedBy() {
        return this.getString("updated_by");
    }

    public Calendar getDeleteAt() {
        try {
            String value = this.getString("deleted_at");
            return ContentstackUtil.parseDate(value, null);
        }
        catch (Exception e) {
            Stack.log(TAG, e.getLocalizedMessage());
            return null;
        }
    }

    public String getDeletedBy() {
        return this.getString("deleted_by");
    }

    public Asset getAsset(String key) {
        JSONObject assetObject = this.getJSONObject(key);
        Asset asset = this.contentTypeInstance.stackInstance.asset().configure(assetObject);
        return asset;
    }

    public List<Asset> getAssets(String key) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        JSONArray assetArray = this.getJSONArray(key);
        for (int i = 0; i < assetArray.length(); ++i) {
            if (!(assetArray.opt(i) instanceof JSONObject)) continue;
            Asset asset = this.contentTypeInstance.stackInstance.asset().configure(assetArray.optJSONObject(i));
            assets.add(asset);
        }
        return assets;
    }

    public Group getGroup(String key) {
        if (!key.isEmpty() && this.resultJson.has(key) && this.resultJson.opt(key) instanceof JSONObject) {
            return new Group(this.contentTypeInstance.stackInstance, this.resultJson.optJSONObject(key));
        }
        return null;
    }

    public List<Group> getGroups(String key) {
        if (!key.isEmpty() && this.resultJson.has(key) && this.resultJson.opt(key) instanceof JSONArray) {
            JSONArray array = this.resultJson.optJSONArray(key);
            ArrayList<Group> groupList = new ArrayList<Group>();
            for (int i = 0; i < array.length(); ++i) {
                if (!(array.opt(i) instanceof JSONObject)) continue;
                Group group = new Group(this.contentTypeInstance.stackInstance, array.optJSONObject(i));
                groupList.add(group);
            }
            return groupList;
        }
        return null;
    }

    public ArrayList<Entry> getAllEntries(String refKey, String refContentType) {
        block6: {
            try {
                if (this.resultJson == null || !(this.resultJson.get(refKey) instanceof JSONArray)) break block6;
                int count = ((JSONArray)this.resultJson.get(refKey)).length();
                ArrayList<Entry> builtObjectList = new ArrayList<Entry>();
                for (int i = 0; i < count; ++i) {
                    EntryModel model = new EntryModel(((JSONArray)this.resultJson.get(refKey)).getJSONObject(i), null, false, false, true);
                    Entry entryInstance = null;
                    try {
                        entryInstance = this.contentTypeInstance.stackInstance.contentType(refContentType).entry();
                    }
                    catch (Exception e) {
                        entryInstance = new Entry(refContentType);
                        Stack.log("BuiltObject", "---------getAllEntries" + e.toString());
                    }
                    entryInstance.setUid(model.entryUid);
                    entryInstance.ownerEmailId = model.ownerEmailId;
                    entryInstance.ownerUid = model.ownerUid;
                    if (model.ownerMap != null) {
                        entryInstance.owner = new HashMap<String, Object>(model.ownerMap);
                    }
                    entryInstance.resultJson = model.jsonObject;
                    entryInstance.setTags(model.tags);
                    builtObjectList.add(entryInstance);
                    model = null;
                }
                return builtObjectList;
            }
            catch (Exception e) {
                Stack.log(TAG, "-----------------get|" + e);
                return null;
            }
        }
        return null;
    }

    public Entry except(String[] fieldUid) {
        try {
            if (fieldUid != null && fieldUid.length > 0) {
                if (this.objectUidForExcept == null) {
                    this.objectUidForExcept = new JSONArray();
                }
                int count = fieldUid.length;
                for (int i = 0; i < count; ++i) {
                    this.objectUidForExcept.put((Object)fieldUid[i]);
                }
            }
        }
        catch (Exception e) {
            Stack.log(TAG, "--except-catch|" + e);
        }
        return this;
    }

    public Entry includeReference(String referenceField) {
        try {
            if (!referenceField.isEmpty()) {
                if (this.referenceArray == null) {
                    this.referenceArray = new JSONArray();
                }
                this.referenceArray.put((Object)referenceField);
                this.otherPostJSON.put("include[]", (Object)this.referenceArray);
            }
        }
        catch (Exception e) {
            Stack.log(TAG, "--include Reference-catch|" + e);
        }
        return this;
    }

    public Entry includeReference(String[] referenceFields) {
        try {
            if (referenceFields != null && referenceFields.length > 0) {
                if (this.referenceArray == null) {
                    this.referenceArray = new JSONArray();
                }
                for (int i = 0; i < referenceFields.length; ++i) {
                    this.referenceArray.put((Object)referenceFields[i]);
                }
                this.otherPostJSON.put("include[]", (Object)this.referenceArray);
            }
        }
        catch (Exception e) {
            Stack.log(TAG, "--include Reference-catch|" + e);
        }
        return this;
    }

    public Entry only(String[] fieldUid) {
        try {
            if (fieldUid != null && fieldUid.length > 0) {
                if (this.objectUidForOnly == null) {
                    this.objectUidForOnly = new JSONArray();
                }
                int count = fieldUid.length;
                for (int i = 0; i < count; ++i) {
                    this.objectUidForOnly.put((Object)fieldUid[i]);
                }
            }
        }
        catch (Exception e) {
            Stack.log(TAG, "--include Reference-catch|" + e);
        }
        return this;
    }

    public Entry onlyWithReferenceUid(ArrayList<String> fieldUid, String referenceFieldUid) {
        try {
            if (fieldUid != null && referenceFieldUid != null) {
                if (this.onlyJsonObject == null) {
                    this.onlyJsonObject = new JSONObject();
                }
                JSONArray fieldValueArray = new JSONArray();
                int count = fieldUid.size();
                for (int i = 0; i < count; ++i) {
                    fieldValueArray.put((Object)fieldUid.get(i));
                }
                this.onlyJsonObject.put(referenceFieldUid, (Object)fieldValueArray);
                this.includeReference(referenceFieldUid);
            }
        }
        catch (Exception e) {
            Stack.log(TAG, "--onlyWithReferenceUid-catch|" + e);
        }
        return this;
    }

    public Entry exceptWithReferenceUid(ArrayList<String> fieldUid, String referenceFieldUid) {
        try {
            if (fieldUid != null && referenceFieldUid != null) {
                if (this.exceptJsonObject == null) {
                    this.exceptJsonObject = new JSONObject();
                }
                JSONArray fieldValueArray = new JSONArray();
                int count = fieldUid.size();
                for (int i = 0; i < count; ++i) {
                    fieldValueArray.put((Object)fieldUid.get(i));
                }
                this.exceptJsonObject.put(referenceFieldUid, (Object)fieldValueArray);
                this.includeReference(referenceFieldUid);
            }
        }
        catch (Exception e) {
            Stack.log(TAG, "--exceptWithReferenceUid-catch|" + e);
        }
        return this;
    }

    protected void setTags(String[] tags) {
        this.tags = tags;
    }

    protected void setUid(String uid) {
        this.uid = uid;
    }

    public void fetch(EntryResultCallBack callBack) {
        try {
            if (!this.uid.isEmpty()) {
                String URL2 = "/" + this.contentTypeInstance.stackInstance.VERSION + "/content_types/" + this.contentTypeName + "/entries/" + this.uid;
                LinkedHashMap<String, Object> headers = this.getHeader(this.localHeader);
                LinkedHashMap<String, String> headerAll = new LinkedHashMap<String, String>();
                JSONObject urlQueries = new JSONObject();
                if (headers != null && headers.size() > 0) {
                    for (Map.Entry<String, Object> entry : headers.entrySet()) {
                        headerAll.put(entry.getKey(), (String)entry.getValue());
                    }
                    if (headers.containsKey("environment")) {
                        urlQueries.put("environment", headers.get("environment"));
                    }
                }
                this.fetchFromNetwork(URL2, urlQueries, callBack);
            }
        }
        catch (Exception e) {
            this.throwException(null, e, callBack);
        }
    }

    private void fetchFromNetwork(String URL2, JSONObject urlQueries, EntryResultCallBack callBack) {
        try {
            JSONObject mainJson = new JSONObject();
            this.setIncludeJSON(urlQueries, callBack);
            mainJson.put("query", (Object)urlQueries);
            mainJson.put("_method", (Object)CSAppConstants.RequestMethod.GET.toString());
            LinkedHashMap<String, Object> urlParams = this.getUrlParams(mainJson);
            new CSBackgroundTask(this, this.contentTypeInstance.stackInstance, "getEntry", URL2, this.getHeader(this.localHeader), urlParams, new JSONObject(), CSAppConstants.callController.ENTRY.toString(), false, CSAppConstants.RequestMethod.GET, (ResultCallBack)callBack);
        }
        catch (Exception e) {
            this.throwException(null, e, callBack);
        }
    }

    private LinkedHashMap<String, Object> getUrlParams(JSONObject jsonMain) {
        JSONObject queryJSON = jsonMain.optJSONObject("query");
        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<String, Object>();
        if (queryJSON != null && queryJSON.length() > 0) {
            Iterator iter = queryJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    Object value = queryJSON.opt(key);
                    hashMap.put(key, value);
                }
                catch (Exception e) {
                    Stack.log(TAG, "----------------setQueryJson" + e.toString());
                }
            }
            return hashMap;
        }
        return null;
    }

    private void setIncludeJSON(JSONObject mainJson, ResultCallBack callBack) {
        try {
            Iterator iterator = this.otherPostJSON.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = this.otherPostJSON.get(key);
                mainJson.put(key, value);
            }
            if (this.objectUidForOnly != null && this.objectUidForOnly.length() > 0) {
                mainJson.put("only[BASE][]", (Object)this.objectUidForOnly);
                this.objectUidForOnly = null;
            }
            if (this.objectUidForExcept != null && this.objectUidForExcept.length() > 0) {
                mainJson.put("except[BASE][]", (Object)this.objectUidForExcept);
                this.objectUidForExcept = null;
            }
            if (this.exceptJsonObject != null && this.exceptJsonObject.length() > 0) {
                mainJson.put("except", (Object)this.exceptJsonObject);
                this.exceptJsonObject = null;
            }
            if (this.onlyJsonObject != null && this.onlyJsonObject.length() > 0) {
                mainJson.put("only", (Object)this.onlyJsonObject);
                this.onlyJsonObject = null;
            }
        }
        catch (Exception e) {
            this.throwException(null, e, (EntryResultCallBack)callBack);
        }
    }

    private void throwException(String errorMsg, Exception e, EntryResultCallBack callBack) {
        Error error = new Error();
        if (errorMsg != null) {
            error.setErrorMessage(errorMsg);
        } else {
            error.setErrorMessage(e.toString());
        }
        callBack.onRequestFail(ResponseType.UNKNOWN, error);
    }

    private LinkedHashMap<String, Object> getHeader(LinkedHashMap<String, Object> localHeader) {
        LinkedHashMap<String, Object> mainHeader = this.formHeader;
        LinkedHashMap<String, Object> classHeaders = new LinkedHashMap<String, Object>();
        if (localHeader != null && localHeader.size() > 0) {
            if (mainHeader != null && mainHeader.size() > 0) {
                String key;
                for (Map.Entry<String, Object> entry : localHeader.entrySet()) {
                    key = entry.getKey();
                    classHeaders.put(key, entry.getValue());
                }
                for (Map.Entry<String, Object> entry : mainHeader.entrySet()) {
                    key = entry.getKey();
                    if (classHeaders.containsKey(key)) continue;
                    classHeaders.put(key, entry.getValue());
                }
                return classHeaders;
            }
            return localHeader;
        }
        return this.formHeader;
    }

    public Entry addParam(String key, String value) {
        if (key != null && value != null) {
            try {
                this.otherPostJSON.put(key, (Object)value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public Entry includeReferenceContentTypeUID() {
        try {
            this.otherPostJSON.put("include_reference_content_type_uid", (Object)"true");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Entry includeContentType() {
        try {
            if (this.otherPostJSON.has("include_schema")) {
                this.otherPostJSON.remove("include_schema");
            }
            this.otherPostJSON.put("include_content_type", true);
            this.otherPostJSON.put("include_global_field_schema", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }
}

