/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.AssetModel;
import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.FetchResultCallback;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import com.contentstack.sdk.utility.CSAppConstants;
import com.contentstack.sdk.utility.ContentstackUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONObject;

public class Asset {
    protected String assetUid = null;
    protected String contentType = null;
    protected String fileSize = null;
    protected String fileName = null;
    protected String uploadUrl = null;
    protected JSONObject json = null;
    protected String[] tagsArray = null;
    protected JSONObject urlQueries = new JSONObject();
    protected LinkedHashMap<String, Object> headerGroup_app;
    protected LinkedHashMap<String, Object> headerGroup_local;
    protected Stack stackInstance;

    protected Asset() {
        this.headerGroup_local = new LinkedHashMap();
        this.headerGroup_app = new LinkedHashMap();
    }

    protected Asset(String assetUid) {
        this.assetUid = assetUid;
        this.headerGroup_local = new LinkedHashMap();
        this.headerGroup_app = new LinkedHashMap();
    }

    protected void setStackInstance(Stack stack) {
        this.stackInstance = stack;
        this.headerGroup_app = stack.localHeader;
    }

    public Asset configure(JSONObject jsonObject) {
        AssetModel model = null;
        model = new AssetModel(jsonObject, true, false);
        this.contentType = model.contentType;
        this.fileSize = model.fileSize;
        this.uploadUrl = model.uploadUrl;
        this.fileName = model.fileName;
        this.json = model.json;
        this.assetUid = model.uploadedUid;
        this.setTags(model.tags);
        model = null;
        return this;
    }

    protected Asset setTags(String[] tags) {
        this.tagsArray = tags;
        return this;
    }

    public void setHeader(String key, String value) {
        if (!key.isEmpty() && !value.isEmpty()) {
            this.removeHeader(key);
            this.headerGroup_local.put(key, value);
        }
    }

    public void removeHeader(String key) {
        if (this.headerGroup_local != null && !key.isEmpty()) {
            this.headerGroup_local.remove(key);
        }
    }

    protected void setUid(String assetUid) {
        if (!assetUid.isEmpty()) {
            this.assetUid = assetUid;
        }
    }

    public String getAssetUid() {
        return this.assetUid;
    }

    public String getFileType() {
        return this.contentType;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUrl() {
        return this.uploadUrl;
    }

    public JSONObject toJSON() {
        return this.json;
    }

    public Calendar getCreateAt() {
        try {
            String value = this.json.optString("created_at");
            return ContentstackUtil.parseDate(value, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCreatedBy() {
        return this.json.optString("created_by");
    }

    public Calendar getUpdateAt() {
        try {
            String value = this.json.optString("updated_at");
            return ContentstackUtil.parseDate(value, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUpdatedBy() {
        return this.json.optString("updated_by");
    }

    public Calendar getDeleteAt() {
        try {
            String value = this.json.optString("deleted_at");
            return ContentstackUtil.parseDate(value, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDeletedBy() {
        return this.json.optString("deleted_by");
    }

    public String[] getTags() {
        return this.tagsArray;
    }

    public Asset includeDimension() {
        this.urlQueries.put("include_dimension", true);
        return this;
    }

    public void fetch(FetchResultCallback callback) {
        try {
            String URL2 = "/" + this.stackInstance.VERSION + "/assets/" + this.assetUid;
            LinkedHashMap<String, Object> headers = this.getHeader(this.headerGroup_local);
            if (headers.containsKey("environment")) {
                this.urlQueries.put("environment", headers.get("environment"));
            }
            this.fetchFromNetwork(URL2, this.urlQueries, headers, callback);
        }
        catch (Exception e) {
            Error error = new Error();
            error.setErrorMessage("Please provide valid JSON.");
            callback.onRequestFail(ResponseType.UNKNOWN, error);
        }
    }

    private void fetchFromNetwork(String URL2, JSONObject urlQueries, LinkedHashMap<String, Object> headers, FetchResultCallback callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(urlQueries);
            new CSBackgroundTask(this, this.stackInstance, "getAssets", URL2, headers, urlParams, new JSONObject(), CSAppConstants.callController.ASSET.toString(), false, CSAppConstants.RequestMethod.GET, (ResultCallBack)callback);
        }
    }

    private HashMap<String, Object> getUrlParams(JSONObject urlQueriesJSON) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (urlQueriesJSON != null && urlQueriesJSON.length() > 0) {
            Iterator iter = urlQueriesJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    Object value = urlQueriesJSON.opt(key);
                    hashMap.put(key, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return hashMap;
        }
        return null;
    }

    private LinkedHashMap<String, Object> getHeader(LinkedHashMap<String, Object> localHeader) {
        LinkedHashMap<String, Object> mainHeader = this.headerGroup_app;
        LinkedHashMap<String, Object> classHeaders = new LinkedHashMap<String, Object>();
        if (localHeader != null && localHeader.size() > 0) {
            if (mainHeader != null && mainHeader.size() > 0) {
                String key;
                for (Map.Entry<String, Object> entry : localHeader.entrySet()) {
                    key = entry.getKey();
                    classHeaders.put(key, entry.getValue());
                }
                for (Map.Entry<String, Object> entry : mainHeader.entrySet()) {
                    key = entry.getKey();
                    if (classHeaders.containsKey(key)) continue;
                    classHeaders.put(key, entry.getValue());
                }
                return classHeaders;
            }
            return localHeader;
        }
        return this.headerGroup_app;
    }

    public Asset addParam(String key, String value) {
        if (key != null && value != null) {
            this.urlQueries.put(key, (Object)value);
        }
        return this;
    }

    public Asset includeFallback() {
        this.urlQueries.put("include_fallback", true);
        return this;
    }
}

