/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.AssetModel;
import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.FetchAssetsCallback;
import com.contentstack.sdk.INotifyClass;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import com.contentstack.sdk.utility.CSAppConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class AssetLibrary
implements INotifyClass {
    private static final String TAG = "AssetLibrary";
    private Stack stackInstance;
    private LinkedHashMap<String, Object> stackHeader;
    private LinkedHashMap<String, Object> localHeader = new LinkedHashMap();
    public JSONObject urlQueries = new JSONObject();
    private FetchAssetsCallback assetsCallback;
    private int count;

    protected AssetLibrary() {
    }

    protected void setStackInstance(Stack stack) {
        this.stackInstance = stack;
        this.stackHeader = stack.localHeader;
    }

    public void setHeader(String key, String value) {
        if (!key.isEmpty() && !value.isEmpty()) {
            this.localHeader.put(key, value);
        }
    }

    public void removeHeader(String key) {
        if (!key.isEmpty()) {
            this.localHeader.remove(key);
        }
    }

    public AssetLibrary sort(String key, ORDERBY orderby) {
        try {
            switch (orderby) {
                case ASCENDING: {
                    this.urlQueries.put("asc", (Object)key);
                    break;
                }
                case DESCENDING: {
                    this.urlQueries.put("desc", (Object)key);
                }
            }
        }
        catch (Exception e) {
            this.throwException("sort", "Please provide valid params.", e);
        }
        return this;
    }

    public AssetLibrary includeCount() {
        try {
            this.urlQueries.put("include_count", (Object)"true");
        }
        catch (Exception e) {
            this.throwException("includeCount", "Please provide valid params.", e);
        }
        return this;
    }

    public AssetLibrary includeRelativeUrl() {
        try {
            this.urlQueries.put("relative_urls", (Object)"true");
        }
        catch (Exception e) {
            this.throwException("relative_urls", "Please provide valid params.", e);
        }
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public void fetchAll(FetchAssetsCallback assetsCallback) {
        try {
            this.assetsCallback = assetsCallback;
            String URL2 = "/" + this.stackInstance.VERSION + "/assets";
            LinkedHashMap<String, Object> headers = this.getHeader(this.localHeader);
            if (headers.containsKey("environment")) {
                this.urlQueries.put("environment", headers.get("environment"));
            }
            this.fetchFromNetwork(URL2, this.urlQueries, headers, assetsCallback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchFromNetwork(String URL2, JSONObject urlQueries, LinkedHashMap<String, Object> headers, FetchAssetsCallback assetsCallback) {
        if (assetsCallback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(urlQueries);
            new CSBackgroundTask(this, this.stackInstance, "getAllAssets", URL2, headers, urlParams, new JSONObject(), CSAppConstants.callController.ASSETLIBRARY.toString(), false, CSAppConstants.RequestMethod.GET, (ResultCallBack)assetsCallback);
        }
    }

    private HashMap<String, Object> getUrlParams(JSONObject urlQueriesJSON) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (urlQueriesJSON != null && urlQueriesJSON.length() > 0) {
            Iterator iter = urlQueriesJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    Object value = urlQueriesJSON.opt(key);
                    hashMap.put(key, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return hashMap;
        }
        return null;
    }

    private void throwException(String tag, String messageString, Exception e) {
        Error error = new Error();
        error.setErrorMessage(messageString);
    }

    private LinkedHashMap<String, Object> getHeader(LinkedHashMap<String, Object> localHeader) {
        LinkedHashMap<String, Object> mainHeader = this.stackHeader;
        LinkedHashMap<String, Object> classHeaders = new LinkedHashMap<String, Object>();
        if (localHeader != null && localHeader.size() > 0) {
            if (mainHeader != null && mainHeader.size() > 0) {
                String key;
                for (Map.Entry<String, Object> entry : localHeader.entrySet()) {
                    key = entry.getKey();
                    classHeaders.put(key, entry.getValue());
                }
                for (Map.Entry<String, Object> entry : mainHeader.entrySet()) {
                    key = entry.getKey();
                    if (classHeaders.containsKey(key)) continue;
                    classHeaders.put(key, entry.getValue());
                }
                return classHeaders;
            }
            return localHeader;
        }
        return this.stackHeader;
    }

    @Override
    public void getResult(Object object, String controller) {
    }

    @Override
    public void getResultObject(List<Object> objects, JSONObject jsonObject, boolean isSingleEntry) {
        if (jsonObject != null && jsonObject.has("count")) {
            this.count = jsonObject.optInt("count");
        }
        ArrayList<Asset> assets = new ArrayList<Asset>();
        if (objects != null && objects.size() > 0) {
            for (Object object : objects) {
                AssetModel model = (AssetModel)object;
                Asset asset = this.stackInstance.asset();
                asset.contentType = model.contentType;
                asset.fileSize = model.fileSize;
                asset.uploadUrl = model.uploadUrl;
                asset.fileName = model.fileName;
                asset.json = model.json;
                asset.assetUid = model.uploadedUid;
                asset.setTags(model.tags);
                model = null;
                assets.add(asset);
            }
        }
        if (this.assetsCallback != null) {
            this.assetsCallback.onRequestFinish(ResponseType.NETWORK, assets);
        }
    }

    public AssetLibrary includeFallback() {
        this.urlQueries.put("include_fallback", true);
        return this;
    }

    public static enum ORDERBY {
        ASCENDING,
        DESCENDING;

    }
}

