/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.AssetLibrary;
import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Config;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.ContentTypesCallback;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.Language;
import com.contentstack.sdk.LanguageCode;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.SyncResultCallBack;
import com.contentstack.sdk.utility.CSAppConstants;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class Stack {
    private static final String TAG = "Stack";
    private String stackApiKey = null;
    protected LinkedHashMap<String, Object> localHeader = null;
    private String imageTransformationUrl;
    private LinkedHashMap<String, Object> imageParams = new LinkedHashMap();
    protected String URLSCHEMA = "https://";
    protected String URL = "cdn.contentstack.io";
    protected String VERSION = "v3";
    protected Config config;
    protected String SYNC_KEY = "sync";
    protected String content_type;
    private JSONObject syncParams = null;
    protected String sync_token = null;
    protected String pagination_token = null;
    protected String contentType;
    protected String localeCode;
    protected PublishType publishType;
    protected String start_from_date;
    private SyncResultCallBack syncCallBack;
    protected HashMap<String, Object> headerGroup_app;

    private Stack() {
    }

    protected Stack(String stackApiKey) {
        this.stackApiKey = stackApiKey;
        this.localHeader = new LinkedHashMap();
    }

    protected void setConfig(Config config) {
        String region;
        this.config = config;
        this.URLSCHEMA = config.URLSCHEMA;
        this.URL = config.URL;
        this.VERSION = config.VERSION;
        if (!config.environment.isEmpty()) {
            this.setHeader("environment", config.environment);
        }
        if (!config.region.name().isEmpty() && !(region = config.region.name().toLowerCase()).equalsIgnoreCase("us")) {
            if (this.URL.equalsIgnoreCase("cdn.contentstack.io")) {
                this.URL = "cdn.contentstack.com";
            }
            this.URL = region + "-" + this.URL;
        }
    }

    public ContentType contentType(String contentTypeName) {
        this.content_type = this.contentType;
        ContentType contentType = new ContentType(contentTypeName);
        contentType.setStackInstance(this);
        return contentType;
    }

    public Asset asset(String uid) {
        Asset asset = new Asset(uid);
        asset.setStackInstance(this);
        return asset;
    }

    protected Asset asset() {
        Asset asset = new Asset();
        asset.setStackInstance(this);
        return asset;
    }

    public AssetLibrary assetLibrary() {
        AssetLibrary library = new AssetLibrary();
        library.setStackInstance(this);
        return library;
    }

    public String getApplicationKey() {
        return this.stackApiKey;
    }

    public String getAccessToken() {
        return this.localHeader != null ? (String)this.localHeader.get("access_token") : null;
    }

    public void removeHeader(String key) {
        if (!key.isEmpty()) {
            this.localHeader.remove(key);
        }
    }

    public void setHeader(String key, String value) {
        if (!key.isEmpty() && !value.isEmpty()) {
            this.localHeader.put(key, value);
        }
    }

    public String ImageTransform(String image_url, LinkedHashMap<String, Object> parameters) {
        this.imageTransformationUrl = image_url;
        this.imageParams = parameters;
        return this.getImageUrl();
    }

    private String getImageUrl() {
        if (this.imageParams == null || this.imageParams.size() == 0) {
            return this.imageTransformationUrl;
        }
        this.imageParams.forEach((key, value) -> {
            try {
                String encodedKey = URLEncoder.encode(key.toString(), "UTF-8");
                String encodedValue = URLEncoder.encode(value.toString(), "UTF-8");
                this.imageTransformationUrl = !this.imageTransformationUrl.contains("?") ? this.imageTransformationUrl + "?" + encodedKey + "=" + encodedValue : this.imageTransformationUrl + "&" + encodedKey + "=" + encodedValue;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        });
        return this.imageTransformationUrl;
    }

    public void getContentTypes(JSONObject params, ContentTypesCallback callback) {
        try {
            String URL = "/" + this.VERSION + "/content_types";
            HashMap<String, Object> headers = this.getHeader(this.localHeader);
            if (params == null) {
                params = new JSONObject();
            }
            Iterator keys = params.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = params.opt(key);
                params.put(key, value);
            }
            if (headers.containsKey("environment")) {
                params.put("environment", headers.get("environment"));
                params.put("include_count", true);
            }
            this.fetchContentTypes(URL, params, headers, callback);
        }
        catch (Exception e) {
            Error error = new Error();
            error.setErrorMessage("Please provide valid JSON.");
            callback.onRequestFail(ResponseType.UNKNOWN, error);
        }
    }

    public void sync(SyncResultCallBack syncCallBack) {
        if (this.syncParams == null) {
            this.syncParams = new JSONObject();
        }
        try {
            this.syncParams.put("init", true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.requestSync(syncCallBack);
    }

    public void syncPaginationToken(String pagination_token, SyncResultCallBack syncCallBack) {
        this.pagination_token = pagination_token;
        if (this.syncParams == null) {
            this.syncParams = new JSONObject();
        }
        try {
            this.syncParams.put("init", true);
            this.syncParams.put("pagination_token", (Object)pagination_token);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.requestSync(syncCallBack);
    }

    public void syncToken(String sync_token, SyncResultCallBack syncCallBack) {
        this.sync_token = sync_token;
        if (this.syncParams == null) {
            this.syncParams = new JSONObject();
        }
        try {
            this.syncParams.put("init", true);
            this.syncParams.put("sync_token", (Object)sync_token);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.requestSync(syncCallBack);
    }

    public void syncFromDate(Date from_date, SyncResultCallBack syncCallBack) {
        this.start_from_date = this.convertUTCToISO(from_date);
        if (this.syncParams == null) {
            this.syncParams = new JSONObject();
        }
        try {
            this.syncParams.put("init", true);
            this.syncParams.put("start_from", (Object)this.start_from_date);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.requestSync(syncCallBack);
    }

    private String convertUTCToISO(Date date) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        dateFormat.setTimeZone(tz);
        return dateFormat.format(date);
    }

    public void syncContentType(String content_type, SyncResultCallBack syncCallBack) {
        this.contentType = content_type;
        if (this.syncParams == null) {
            this.syncParams = new JSONObject();
        }
        try {
            this.syncParams.put("init", true);
            this.syncParams.put("content_type_uid", (Object)this.contentType);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.requestSync(syncCallBack);
    }

    public void syncLocale(Language language, SyncResultCallBack syncCallBack) {
        this.localeCode = this.getLanguageCode(language);
        if (this.syncParams == null) {
            this.syncParams = new JSONObject();
        }
        try {
            this.syncParams.put("init", true);
            this.syncParams.put("locale", (Object)this.localeCode);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.requestSync(syncCallBack);
    }

    private String getLanguageCode(Language language) {
        String localeCode = null;
        if (language != null) {
            Language languageName = Language.valueOf(language.name());
            int localeValue = languageName.ordinal();
            LanguageCode[] languageCodeValues = LanguageCode.values();
            localeCode = languageCodeValues[localeValue].name();
            localeCode = localeCode.replace("_", "-");
        }
        return localeCode;
    }

    public void syncPublishType(PublishType type, SyncResultCallBack syncCallBack) {
        this.publishType = type;
        if (this.syncParams == null) {
            this.syncParams = new JSONObject();
        }
        try {
            this.syncParams.put("init", true);
            this.syncParams.put("type", (Object)this.publishType);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.requestSync(syncCallBack);
    }

    public void sync(String contentType, Date from_date, Language language, PublishType type, SyncResultCallBack syncCallBack) {
        this.start_from_date = this.convertUTCToISO(from_date);
        this.contentType = contentType;
        this.publishType = type;
        this.localeCode = this.getLanguageCode(language);
        if (this.syncParams == null) {
            this.syncParams = new JSONObject();
        }
        try {
            this.syncParams.put("init", true);
            this.syncParams.put("start_from", (Object)this.start_from_date);
            this.syncParams.put("content_type_uid", (Object)this.contentType);
            this.syncParams.put("type", (Object)this.publishType);
            this.syncParams.put("locale", (Object)this.localeCode);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.requestSync(syncCallBack);
    }

    private void requestSync(SyncResultCallBack callback) {
        try {
            String URL = "/" + this.VERSION + "/stacks/" + this.SYNC_KEY;
            HashMap<String, Object> headers = this.getHeader(this.localHeader);
            JSONObject urlQueries = new JSONObject();
            if (headers.containsKey("environment")) {
                this.syncParams.put("environment", headers.get("environment"));
            }
            urlQueries = this.syncParams;
            this.fetchFromNetwork(URL, this.syncParams, headers, callback);
        }
        catch (Exception e) {
            Error error = new Error();
            error.setErrorMessage("Please provide valid JSON.");
            callback.onRequestFail(ResponseType.UNKNOWN, error);
        }
    }

    private void fetchContentTypes(String urlString, JSONObject content_type_param, HashMap<String, Object> headers, ContentTypesCallback callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(content_type_param);
            new CSBackgroundTask(this, "getContentTypes", urlString, headers, urlParams, new JSONObject(), CSAppConstants.callController.CONTENTTYPES.toString(), false, CSAppConstants.RequestMethod.GET, (ResultCallBack)callback);
        }
    }

    private void fetchFromNetwork(String urlString, JSONObject urlQueries, HashMap<String, Object> headers, SyncResultCallBack callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(urlQueries);
            new CSBackgroundTask(this, "getSync", urlString, headers, urlParams, new JSONObject(), CSAppConstants.callController.SYNC.toString(), false, CSAppConstants.RequestMethod.GET, (ResultCallBack)callback);
        }
    }

    private HashMap<String, Object> getUrlParams(JSONObject urlQueriesJSON) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (urlQueriesJSON != null && urlQueriesJSON.length() > 0) {
            Iterator iter = urlQueriesJSON.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    Object value = urlQueriesJSON.opt(key);
                    hashMap.put(key, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return hashMap;
        }
        return null;
    }

    private HashMap<String, Object> getHeader(HashMap<String, Object> localHeader) {
        HashMap<String, Object> mainHeader = this.headerGroup_app;
        HashMap<String, Object> classHeaders = new HashMap<String, Object>();
        if (localHeader != null && localHeader.size() > 0) {
            if (mainHeader != null && mainHeader.size() > 0) {
                String key;
                for (Map.Entry<String, Object> entry : localHeader.entrySet()) {
                    key = entry.getKey();
                    classHeaders.put(key, entry.getValue());
                }
                for (Map.Entry<String, Object> entry : mainHeader.entrySet()) {
                    key = entry.getKey();
                    if (classHeaders.containsKey(key)) continue;
                    classHeaders.put(key, entry.getValue());
                }
                return classHeaders;
            }
            return localHeader;
        }
        return this.headerGroup_app;
    }

    public static enum PublishType {
        entry_published,
        entry_unpublished,
        entry_deleted,
        asset_published,
        asset_unpublished,
        asset_deleted,
        content_type_deleted;

    }
}

