/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.IRequestModelHTTP;
import com.contentstack.sdk.IURLRequestHTTP;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.utility.CSAppConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CSHttpConnection
implements IURLRequestHTTP {
    private final String urlPath;
    private String controller;
    private LinkedHashMap<String, Object> headers;
    private String info;
    private JSONObject requestJSON;
    private final IRequestModelHTTP connectionRequest;
    private ResultCallBack callBackObject;
    private CSAppConstants.RequestMethod requestMethod;
    private JSONObject responseJSON;
    private HashMap<String, Object> formParams;
    private boolean treatDuplicateKeysAsArrayItems;

    public HashMap<String, Object> getFormParams() {
        return this.formParams;
    }

    public void setFormParams(HashMap<String, Object> formParams) {
        this.formParams = formParams;
    }

    public CSHttpConnection(String urlToCall, IRequestModelHTTP csConnectionRequest) {
        this.urlPath = urlToCall;
        this.connectionRequest = csConnectionRequest;
    }

    @Override
    public void setController(String controller) {
        this.controller = controller;
    }

    @Override
    public String getController() {
        return this.controller;
    }

    @Override
    public void setHeaders(LinkedHashMap<String, Object> headers) {
        this.headers = headers;
    }

    public LinkedHashMap getHeaders() {
        return this.headers;
    }

    @Override
    public void setInfo(String info) {
        this.info = info;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    public void setFormParamsPOST(JSONObject requestJSON) {
        this.requestJSON = null;
        this.requestJSON = requestJSON;
    }

    @Override
    public void setCallBackObject(ResultCallBack callBackObject) {
        this.callBackObject = callBackObject;
    }

    @Override
    public ResultCallBack getCallBackObject() {
        return this.callBackObject;
    }

    @Override
    public void setTreatDuplicateKeysAsArrayItems(boolean treatDuplicateKeysAsArrayItems) {
        this.treatDuplicateKeysAsArrayItems = treatDuplicateKeysAsArrayItems;
    }

    @Override
    public boolean getTreatDuplicateKeysAsArrayItems() {
        return this.treatDuplicateKeysAsArrayItems;
    }

    @Override
    public void setRequestMethod(CSAppConstants.RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    @Override
    public CSAppConstants.RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public JSONObject getResponse() {
        return this.responseJSON;
    }

    public String setFormParamsGET(HashMap<String, Object> params) {
        if (params != null && params.size() > 0) {
            String urlParams = null;
            String string = urlParams = this.info.equalsIgnoreCase(CSAppConstants.callController.QUERY.name()) || this.info.equalsIgnoreCase(CSAppConstants.callController.ENTRY.name()) ? this.getParams(params) : null;
            if (urlParams == null) {
                for (Map.Entry<String, Object> e : params.entrySet()) {
                    urlParams = urlParams == null ? "?" + e.getKey() + "=" + e.getValue() : String.valueOf(urlParams) + "&" + e.getKey() + "=" + e.getValue();
                }
            }
            return urlParams;
        }
        return null;
    }

    private String getParams(HashMap<String, Object> params) {
        String urlParams = "?";
        for (Map.Entry<String, Object> e : params.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            try {
                int i;
                JSONArray array;
                String innerKey;
                JSONObject onlyJSON;
                JSONArray array2;
                if (key.equalsIgnoreCase("include[]")) {
                    key = URLEncoder.encode(key, "UTF-8");
                    array2 = (JSONArray)value;
                    int i2 = 0;
                    while (i2 < array2.length()) {
                        urlParams = String.valueOf(urlParams) + (urlParams.equals("?") ? String.valueOf(key) + "=" + array2.opt(i2) : "&" + key + "=" + array2.opt(i2));
                        ++i2;
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("only[BASE][]")) {
                    key = URLEncoder.encode(key, "UTF-8");
                    array2 = (JSONArray)value;
                    int i3 = 0;
                    while (i3 < array2.length()) {
                        urlParams = String.valueOf(urlParams) + (urlParams.equals("?") ? String.valueOf(key) + "=" + array2.opt(i3) : "&" + key + "=" + array2.opt(i3));
                        ++i3;
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("except[BASE][]")) {
                    key = URLEncoder.encode(key, "UTF-8");
                    array2 = (JSONArray)value;
                    int i4 = 0;
                    while (i4 < array2.length()) {
                        urlParams = String.valueOf(urlParams) + (urlParams.equals("?") ? String.valueOf(key) + "=" + array2.opt(i4) : "&" + key + "=" + array2.opt(i4));
                        ++i4;
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("only")) {
                    onlyJSON = (JSONObject)value;
                    Iterator iter = onlyJSON.keys();
                    while (iter.hasNext()) {
                        innerKey = (String)iter.next();
                        array = onlyJSON.optJSONArray(innerKey);
                        innerKey = URLEncoder.encode("only[" + innerKey + "][]", "UTF-8");
                        i = 0;
                        while (i < array.length()) {
                            urlParams = String.valueOf(urlParams) + (urlParams.equals("?") ? String.valueOf(innerKey) + "=" + array.opt(i) : "&" + innerKey + "=" + array.opt(i));
                            ++i;
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("except")) {
                    onlyJSON = (JSONObject)value;
                    Iterator iter = onlyJSON.keys();
                    while (iter.hasNext()) {
                        innerKey = (String)iter.next();
                        array = onlyJSON.optJSONArray(innerKey);
                        innerKey = URLEncoder.encode("except[" + innerKey + "][]", "UTF-8");
                        i = 0;
                        while (i < array.length()) {
                            urlParams = String.valueOf(urlParams) + (urlParams.equals("?") ? String.valueOf(innerKey) + "=" + array.opt(i) : "&" + innerKey + "=" + array.opt(i));
                            ++i;
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("query")) {
                    JSONObject queryJSON = (JSONObject)value;
                    urlParams = String.valueOf(urlParams) + (urlParams.equals("?") ? String.valueOf(key) + "=" + URLEncoder.encode(queryJSON.toString(), "UTF-8") : "&" + key + "=" + URLEncoder.encode(queryJSON.toString(), "UTF-8"));
                    continue;
                }
                urlParams = String.valueOf(urlParams) + (urlParams.equals("?") ? String.valueOf(key) + "=" + value : "&" + key + "=" + value);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return urlParams;
    }

    @Override
    public void send() {
        String params;
        String url = null;
        url = this.requestMethod == CSAppConstants.RequestMethod.GET ? ((params = this.setFormParamsGET(this.formParams)) != null ? String.valueOf(this.urlPath) + params : this.urlPath) : this.urlPath;
        try {
            this.sendGET(url);
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
    }

    private void sendGET(String GET_URL) throws IOException, JSONException {
        URL obj = new URL(GET_URL);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        if (this.headers.containsKey("api_key")) {
            con.setRequestProperty("api_key", this.headers.get("api_key").toString());
        }
        if (this.headers.containsKey("access_token")) {
            con.setRequestProperty("access_token", this.headers.get("access_token").toString());
        }
        if (this.headers.containsKey("environment")) {
            con.setRequestProperty("environment", this.headers.get("environment").toString());
        }
        con.setRequestProperty("X-User-Agent", String.valueOf(this.defaultUserAgent()) + "/" + "1.5.5");
        con.setRequestProperty("Content-Type", "application/json");
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                StringBuilder stringBuilder = response.append(inputLine);
            }
            in.close();
            this.responseJSON = new JSONObject(response.toString());
            this.connectionRequest.onRequestFinished(this);
        } else {
            this.settingErrorInfo(con);
        }
    }

    private void settingErrorInfo(HttpURLConnection con) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getErrorStream(), StandardCharsets.UTF_8));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        this.responseJSON = new JSONObject(response.toString());
        String errorMsg = this.responseJSON.optString("error_message");
        String errorCode = this.responseJSON.optString("error_code");
        String errorDetails = this.responseJSON.optString("errors");
        this.responseJSON.put("error_message", (Object)errorMsg);
        this.responseJSON.put("error_code", (Object)errorCode);
        this.responseJSON.put("errors", (Object)errorDetails);
        int errorCodeInt = Integer.parseInt(errorCode);
        this.connectionRequest.onRequestFailed(this.responseJSON, errorCodeInt, this.callBackObject);
    }

    private String defaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? agent : "Java" + System.getProperty("java.version");
    }
}

