/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Config;
import com.contentstack.sdk.Stack;

public class Contentstack {
    private Contentstack() {
    }

    public static Stack stack(String stackApiKey, String accessToken, String environment) throws Exception {
        if (!stackApiKey.isEmpty()) {
            if (!accessToken.isEmpty()) {
                if (!environment.isEmpty()) {
                    Config config = new Config();
                    config.setEnvironment(environment);
                    return Contentstack.initializeStack(stackApiKey, accessToken, config);
                }
                throw new Exception("Environment can not be null.");
            }
            throw new Exception("Access token can not be null.");
        }
        throw new Exception("Stack api key can not be null.");
    }

    public static Stack stack(String stackApiKey, String accessToken, String environment, Config config) throws Exception {
        if (!stackApiKey.isEmpty()) {
            if (!accessToken.isEmpty()) {
                if (!environment.isEmpty()) {
                    if (config != null) {
                        config.setEnvironment(environment);
                    } else {
                        config = new Config();
                        config.setEnvironment(environment);
                    }
                    return Contentstack.initializeStack(stackApiKey, accessToken, config);
                }
                throw new Exception("Environment can not be null.");
            }
            throw new Exception("Access token can not be null.");
        }
        throw new Exception("Stack api key can not be null.");
    }

    private static Stack initializeStack(String stackApiKey, String accessToken, Config config) {
        Stack stack = new Stack(stackApiKey.trim());
        stack.setHeader("api_key", stackApiKey);
        stack.setHeader("access_token", accessToken);
        stack.setConfig(config);
        return stack;
    }
}

