/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk.utility;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONObject;

public class CSAppUtils {
    public static JSONObject getJsonFromCacheFile(File file) {
        JSONObject json = null;
        BufferedInputStream input = null;
        ByteArrayOutputStream buffer = null;
        try {
            int read;
            input = new BufferedInputStream(new FileInputStream(file));
            buffer = new ByteArrayOutputStream();
            byte[] temp = new byte[1024];
            while ((read = ((InputStream)input).read(temp)) > 0) {
                buffer.write(temp, 0, read);
            }
            json = new JSONObject(buffer.toString("UTF-8"));
            buffer.flush();
            buffer.close();
            ((InputStream)input).close();
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Calendar parseDate(String date, String dateFormat, TimeZone timeZone) throws ParseException {
        Date dateObject = null;
        String month = "";
        String day = "";
        String year = "";
        String hourOfDay = "";
        String min = "";
        String sec = "";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat);
        dateObject = dateFormatter.parse(date);
        month = new SimpleDateFormat("MM").format(dateObject);
        day = new SimpleDateFormat("dd").format(dateObject);
        year = new SimpleDateFormat("yyyy").format(dateObject);
        hourOfDay = new SimpleDateFormat("HH").format(dateObject);
        min = new SimpleDateFormat("mm").format(dateObject);
        sec = new SimpleDateFormat("ss").format(dateObject);
        if (timeZone != null) {
            cal.setTimeZone(timeZone);
        } else {
            cal.setTimeZone(TimeZone.getDefault());
        }
        cal.set(Integer.valueOf(year), Integer.valueOf(month) - 1, Integer.valueOf(day), Integer.valueOf(hourOfDay), Integer.valueOf(min), Integer.valueOf(sec));
        month = null;
        day = null;
        year = null;
        hourOfDay = null;
        min = null;
        sec = null;
        dateObject = null;
        return cal;
    }

    public boolean getResponseTimeFromCacheFile(File file, long time) {
        try {
            JSONObject jsonObj = CSAppUtils.getJsonFromCacheFile(file);
            long responseDate = Long.parseLong(jsonObj.optString("timestamp"));
            Calendar responseCalendar = Calendar.getInstance();
            responseCalendar.add(12, 0);
            responseCalendar.set(13, 0);
            responseCalendar.set(14, 0);
            responseCalendar.setTimeInMillis(responseDate);
            responseCalendar.getTimeInMillis();
            Calendar currentCalendar = Calendar.getInstance();
            currentCalendar.setTime(new Date());
            currentCalendar.getTimeInMillis();
            long dateDiff = currentCalendar.getTimeInMillis() - responseCalendar.getTimeInMillis();
            long dateDiffInMin = dateDiff / 60000L;
            return dateDiffInMin > time / 60000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getMD5FromString(String value) {
        String output = value.toString().trim();
        if (value.length() > 0) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                digest.reset();
                digest.update(output.getBytes());
                byte[] messageDigest = digest.digest();
                StringBuffer hexString = new StringBuffer();
                for (int i = 0; i < messageDigest.length; ++i) {
                    String hex = Integer.toHexString(0xFF & messageDigest[i]);
                    if (hex.length() == 1) {
                        hexString.append('0');
                    }
                    hexString.append(hex);
                }
                return hexString.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static enum DateComapareType {
        WEEK,
        DAY,
        HOURS,
        MINUTES,
        SECONDS;

    }
}

