/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.APIService;
import com.contentstack.sdk.Config;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.TaxonomyCallback;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Response;

public class Taxonomy {
    protected LinkedHashMap<String, Object> headers;
    protected APIService service;
    protected JSONObject query = new JSONObject();
    protected Config config;

    protected Taxonomy(APIService service, Config config, LinkedHashMap<String, Object> headers) {
        this.service = service;
        this.headers = headers;
        this.config = config;
    }

    public Taxonomy in(String taxonomy, List<String> listOfItems) {
        JSONObject innerObj = new JSONObject();
        innerObj.put("$in", listOfItems);
        this.query.put(taxonomy, (Object)innerObj);
        return this;
    }

    public Taxonomy or(@NotNull List<JSONObject> listOfItems) {
        this.query.put("$or", listOfItems);
        return this;
    }

    public Taxonomy and(@NotNull List<JSONObject> listOfItems) {
        this.query.put("$and", (Object)listOfItems.toString());
        return this;
    }

    public Taxonomy exists(@NotNull String taxonomy, @NotNull Boolean value) {
        JSONObject json = new JSONObject();
        json.put("$exists", (Object)value);
        this.query.put(taxonomy, (Object)json);
        return this;
    }

    public Taxonomy equalAndBelow(@NotNull String taxonomy, @NotNull String termsUid) {
        JSONObject param = new JSONObject();
        param.put("$eq_below", (Object)termsUid);
        this.query.put(taxonomy, (Object)param);
        return this;
    }

    public Taxonomy equalAndBelowWithLevel(@NotNull String taxonomy, @NotNull String termsUid, @NotNull int level) {
        JSONObject innerMap = new JSONObject();
        innerMap.put("$eq_below", (Object)(termsUid + ", level: " + level));
        this.query.put(taxonomy, (Object)innerMap);
        return this;
    }

    public Taxonomy below(@NotNull String taxonomy, @NotNull String termsUid) {
        JSONObject param = new JSONObject();
        param.put("$below", (Object)termsUid);
        this.query.put(taxonomy, (Object)param);
        return this;
    }

    public Taxonomy equalAbove(@NotNull String taxonomy, @NotNull String termUid) {
        JSONObject innerMap = new JSONObject();
        innerMap.put("$eq_above", (Object)termUid);
        this.query.put(taxonomy, (Object)innerMap);
        return this;
    }

    public Taxonomy above(@NotNull String taxonomy, @NotNull String termUid) {
        JSONObject innerMap = new JSONObject();
        innerMap.put("$above", (Object)termUid);
        this.query.put(taxonomy, (Object)innerMap);
        return this;
    }

    protected Call<ResponseBody> makeRequest() {
        return this.service.getTaxonomy(this.headers, this.query.toString());
    }

    public void find(TaxonomyCallback callback) {
        try {
            Response response = this.makeRequest().execute();
            if (response.isSuccessful()) {
                JSONObject responseJSON = new JSONObject(((ResponseBody)response.body()).string());
                callback.onResponse(responseJSON, null);
            } else {
                JSONObject responseJSON = new JSONObject(response.errorBody().string());
                Error error = new Error();
                error.setErrorMessage(responseJSON.optString("error_message"));
                error.setErrorCode(responseJSON.optInt("error_code"));
                error.setErrorDetail(responseJSON.optString("errors"));
                callback.onResponse(null, error);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

