/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.APIService;
import com.contentstack.sdk.Asset;
import com.contentstack.sdk.AssetLibrary;
import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Config;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.ContentTypesCallback;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.SyncResultCallBack;
import com.contentstack.sdk.Taxonomy;
import java.io.IOException;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Response;
import retrofit2.Retrofit;

public class Stack {
    private final Logger logger = Logger.getLogger(Stack.class.getSimpleName());
    protected LinkedHashMap<String, Object> headers;
    protected Config config;
    protected String contentType;
    protected String livePreviewEndpoint;
    protected APIService service;
    protected String apiKey;
    protected JSONObject syncParams = null;

    protected Stack() throws IllegalAccessException {
        throw new IllegalAccessException("Can Not Access Private Modifier");
    }

    protected Stack(@NotNull String apiKey) {
        this.apiKey = apiKey;
        this.headers = new LinkedHashMap();
    }

    protected void setConfig(Config config) {
        this.config = config;
        String urlDomain = config.host;
        if (!config.region.name().isEmpty()) {
            String region = config.region.name().toLowerCase();
            if (region.equalsIgnoreCase("eu")) {
                if (urlDomain.equalsIgnoreCase("cdn.contentstack.io")) {
                    urlDomain = "cdn.contentstack.com";
                }
                config.host = region + "-" + urlDomain;
            } else if (region.equalsIgnoreCase("azure_na")) {
                if (urlDomain.equalsIgnoreCase("cdn.contentstack.io")) {
                    urlDomain = "cdn.contentstack.com";
                }
                config.host = "azure-na-" + urlDomain;
            } else if (region.equalsIgnoreCase("azure_eu")) {
                if (urlDomain.equalsIgnoreCase("cdn.contentstack.io")) {
                    urlDomain = "cdn.contentstack.com";
                }
                config.host = "azure-eu-" + urlDomain;
            } else if (region.equalsIgnoreCase("gcp_na")) {
                if (urlDomain.equalsIgnoreCase("cdn.contentstack.io")) {
                    urlDomain = "cdn.contentstack.com";
                }
                config.host = "gcp-na-" + urlDomain;
            }
        }
        this.includeLivePreview();
        String endpoint = config.scheme + config.host;
        this.config.setEndpoint(endpoint);
        this.client(endpoint);
        this.logger.fine("Info: configs set");
    }

    private void client(String endpoint) {
        Proxy proxy = this.config.getProxy();
        ConnectionPool pool = this.config.connectionPool;
        OkHttpClient client = new OkHttpClient.Builder().proxy(proxy).connectionPool(pool).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(endpoint).client(client).build();
        this.service = (APIService)retrofit.create(APIService.class);
    }

    private void includeLivePreview() {
        if (this.config.enableLivePreview) {
            String urlLivePreview = this.config.livePreviewHost;
            if (this.config.region != null && !this.config.region.name().isEmpty()) {
                if (this.config.region.name().equals("US")) {
                    this.config.livePreviewHost = urlLivePreview;
                } else {
                    String regionPrefix = this.config.region.name().toLowerCase();
                    this.config.livePreviewHost = regionPrefix + "-" + urlLivePreview;
                }
            }
            this.livePreviewEndpoint = "https://".concat(this.config.livePreviewHost).concat("/v3/content_types/");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Stack livePreviewQuery(Map<String, String> query) throws IOException {
        if (!this.config.enableLivePreview) throw new IllegalStateException("Live Preview is not enabled in Config");
        this.config.livePreviewHash = query.get("live_preview");
        this.config.livePreviewEntryUid = query.get("entry_uid");
        this.config.livePreviewContentType = query.get("content_type_uid");
        this.config.releaseId = query.get("release_id") != null ? query.get("release_id") : null;
        this.config.previewTimestamp = query.get("preview_timestamp") != null ? query.get("preview_timestamp") : null;
        String livePreviewUrl = this.livePreviewEndpoint.concat(this.config.livePreviewContentType).concat("/entries/" + this.config.livePreviewEntryUid);
        if (livePreviewUrl.contains("/null/")) {
            throw new IllegalStateException("Malformed Query Url");
        }
        Response response = null;
        try {
            LinkedHashMap<String, Object> liveHeader = new LinkedHashMap<String, Object>();
            liveHeader.put("api_key", this.headers.get("api_key"));
            if (this.config.livePreviewHost.equals("rest-preview.contentstack.com")) {
                if (this.config.previewToken == null) throw new IllegalAccessError("Provide the Preview Token for the host rest-preview.contentstack.com");
                liveHeader.put("preview_token", this.config.previewToken);
            } else {
                liveHeader.put("authorization", this.config.managementToken);
            }
            response = this.service.getRequest(livePreviewUrl, liveHeader).execute();
        }
        catch (IOException e) {
            throw new IllegalStateException("IO Exception while executing the Live Preview url");
        }
        if (!response.isSuccessful()) return this;
        assert (response.body() != null);
        String resp = ((ResponseBody)response.body()).string();
        if (resp.isEmpty()) return this;
        JSONObject liveResponse = new JSONObject(resp);
        this.config.setLivePreviewEntry(liveResponse.getJSONObject("entry"));
        return this;
    }

    public ContentType contentType(String contentTypeUid) {
        this.contentType = contentTypeUid;
        ContentType ct = new ContentType(contentTypeUid);
        ct.setStackInstance(this);
        return ct;
    }

    public Asset asset(@NotNull String uid) {
        Asset asset = new Asset(uid);
        asset.setStackInstance(this);
        return asset;
    }

    protected Asset asset() {
        Asset asset = new Asset();
        asset.setStackInstance(this);
        return asset;
    }

    public AssetLibrary assetLibrary() {
        AssetLibrary library = new AssetLibrary();
        library.setStackInstance(this);
        return library;
    }

    public String getApplicationKey() {
        return this.apiKey;
    }

    public String getDeliveryToken() {
        return (String)this.headers.get("access_token");
    }

    public void removeHeader(String headerKey) {
        this.headers.remove(headerKey);
    }

    public void setHeader(@NotNull String headerKey, @NotNull String headerValue) {
        if (!headerKey.isEmpty() && !headerValue.isEmpty()) {
            this.headers.put(headerKey, headerValue);
        }
    }

    public String imageTransform(@NotNull String imageUrl, @NotNull Map<String, Object> parameters) {
        if (parameters.isEmpty()) {
            return imageUrl;
        }
        String query = this.getQueryParam(parameters);
        imageUrl = imageUrl.contains("?") ? imageUrl + "&" + query : imageUrl + "?" + query;
        return imageUrl;
    }

    protected String getQueryParam(Map<String, Object> params) {
        return params.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining("&"));
    }

    public void getContentTypes(@NotNull JSONObject params, ContentTypesCallback callback) {
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = params.opt(key);
            params.put(key, value);
        }
        if (this.headers.containsKey("environment")) {
            params.put("environment", this.headers.get("environment"));
            params.put("include_count", true);
        }
        this.fetchContentTypes("content_types", params, this.headers, callback);
    }

    public void sync(SyncResultCallBack syncCallBack) {
        this.syncParams = new JSONObject();
        this.syncParams.put("init", true);
        this.requestSync(syncCallBack);
    }

    public void syncPaginationToken(@NotNull String paginationToken, SyncResultCallBack syncCallBack) {
        this.syncParams = new JSONObject();
        this.syncParams.put("pagination_token", (Object)paginationToken);
        this.requestSync(syncCallBack);
    }

    public void syncToken(String syncToken, SyncResultCallBack syncCallBack) {
        this.syncParams = new JSONObject();
        this.syncParams.put("sync_token", (Object)syncToken);
        this.requestSync(syncCallBack);
    }

    public void syncFromDate(@NotNull Date fromDate, SyncResultCallBack syncCallBack) {
        String newFromDate = this.convertUTCToISO(fromDate);
        this.syncParams = new JSONObject();
        this.syncParams.put("init", true);
        this.syncParams.put("start_from", (Object)newFromDate);
        this.requestSync(syncCallBack);
    }

    protected String convertUTCToISO(Date date) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        dateFormat.setTimeZone(tz);
        return dateFormat.format(date);
    }

    public void syncContentType(@NotNull String contentType, SyncResultCallBack syncCallBack) {
        this.syncParams = new JSONObject();
        this.syncParams.put("init", true);
        this.syncParams.put("content_type_uid", (Object)contentType);
        this.requestSync(syncCallBack);
    }

    public void syncLocale(String localeCode, SyncResultCallBack syncCallBack) {
        this.syncParams = new JSONObject();
        this.syncParams.put("init", true);
        this.syncParams.put("locale", (Object)localeCode);
        this.requestSync(syncCallBack);
    }

    public void syncPublishType(PublishType publishType, SyncResultCallBack syncCallBack) {
        this.syncParams = new JSONObject();
        this.syncParams.put("init", true);
        this.syncParams.put("type", (Object)publishType.name().toLowerCase());
        this.requestSync(syncCallBack);
    }

    public void sync(String contentType, Date fromDate, String localeCode, PublishType publishType, SyncResultCallBack syncCallBack) {
        String newDate = this.convertUTCToISO(fromDate);
        this.syncParams = new JSONObject();
        this.syncParams.put("init", true);
        this.syncParams.put("start_from", (Object)newDate);
        this.syncParams.put("content_type_uid", (Object)contentType);
        this.syncParams.put("type", (Object)publishType.name());
        this.syncParams.put("locale", (Object)localeCode);
        this.requestSync(syncCallBack);
    }

    private void requestSync(SyncResultCallBack callback) {
        if (this.headers.containsKey("environment")) {
            this.syncParams.put("environment", this.headers.get("environment"));
        }
        this.fetchFromNetwork("stacks/sync", this.syncParams, this.headers, callback);
    }

    private void fetchContentTypes(String urlString, JSONObject contentTypeParam, HashMap<String, Object> headers, ContentTypesCallback callback) {
        if (callback != null) {
            HashMap<String, Object> queryParam = this.getUrlParams(contentTypeParam);
            String requestInfo = Constants.REQUEST_CONTROLLER.CONTENTTYPES.toString();
            new CSBackgroundTask(this, "getContentTypes", urlString, headers, queryParam, requestInfo, callback);
        }
    }

    private void fetchFromNetwork(String urlString, JSONObject urlQueries, HashMap<String, Object> headers, SyncResultCallBack callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(urlQueries);
            String requestInfo = Constants.REQUEST_CONTROLLER.SYNC.toString();
            new CSBackgroundTask(this, "getSync", urlString, headers, urlParams, requestInfo, callback);
        }
    }

    private HashMap<String, Object> getUrlParams(JSONObject jsonQuery) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (jsonQuery != null && !jsonQuery.isEmpty()) {
            Iterator iteString = jsonQuery.keys();
            while (iteString.hasNext()) {
                String key = (String)iteString.next();
                Object value = jsonQuery.opt(key);
                hashMap.put(key, value);
            }
        }
        return hashMap;
    }

    public Taxonomy taxonomy() {
        return new Taxonomy(this.service, this.config, this.headers);
    }

    public void updateAssetUrl(Entry entry) {
        JSONObject entryJson = entry.toJSON();
        if (!entryJson.has("_embedded_items")) {
            throw new IllegalArgumentException("_embedded_items not present in entry. Call includeEmbeddedItems() before fetching entry.");
        }
        JSONObject embeddedItems = entryJson.getJSONObject("_embedded_items");
        Iterator keys = embeddedItems.keys();
        HashMap<String, String> assetUrls = new HashMap<String, String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object embeddedItem = embeddedItems.get(key);
            if (!(embeddedItem instanceof JSONArray)) continue;
            JSONArray itemList = (JSONArray)embeddedItem;
            for (int i = 0; i < itemList.length(); ++i) {
                JSONObject item = itemList.getJSONObject(i);
                if (!"sys_assets".equals(item.getString("_content_type_uid")) || !item.has("filename")) continue;
                String url = item.getString("url");
                String uid = item.getString("uid");
                assetUrls.put(uid, url);
            }
        }
        this.updateChildObjects(entryJson, assetUrls);
    }

    private void updateChildObjects(JSONObject entryJson, Map<String, String> assetUrls) {
        Iterator mainKeys = entryJson.keys();
        while (mainKeys.hasNext()) {
            JSONObject mainKey;
            String key = (String)mainKeys.next();
            Object childObj = entryJson.get(key);
            if (!(childObj instanceof JSONObject) || !(mainKey = (JSONObject)childObj).has("children")) continue;
            JSONArray mainList = mainKey.getJSONArray("children");
            for (int i = 0; i < mainList.length(); ++i) {
                String assetUid;
                JSONObject childList;
                JSONObject list = mainList.getJSONObject(i);
                if (!list.has("attrs") || !(childList = list.getJSONObject("attrs")).has("asset-uid") || !childList.has("asset-link") || !assetUrls.containsKey(assetUid = childList.getString("asset-uid"))) continue;
                childList.put("asset-link", (Object)assetUrls.get(assetUid));
            }
        }
    }

    public static enum PublishType {
        ASSET_DELETED,
        ASSET_PUBLISHED,
        ASSET_UNPUBLISHED,
        CONTENT_TYPE_DELETED,
        ENTRY_DELETED,
        ENTRY_PUBLISHED,
        ENTRY_UNPUBLISHED;

    }
}

