/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Config;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.ContentType;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.EntryModel;
import com.contentstack.sdk.Error;
import com.contentstack.sdk.INotifyClass;
import com.contentstack.sdk.QueryResult;
import com.contentstack.sdk.QueryResultsCallBack;
import com.contentstack.sdk.ResponseType;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.SingleQueryResultCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class Query
implements INotifyClass {
    protected static final Logger logger = Logger.getLogger(Query.class.getSimpleName());
    protected ContentType contentTypeInstance = null;
    protected LinkedHashMap<String, Object> headers = null;
    protected JSONObject urlQueries;
    protected JSONObject mainJSON;
    protected String contentTypeUid;
    protected QueryResultsCallBack queryResultCallback;
    protected SingleQueryResultCallback singleQueryResultCallback;
    protected JSONObject queryValueJSON;
    protected JSONObject queryValue;
    protected JSONArray objectUidForInclude = null;
    protected JSONArray objectUidForExcept = null;
    protected JSONArray objectUidForOnly = null;
    private boolean isJsonProper = true;
    private String errorString;
    private JSONObject onlyJsonObject;
    private JSONObject exceptJsonObject;

    protected Query(String formName) {
        this.contentTypeUid = formName;
        this.urlQueries = new JSONObject();
        this.queryValue = new JSONObject();
        this.queryValueJSON = new JSONObject();
        this.mainJSON = new JSONObject();
    }

    protected void setContentTypeInstance(ContentType contentTypeInstance) {
        this.contentTypeInstance = contentTypeInstance;
    }

    public Query setHeader(@NotNull String key, @NotNull String value) {
        if (!key.isEmpty() && !value.isEmpty()) {
            this.headers.put(key, value);
        }
        return this;
    }

    public Query removeHeader(@NotNull String key) {
        if (!key.isEmpty()) {
            this.headers.remove(key);
        }
        return this;
    }

    public String getContentType() {
        return this.contentTypeInstance.contentTypeUid;
    }

    private boolean isValidKey(String key) {
        return key.matches("^[a-zA-Z0-9_.]+$");
    }

    private boolean isValidValue(Object value) {
        if (value instanceof String) {
            return ((String)value).matches("^[a-zA-Z0-9_.\\-\\s]+$");
        }
        return true;
    }

    private boolean isValidValueList(Object[] values) {
        for (Object value : values) {
            if (!(value instanceof String) || ((String)value).matches("^[a-zA-Z0-9_.\\-\\s]+$")) continue;
            return false;
        }
        return true;
    }

    public Query where(@NotNull String key, Object value) {
        if (this.isValidKey(key) && this.isValidValue(value) && value != null) {
            this.queryValueJSON.put(key, value);
        } else {
            this.throwException("where", "Invalid key or value", null);
        }
        return this;
    }

    public Query addQuery(@NotNull String key, String value) {
        if (this.isValidKey(key) && this.isValidValue(value) && value != null) {
            this.urlQueries.put(key, (Object)value);
        }
        return this;
    }

    public Query removeQuery(@NotNull String key) {
        if (this.isValidKey(key) && this.urlQueries.has(key)) {
            this.urlQueries.remove(key);
        }
        return this;
    }

    public Query and(@NotNull List<Query> queryObjects) {
        if (!queryObjects.isEmpty()) {
            JSONArray orValueJson = new JSONArray();
            queryObjects.forEach(obj -> orValueJson.put((Object)obj.queryValueJSON));
            this.queryValueJSON.put("$and", (Object)orValueJson);
        } else {
            this.throwException("and", "Can not process with blank query objects", null);
        }
        return this;
    }

    public Query or(List<Query> queryObjects) {
        if (queryObjects != null && !queryObjects.isEmpty()) {
            try {
                JSONArray orValueJson = new JSONArray();
                for (Query queryObject : queryObjects) {
                    orValueJson.put((Object)queryObject.queryValueJSON);
                }
                this.queryValueJSON.put("$or", (Object)orValueJson);
            }
            catch (Exception e) {
                this.throwException("or", "Please provide valid params.", e);
            }
        }
        return this;
    }

    public Query lessThan(@NotNull String key, @NotNull Object value) {
        if (this.isValidKey(key) && this.isValidValue(value)) {
            if (this.queryValueJSON.isNull(key)) {
                if (!this.queryValue.isEmpty()) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$lt", value);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$lt", value);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        } else {
            this.throwException("lessThan", "Invalid key or value", null);
        }
        return this;
    }

    public Query lessThanOrEqualTo(@NotNull String key, Object value) {
        if (this.isValidKey(key) && this.isValidValue(value)) {
            if (this.queryValueJSON.isNull(key)) {
                if (!this.queryValue.isEmpty()) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$lte", value);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$lte", value);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        } else {
            this.throwException("lessThanOrEqualTo", "Invalid key or value", null);
        }
        return this;
    }

    public Query greaterThan(@NotNull String key, Object value) {
        if (this.isValidKey(key) && this.isValidValue(value)) {
            if (this.queryValueJSON.isNull(key)) {
                if (!this.queryValue.isEmpty()) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$gt", value);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$gt", value);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        } else {
            this.throwException("greaterThan", "Invalid key or value", null);
        }
        return this;
    }

    public Query greaterThanOrEqualTo(String key, Object value) {
        if (this.isValidKey(key) && this.isValidValue(value)) {
            if (this.queryValueJSON.isNull(key)) {
                if (this.queryValue.length() > 0) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$gte", value);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$gte", value);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        } else {
            this.throwException("greaterThanOrEqualTo", "Invalid key or value", null);
        }
        return this;
    }

    public Query notEqualTo(@NotNull String key, Object value) {
        if (this.isValidKey(key) && this.isValidValue(value)) {
            if (this.queryValueJSON.isNull(key)) {
                if (this.queryValue.length() > 0) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$ne", value);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$ne", value);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        } else {
            this.throwException("notEqualTo", "Invalid key or value", null);
        }
        return this;
    }

    public Query containedIn(@NotNull String key, Object[] values) {
        if (this.isValidKey(key) && this.isValidValueList(values)) {
            JSONArray valuesArray = new JSONArray();
            for (Object value : values) {
                valuesArray.put(value);
            }
            if (this.queryValueJSON.isNull(key)) {
                if (this.queryValue.length() > 0) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$in", (Object)valuesArray);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$in", (Object)valuesArray);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        } else {
            this.throwException("containedIn", "Invalid key or value", null);
        }
        return this;
    }

    public Query notContainedIn(@NotNull String key, Object[] values) {
        if (this.isValidKey(key) && this.isValidValueList(values)) {
            JSONArray valuesArray = new JSONArray();
            for (Object value : values) {
                valuesArray.put(value);
            }
            if (this.queryValueJSON.isNull(key)) {
                if (this.queryValue.length() > 0) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$nin", (Object)valuesArray);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$nin", (Object)valuesArray);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        } else {
            this.throwException("notContainedIn", "Invalid key or value", null);
        }
        return this;
    }

    public Query exists(@NotNull String key) {
        if (this.isValidKey(key)) {
            if (this.queryValueJSON.isNull(key)) {
                if (this.queryValue.length() > 0) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$exists", true);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$exists", true);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        } else {
            this.throwException("exists", "Invalid key", null);
        }
        return this;
    }

    public Query notExists(@NotNull String key) {
        if (this.isValidKey(key)) {
            if (this.queryValueJSON.isNull(key)) {
                if (this.queryValue.length() > 0) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$exists", false);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$exists", false);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        } else {
            this.throwException("notExists", "Invalid key", null);
        }
        return this;
    }

    public Query includeReference(String key) {
        if (this.objectUidForInclude == null) {
            this.objectUidForInclude = new JSONArray();
        }
        if (this.isValidKey(key)) {
            this.objectUidForInclude.put((Object)key);
        } else {
            this.throwException("includeReference", "Invalid key", null);
        }
        return this;
    }

    public Query tags(@NotNull String[] tags) {
        String tagstr = String.join((CharSequence)",", tags);
        if (this.isValidValue(tagstr)) {
            this.urlQueries.put("tags", (Object)tagstr);
        } else {
            this.throwException("tags", "Invalid tag", null);
        }
        return this;
    }

    public Query ascending(@NotNull String key) {
        if (this.isValidKey(key)) {
            this.urlQueries.put("asc", (Object)key);
        } else {
            this.throwException("ascending", "Invalid key", null);
        }
        return this;
    }

    public Query descending(@NotNull String key) {
        if (this.isValidKey(key)) {
            this.urlQueries.put("desc", (Object)key);
        } else {
            this.throwException("descending", "Invalid key", null);
        }
        return this;
    }

    public Query except(@NotNull List<String> fieldUid) {
        if (this.isValidValue(fieldUid)) {
            if (!fieldUid.isEmpty()) {
                if (this.objectUidForExcept == null) {
                    this.objectUidForExcept = new JSONArray();
                }
                for (String s : fieldUid) {
                    this.objectUidForExcept.put((Object)s);
                }
            }
        } else {
            this.throwException("except", "Invalid key", null);
        }
        return this;
    }

    public Query except(@NotNull String[] fieldIds) {
        if (this.isValidValue(fieldIds)) {
            if (fieldIds.length > 0) {
                if (this.objectUidForExcept == null) {
                    this.objectUidForExcept = new JSONArray();
                }
                for (String fieldId : fieldIds) {
                    this.objectUidForExcept.put((Object)fieldId);
                }
            }
        } else {
            this.throwException("except", "Invalid key", null);
        }
        return this;
    }

    public Query only(@NotNull String[] fieldUid) {
        if (this.isValidValue(fieldUid)) {
            if (fieldUid.length > 0) {
                if (this.objectUidForOnly == null) {
                    this.objectUidForOnly = new JSONArray();
                }
                for (String s : fieldUid) {
                    this.objectUidForOnly.put((Object)s);
                }
            }
        } else {
            this.throwException("only", "Invalid key", null);
        }
        return this;
    }

    public Query onlyWithReferenceUid(@NotNull List<String> fieldUid, @NotNull String referenceFieldUid) {
        if (this.isValidValue(referenceFieldUid)) {
            if (this.onlyJsonObject == null) {
                this.onlyJsonObject = new JSONObject();
            }
            JSONArray fieldValueArray = new JSONArray();
            for (String s : fieldUid) {
                fieldValueArray.put((Object)s);
            }
            this.onlyJsonObject.put(referenceFieldUid, (Object)fieldValueArray);
            if (this.objectUidForInclude == null) {
                this.objectUidForInclude = new JSONArray();
            }
            this.objectUidForInclude.put((Object)referenceFieldUid);
        } else {
            this.throwException("onlyWithReferenceUid", "Invalid key or value", null);
        }
        return this;
    }

    public Query exceptWithReferenceUid(@NotNull List<String> fieldUid, @NotNull String referenceFieldUid) {
        if (this.isValidValue(referenceFieldUid)) {
            if (this.exceptJsonObject == null) {
                this.exceptJsonObject = new JSONObject();
            }
            JSONArray fieldValueArray = new JSONArray();
            for (String s : fieldUid) {
                fieldValueArray.put((Object)s);
            }
            this.exceptJsonObject.put(referenceFieldUid, (Object)fieldValueArray);
            if (this.objectUidForInclude == null) {
                this.objectUidForInclude = new JSONArray();
            }
            this.objectUidForInclude.put((Object)referenceFieldUid);
        } else {
            this.throwException("exceptWithReferenceUid", "Invalid key or value", null);
        }
        return this;
    }

    public Query count() {
        this.urlQueries.put("count", (Object)"true");
        return this;
    }

    public Query includeCount() {
        this.urlQueries.put("include_count", (Object)"true");
        return this;
    }

    public Query includeContentType() {
        if (this.urlQueries.has("include_schema")) {
            this.urlQueries.remove("include_schema");
        }
        this.urlQueries.put("include_content_type", true);
        this.urlQueries.put("include_global_field_schema", true);
        return this;
    }

    public Query skip(int number) {
        this.urlQueries.put("skip", number);
        return this;
    }

    public Query limit(int number) {
        this.urlQueries.put("limit", number);
        return this;
    }

    public Query regex(@NotNull String key, @NotNull String regex) {
        if (this.isValidKey(key) && this.isValidValue(regex)) {
            if (this.queryValueJSON.isNull(key)) {
                if (!this.queryValue.isEmpty()) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$regex", (Object)regex);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$regex", (Object)regex);
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        } else {
            this.throwException("$regex", "Please provide valid params.", null);
        }
        return this;
    }

    public Query regex(@NotNull String key, @NotNull String regex, String modifiers) {
        try {
            if (this.queryValueJSON.isNull(key)) {
                if (this.queryValue.length() > 0) {
                    this.queryValue = new JSONObject();
                }
                this.queryValue.put("$regex", (Object)regex);
                if (modifiers != null) {
                    this.queryValue.put("$options", (Object)modifiers);
                }
                this.queryValueJSON.put(key, (Object)this.queryValue);
            } else if (this.queryValueJSON.has(key)) {
                this.queryValue.put("$regex", (Object)regex);
                if (modifiers != null) {
                    this.queryValue.put("$options", (Object)modifiers);
                }
                this.queryValueJSON.put(key, (Object)this.queryValue);
            }
        }
        catch (Exception e) {
            this.throwException("$options", "Please provide valid params.", e);
        }
        return this;
    }

    public Query locale(@NotNull String locale) {
        this.urlQueries.put("locale", (Object)locale);
        return this;
    }

    public Query search(@NotNull String value) {
        if (this.isValidValue(value)) {
            if (this.urlQueries.isNull(value)) {
                this.urlQueries.put("typeahead", (Object)value);
            }
        } else {
            this.throwException("search", "Invalid value", null);
        }
        return this;
    }

    public Query find(QueryResultsCallBack callback) {
        if (this.isJsonProper) {
            if (!this.contentTypeUid.isEmpty()) {
                this.execQuery(null, callback);
            } else {
                this.throwException("find", "Please set contentType name.", null);
                Error error = new Error();
                error.setErrorMessage(this.errorString);
            }
        } else {
            Error error = new Error();
            error.setErrorMessage(this.errorString);
        }
        return this;
    }

    public Query findOne(SingleQueryResultCallback callBack) {
        if (this.isJsonProper) {
            if (!this.contentTypeUid.isEmpty()) {
                int limit = -1;
                if (this.urlQueries != null && this.urlQueries.has("limit")) {
                    limit = (Integer)this.urlQueries.get("limit");
                }
                if (this.urlQueries != null) {
                    this.urlQueries.put("limit", 1);
                    this.execQuery(callBack, null);
                    if (limit != -1) {
                        this.urlQueries.put("limit", limit);
                    }
                }
            } else {
                this.throwException("find", "Please set contentType name.", null);
            }
        }
        return this;
    }

    private void throwException(String queryName, String messageString, @Nullable Exception e) {
        HashMap<String, String> errorHashMap = new HashMap<String, String>();
        this.isJsonProper = false;
        this.errorString = messageString;
        if (e != null) {
            errorHashMap.put(queryName, e.getLocalizedMessage());
        }
        errorHashMap.put("detail", messageString);
        assert (e != null);
        logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
    }

    protected void setQueryJson() {
        if (this.queryValueJSON != null && this.queryValueJSON.length() > 0) {
            this.urlQueries.put("query", (Object)this.queryValueJSON);
        }
        if (this.objectUidForExcept != null && this.objectUidForExcept.length() > 0) {
            this.urlQueries.put("except[BASE][]", (Object)this.objectUidForExcept);
            this.objectUidForExcept = null;
        }
        if (this.objectUidForOnly != null && this.objectUidForOnly.length() > 0) {
            this.urlQueries.put("only[BASE][]", (Object)this.objectUidForOnly);
            this.objectUidForOnly = null;
        }
        if (this.onlyJsonObject != null && this.onlyJsonObject.length() > 0) {
            this.urlQueries.put("only", (Object)this.onlyJsonObject);
            this.onlyJsonObject = null;
        }
        if (this.exceptJsonObject != null && this.exceptJsonObject.length() > 0) {
            this.urlQueries.put("except", (Object)this.exceptJsonObject);
            this.exceptJsonObject = null;
        }
        if (this.objectUidForInclude != null && this.objectUidForInclude.length() > 0) {
            this.urlQueries.put("include[]", (Object)this.objectUidForInclude);
            this.objectUidForInclude = null;
        }
    }

    protected void execQuery(SingleQueryResultCallback callBack, QueryResultsCallBack callback) {
        String urlString = "content_types/" + this.contentTypeUid + "/entries";
        this.queryResultCallback = callback;
        this.singleQueryResultCallback = callBack;
        this.setQueryJson();
        this.urlQueries.put("environment", this.headers.get("environment"));
        this.includeLivePreview();
        this.mainJSON.put("query", (Object)this.urlQueries);
        this.fetchFromNetwork(urlString, this.mainJSON, callback, callBack);
    }

    private void includeLivePreview() {
        Config ci = this.contentTypeInstance.stackInstance.config;
        if (ci.enableLivePreview && ci.livePreviewContentType.equalsIgnoreCase(this.contentTypeUid) && (ci.livePreviewHash == null || ci.livePreviewHash.isEmpty())) {
            ci.livePreviewHash = "init";
        }
    }

    private void fetchFromNetwork(String urlString, JSONObject jsonMain, ResultCallBack callback, SingleQueryResultCallback resultCallback) {
        LinkedHashMap<String, Object> urlParams = this.getUrlParams(jsonMain);
        if (resultCallback != null) {
            new CSBackgroundTask(this, this.contentTypeInstance.stackInstance, "getSingleQueryEntries", urlString, this.headers, urlParams, Constants.REQUEST_CONTROLLER.QUERY.toString(), (ResultCallBack)resultCallback);
        } else {
            new CSBackgroundTask(this, this.contentTypeInstance.stackInstance, "getQueryEntries", urlString, this.headers, urlParams, Constants.REQUEST_CONTROLLER.QUERY.toString(), callback);
        }
    }

    private LinkedHashMap<String, Object> getUrlParams(JSONObject jsonMain) {
        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<String, Object>();
        JSONObject queryJSON = jsonMain.optJSONObject("query");
        if (queryJSON != null && queryJSON.length() > 0) {
            Iterator itr = queryJSON.keys();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                Object value = queryJSON.opt(key);
                hashMap.put(key, value);
            }
        }
        return hashMap;
    }

    @Override
    public void getResult(Object object, String controller) {
    }

    @Override
    public void getResultObject(List<Object> objects, JSONObject jsonObject, boolean isSingleEntry) {
        ArrayList<Entry> objectList = new ArrayList<Entry>();
        for (Object object : objects) {
            Entry entry;
            try {
                entry = this.contentTypeInstance.stackInstance.contentType(this.contentTypeUid).entry(((EntryModel)object).uid);
            }
            catch (Exception e) {
                entry = new Entry(this.contentTypeUid);
            }
            entry.setUid(((EntryModel)object).uid);
            entry.resultJson = ((EntryModel)object).jsonObject;
            entry.title = ((EntryModel)object).title;
            entry.url = ((EntryModel)object).url;
            entry.setTags(((EntryModel)object).tags);
            objectList.add(entry);
        }
        if (isSingleEntry) {
            Entry entry = this.contentTypeInstance.entry();
            if (!objectList.isEmpty()) {
                entry = (Entry)objectList.get(0);
            }
            if (this.singleQueryResultCallback != null) {
                this.singleQueryResultCallback.onRequestFinish(ResponseType.NETWORK, entry);
            }
        } else {
            QueryResult queryResultObject = new QueryResult();
            queryResultObject.setJSON(jsonObject, objectList);
            if (this.queryResultCallback != null) {
                this.queryResultCallback.onRequestFinish(ResponseType.NETWORK, queryResultObject);
            }
        }
    }

    public Query addParam(@NotNull String key, @NotNull String value) {
        if (this.isValidKey(key) && this.isValidValue(value)) {
            this.urlQueries.put(key, (Object)value);
        } else {
            this.throwException("addParam", "Invalid key or value", null);
        }
        return this;
    }

    public Query includeReferenceContentTypUid() {
        this.urlQueries.put("include_reference_content_type_uid", (Object)"true");
        return this;
    }

    public Query whereIn(@NotNull String key, Query queryObject) {
        if (this.isValidKey(key)) {
            JSONObject inQueryObj = new JSONObject();
            inQueryObj.put("$in_query", (Object)queryObject.queryValueJSON.toString());
            this.queryValueJSON.put(key, (Object)inQueryObj);
        } else {
            this.throwException("whereIn", "Invalid key", null);
        }
        return this;
    }

    public Query whereNotIn(@NotNull String key, Query queryObject) {
        if (this.isValidKey(key)) {
            JSONObject inQueryObj = new JSONObject();
            inQueryObj.put("$nin_query", (Object)queryObject.queryValueJSON.toString());
            this.queryValueJSON.put(key, (Object)inQueryObj);
        } else {
            this.throwException("whereNotIn", "Invalid key", null);
        }
        return this;
    }

    public Query includeFallback() {
        this.urlQueries.put("include_fallback", true);
        return this;
    }

    public Query includeEmbeddedItems() {
        this.urlQueries.put("include_embedded_items[]", (Object)"BASE");
        return this;
    }

    public Query includeBranch() {
        this.urlQueries.put("include_branch", true);
        return this;
    }

    public Query includeMetadata() {
        this.urlQueries.put("include_metadata", true);
        return this;
    }
}

