/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.AssetModel;
import com.contentstack.sdk.CSBackgroundTask;
import com.contentstack.sdk.Constants;
import com.contentstack.sdk.FetchResultCallback;
import com.contentstack.sdk.ResultCallBack;
import com.contentstack.sdk.Stack;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import retrofit2.Retrofit;

public class Asset {
    protected static final Logger logger = Logger.getLogger(Asset.class.getSimpleName());
    protected final JSONObject urlQueries = new JSONObject();
    protected String assetUid = null;
    protected String contentType = null;
    protected String fileSize = null;
    protected String fileName = null;
    protected String uploadUrl = null;
    protected JSONObject json = null;
    protected String[] tagsArray = null;
    protected LinkedHashMap<String, Object> headers;
    protected Stack stackInstance;
    protected Retrofit retrofit;

    protected Asset() {
        this.headers = new LinkedHashMap();
    }

    protected Asset(@NotNull String assetUid) {
        this.assetUid = assetUid;
        this.headers = new LinkedHashMap();
    }

    protected void setStackInstance(@NotNull Stack stack) {
        this.stackInstance = stack;
        this.headers = stack.headers;
    }

    public Asset configure(JSONObject jsonObject) {
        AssetModel model = new AssetModel(jsonObject, true);
        this.contentType = model.contentType;
        this.fileSize = model.fileSize;
        this.uploadUrl = model.uploadUrl;
        this.fileName = model.fileName;
        this.json = model.json;
        this.assetUid = model.uploadedUid;
        this.setTags(model.tags);
        return this;
    }

    public void setHeader(@NotNull String headerKey, @NotNull String headerValue) {
        this.headers.put(headerKey, headerValue);
    }

    public void removeHeader(@NotNull String headerKey) {
        this.headers.remove(headerKey);
    }

    protected void setUid(@NotNull String assetUid) {
        if (!assetUid.isEmpty()) {
            this.assetUid = assetUid;
        }
    }

    public String getAssetUid() {
        return this.assetUid;
    }

    public String getFileType() {
        return this.contentType;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUrl() {
        return this.uploadUrl;
    }

    public JSONObject toJSON() {
        return this.json;
    }

    public Calendar getCreateAt() {
        return Constants.parseDate(this.json.optString("created_at"), null);
    }

    public String getCreatedBy() {
        return this.json.optString("created_by");
    }

    public Calendar getUpdateAt() {
        return Constants.parseDate(this.json.optString("updated_at"), null);
    }

    public String getUpdatedBy() {
        return this.json.optString("updated_by");
    }

    public Calendar getDeleteAt() {
        return Constants.parseDate(this.json.optString("deleted_at"), null);
    }

    public String getDeletedBy() {
        return this.json.optString("deleted_by");
    }

    public String[] getTags() {
        return this.tagsArray;
    }

    protected Asset setTags(String[] tags) {
        this.tagsArray = tags;
        return this;
    }

    public Asset includeDimension() {
        this.urlQueries.put("include_dimension", true);
        return this;
    }

    public Asset addParam(@NotNull String paramKey, @NotNull String paramValue) {
        this.urlQueries.put(paramKey, (Object)paramValue);
        return this;
    }

    public Asset includeFallback() {
        this.urlQueries.put("include_fallback", true);
        return this;
    }

    public Asset includeBranch() {
        this.urlQueries.put("include_branch", true);
        return this;
    }

    public Asset includeMetadata() {
        this.urlQueries.put("include_metadata", true);
        return this;
    }

    public void fetch(FetchResultCallback callback) {
        this.urlQueries.put("environment", this.headers.get("environment"));
        this.fetchFromNetwork("assets/" + this.assetUid, this.urlQueries, this.headers, callback);
    }

    private void fetchFromNetwork(String url, JSONObject urlQueries, LinkedHashMap<String, Object> headers, FetchResultCallback callback) {
        if (callback != null) {
            HashMap<String, Object> urlParams = this.getUrlParams(urlQueries);
            new CSBackgroundTask(this, this.stackInstance, "getAssets", url, headers, urlParams, Constants.REQUEST_CONTROLLER.ASSET.toString(), (ResultCallBack)callback);
        }
    }

    private HashMap<String, Object> getUrlParams(JSONObject urlQueriesJSON) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (urlQueriesJSON != null && urlQueriesJSON.length() > 0) {
            Iterator keyArrays = urlQueriesJSON.keys();
            while (keyArrays.hasNext()) {
                String key = (String)keyArrays.next();
                Object value = urlQueriesJSON.opt(key);
                hashMap.put(key, value);
            }
        }
        return hashMap;
    }

    @Generated
    public JSONObject getUrlQueries() {
        return this.urlQueries;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @Generated
    public JSONObject getJson() {
        return this.json;
    }

    @Generated
    public String[] getTagsArray() {
        return this.tagsArray;
    }

    @Generated
    public LinkedHashMap<String, Object> getHeaders() {
        return this.headers;
    }

    @Generated
    public Stack getStackInstance() {
        return this.stackInstance;
    }

    @Generated
    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    @Generated
    public void setAssetUid(String assetUid) {
        this.assetUid = assetUid;
    }

    @Generated
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Generated
    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    @Generated
    public void setJson(JSONObject json) {
        this.json = json;
    }

    @Generated
    public void setTagsArray(String[] tagsArray) {
        this.tagsArray = tagsArray;
    }

    @Generated
    public void setHeaders(LinkedHashMap<String, Object> headers) {
        this.headers = headers;
    }

    @Generated
    public void setRetrofit(Retrofit retrofit) {
        this.retrofit = retrofit;
    }
}

