/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format.formatter;

import com.cosium.code.format.FileExtension;
import com.cosium.code.format.MavenGitCodeFormatException;
import com.cosium.code.format.formatter.CodeFormatter;
import com.cosium.code.format.formatter.GoogleJavaFormatterOptions;
import com.cosium.code.format.formatter.LineRanges;
import com.google.common.collect.RangeSet;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class GoogleJavaFormatter
implements CodeFormatter {
    private final GoogleJavaFormatterOptions options;
    private final Formatter formatter;
    private final String sourceEncoding;

    public GoogleJavaFormatter(GoogleJavaFormatterOptions options, String sourceEncoding) {
        this.options = Objects.requireNonNull(options);
        this.formatter = new Formatter(options.javaFormatterOptions());
        this.sourceEncoding = sourceEncoding;
    }

    @Override
    public FileExtension fileExtension() {
        return FileExtension.of("java");
    }

    @Override
    public void format(InputStream content, LineRanges lineRanges, OutputStream formattedContent) {
        String formattedContentToWrite;
        try {
            String unformattedContent = IOUtils.toString((InputStream)content, (String)this.sourceEncoding);
            formattedContentToWrite = this.doFormat(unformattedContent, lineRanges);
        }
        catch (FormatterException | IOException e) {
            throw new MavenGitCodeFormatException(e);
        }
        try {
            IOUtils.write((String)formattedContentToWrite, (OutputStream)formattedContent, (String)this.sourceEncoding);
        }
        catch (IOException e) {
            throw new MavenGitCodeFormatException(e);
        }
    }

    @Override
    public boolean validate(InputStream content) {
        try {
            String unformattedContent = IOUtils.toString((InputStream)content, (String)this.sourceEncoding);
            String formattedContent = this.doFormat(unformattedContent, LineRanges.all());
            return unformattedContent.equals(formattedContent);
        }
        catch (FormatterException | IOException e) {
            throw new MavenGitCodeFormatException(e);
        }
    }

    private String doFormat(String unformattedContent, LineRanges lineRanges) throws FormatterException {
        if (this.options.isFixImportsOnly()) {
            if (!lineRanges.isAll()) {
                return unformattedContent;
            }
            return this.fixImports(unformattedContent);
        }
        if (lineRanges.isAll()) {
            return this.fixImports(this.formatter.formatSource(unformattedContent));
        }
        RangeSet charRangeSet = Formatter.lineRangesToCharRanges((String)unformattedContent, lineRanges.rangeSet());
        return this.formatter.formatSource(unformattedContent, (Collection)charRangeSet.asRanges());
    }

    private String fixImports(String unformattedContent) throws FormatterException {
        String formattedContent = unformattedContent;
        if (!this.options.isSkipRemovingUnusedImports()) {
            formattedContent = RemoveUnusedImports.removeUnusedImports((String)formattedContent);
        }
        if (!this.options.isSkipSortingImports()) {
            formattedContent = ImportOrderer.reorderImports((String)formattedContent);
        }
        return formattedContent;
    }
}

