/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format.git;

import com.cosium.code.format.FileExtension;
import com.cosium.code.format.MavenGitCodeFormatException;
import com.cosium.code.format.TemporaryFile;
import com.cosium.code.format.formatter.CodeFormatter;
import com.cosium.code.format.formatter.CodeFormatters;
import com.cosium.code.format.formatter.LineRanges;
import com.google.common.collect.Range;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.NullOutputStream;

class GitIndexEntry {
    private final Log log;
    private final Repository repository;
    private final String path;

    GitIndexEntry(Log log, Repository repository, String path) {
        this.log = Objects.requireNonNull(log);
        this.repository = Objects.requireNonNull(repository);
        this.path = Objects.requireNonNull(path);
    }

    DirCacheEditor.PathEdit entryFormatter(CodeFormatters formatters) {
        return new EntryFormatter(this.log, this.repository, formatters, this.path);
    }

    private static class EntryFormatter
    extends DirCacheEditor.PathEdit {
        private final Log log;
        private final Repository repository;
        private final CodeFormatters formatters;

        EntryFormatter(Log log, Repository repository, CodeFormatters formatters, String entryPath) {
            super(entryPath);
            this.log = log;
            this.repository = Objects.requireNonNull(repository);
            this.formatters = Objects.requireNonNull(formatters);
        }

        public void apply(DirCacheEntry dirCacheEntry) {
            this.formatters.forFileExtension(FileExtension.parse(dirCacheEntry.getPathString())).forEach(formatter -> this.doFormat(dirCacheEntry, (CodeFormatter)formatter));
        }

        private void doFormat(DirCacheEntry dirCacheEntry, CodeFormatter formatter) {
            LineRanges lineRanges = this.computeLineRanges(dirCacheEntry);
            if (lineRanges.isAll()) {
                this.log.info((CharSequence)("Formatting '" + dirCacheEntry.getPathString() + "'"));
            } else {
                this.log.info((CharSequence)("Formatting lines " + lineRanges + " of '" + dirCacheEntry.getPathString() + "'"));
            }
            try (TemporaryFile temporaryFormattedFile = TemporaryFile.create(this.log, dirCacheEntry.getPathString() + ".formatted");){
                ObjectId formattedObjectId;
                ObjectId unformattedObjectId = dirCacheEntry.getObjectId();
                this.log.debug((CharSequence)("Unformatted object id is '" + unformattedObjectId + "'"));
                ObjectDatabase objectDatabase = this.repository.getObjectDatabase();
                ObjectLoader objectLoader = objectDatabase.open((AnyObjectId)unformattedObjectId);
                this.logObjectContent(objectLoader, dirCacheEntry.getPathString() + ".unformatted");
                try (ObjectStream content = objectLoader.openStream();
                     OutputStream formattedContent = temporaryFormattedFile.newOutputStream();){
                    formatter.format((InputStream)content, lineRanges, formattedContent);
                }
                long formattedSize = temporaryFormattedFile.size();
                try (InputStream formattedContent = temporaryFormattedFile.newInputStream();
                     ObjectInserter objectInserter = objectDatabase.newInserter();){
                    formattedObjectId = objectInserter.insert(3, formattedSize, formattedContent);
                    objectInserter.flush();
                }
                this.log.debug((CharSequence)("Formatted size is " + formattedSize));
                dirCacheEntry.setLength(formattedSize);
                this.log.debug((CharSequence)("Formatted object id is '" + formattedObjectId + "'"));
                dirCacheEntry.setObjectId((AnyObjectId)formattedObjectId);
            }
            catch (IOException e) {
                throw new MavenGitCodeFormatException(e);
            }
            if (lineRanges.isAll()) {
                this.log.info((CharSequence)("Formatted '" + dirCacheEntry.getPathString() + "'"));
            } else {
                this.log.info((CharSequence)("Formatted lines " + lineRanges + " of '" + dirCacheEntry.getPathString() + "'"));
            }
        }

        private void logObjectContent(ObjectLoader objectLoader, String virtualName) throws IOException {
            if (!this.log.isDebugEnabled()) {
                return;
            }
            try (ObjectStream input = objectLoader.openStream();
                 OutputStream output = TemporaryFile.create(this.log, virtualName).newOutputStream();){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
        }

        private LineRanges computeLineRanges(DirCacheEntry dirCacheEntry) {
            boolean partiallyStaged;
            Git git = new Git(this.repository);
            try {
                partiallyStaged = !git.status().addPath(dirCacheEntry.getPathString()).call().getModified().isEmpty();
            }
            catch (GitAPIException e) {
                throw new MavenGitCodeFormatException(e);
            }
            if (!partiallyStaged) {
                return LineRanges.all();
            }
            try {
                return git.diff().setPathFilter((TreeFilter)PathFilter.create((String)dirCacheEntry.getPathString())).setCached(true).call().stream().map(this::computeLineRanges).reduce(LineRanges::concat).orElse(LineRanges.all());
            }
            catch (GitAPIException e) {
                throw new MavenGitCodeFormatException(e);
            }
        }

        private LineRanges computeLineRanges(DiffEntry diffEntry) {
            DiffFormatter diffFormatter = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);
            diffFormatter.setRepository(this.repository);
            try {
                FileHeader fileHeader = diffFormatter.toFileHeader(diffEntry);
                return fileHeader.getHunks().stream().map(HunkHeader.class::cast).map(this::computeLineRanges).reduce(LineRanges::concat).orElse(LineRanges.all());
            }
            catch (IOException e) {
                throw new MavenGitCodeFormatException(e);
            }
        }

        private LineRanges computeLineRanges(HunkHeader hunkHeader) {
            Set<Range<Integer>> ranges = hunkHeader.toEditList().stream().flatMap(edit -> Stream.of(Range.closedOpen((Comparable)Integer.valueOf(edit.getBeginA()), (Comparable)Integer.valueOf(edit.getEndA())), Range.closedOpen((Comparable)Integer.valueOf(edit.getBeginB()), (Comparable)Integer.valueOf(edit.getEndB())))).filter(((Predicate<Range>)Range::isEmpty).negate()).collect(Collectors.toSet());
            return LineRanges.of(ranges);
        }
    }
}

