/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format.maven;

import com.cosium.code.format.MavenGitCodeFormatException;
import com.cosium.code.format.executable.CommandRunException;
import com.cosium.code.format.executable.CommandRunner;
import com.cosium.code.format.executable.DefaultCommandRunner;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.commons.exec.OS;
import org.apache.maven.plugin.logging.Log;

public class MavenEnvironment {
    private static final String MAVEN_HOME_PROP = "maven.home";
    private final Supplier<Log> log;
    private final UnaryOperator<String> systemProperties;
    private final CommandRunner commandRunner;

    public MavenEnvironment(Supplier<Log> log) {
        this(log, System::getProperty, new DefaultCommandRunner(log));
    }

    MavenEnvironment(Supplier<Log> log, UnaryOperator<String> systemProperties, CommandRunner commandRunner) {
        this.log = log;
        this.systemProperties = Objects.requireNonNull(systemProperties);
        this.commandRunner = Objects.requireNonNull(commandRunner);
    }

    public Path getMavenExecutable(boolean debug) {
        Path mavenHome = Paths.get((String)this.systemProperties.apply(MAVEN_HOME_PROP), new String[0]);
        this.log.get().debug((CharSequence)("maven.home=" + mavenHome));
        Path bin = mavenHome.resolve("bin");
        String extension = OS.isFamilyWindows() ? ".cmd" : "";
        Path executable = !debug ? bin.resolve("mvn" + extension) : bin.resolve("mvnDebug" + extension);
        try {
            this.commandRunner.run(null, executable.toString(), "--version");
            return executable;
        }
        catch (CommandRunException e) {
            this.log.get().debug((CharSequence)e.getMessage());
            Path fallbackExecutable = !debug ? Paths.get("mvn" + extension, new String[0]) : Paths.get("mvnDebug" + extension, new String[0]);
            this.log.get().info((CharSequence)("Could not execute '" + executable + "'. Falling back to '" + fallbackExecutable + "'."));
            try {
                this.commandRunner.run(null, fallbackExecutable.toString(), "--version");
                return fallbackExecutable;
            }
            catch (CommandRunException e2) {
                throw new MavenGitCodeFormatException(e2.getMessage(), e2);
            }
        }
    }
}

