/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.AbstractMavenGitCodeFormatMojo;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractModuleMavenGitCodeFormatMojo
extends AbstractMavenGitCodeFormatMojo {
    @Parameter(property="gcf.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="gcf.includedModules")
    private List<String> includedModules;
    @Parameter(property="gcf.excludedModules")
    private List<String> excludedModules;

    private boolean isEnabled() {
        List excludedModules = Optional.ofNullable(this.excludedModules).orElse(Collections.emptyList());
        if (excludedModules.contains(this.artifactId())) {
            this.getLog().info((CharSequence)(this.artifactId() + " is part of the excluded modules. Goal disabled."));
            return false;
        }
        List includedModules = Optional.ofNullable(this.includedModules).orElse(Collections.emptyList());
        if (!includedModules.isEmpty() && !includedModules.contains(this.artifactId())) {
            this.getLog().info((CharSequence)(this.artifactId() + " is not part of defined included modules. Goal disabled."));
            return false;
        }
        if (!(includedModules.isEmpty() && excludedModules.isEmpty() || !this.isExecutionRoot())) {
            this.getLog().info((CharSequence)"Explicit included or excluded modules defined and the current module the execution root. Goal disabled.");
            return false;
        }
        this.getLog().debug((CharSequence)"Goal enabled");
        return true;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            Log log = this.getLog();
            if (log.isInfoEnabled()) {
                log.info((CharSequence)"skipped");
            }
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;
}

