/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.AbstractFormatMojo;
import com.cosium.code.format.FileExtension;
import com.cosium.code.format.MavenGitCodeFormatException;
import com.cosium.code.format.TemporaryFile;
import com.cosium.code.format.formatter.CodeFormatter;
import com.cosium.code.format.formatter.LineRanges;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="format-code", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class FormatCodeMojo
extends AbstractFormatMojo {
    @Override
    protected void process(Path path) {
        this.codeFormatters().forFileExtension(FileExtension.parse(path)).forEach(formatter -> this.format(path, (CodeFormatter)formatter));
    }

    private void format(Path path, CodeFormatter formatter) {
        this.getLog().debug((CharSequence)("Formatting '" + this.gitBaseDir().relativize(path) + "'"));
        try (TemporaryFile temporaryFormattedFile = TemporaryFile.create(this.getLog(), path + ".formatted");){
            Throwable throwable;
            try (InputStream content = Files.newInputStream(path, new OpenOption[0]);){
                throwable = null;
                try (OutputStream formattedContent = temporaryFormattedFile.newOutputStream();){
                    formatter.format(content, LineRanges.all(), formattedContent);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            var6_9 = null;
            try (InputStream formattedContent = temporaryFormattedFile.newInputStream();){
                throwable = null;
                try (OutputStream unformattedContent = Files.newOutputStream(path, new OpenOption[0]);){
                    IOUtils.copy((InputStream)formattedContent, (OutputStream)unformattedContent);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var6_9 = throwable4;
                throw throwable4;
            }
        }
        catch (IOException e) {
            throw new MavenGitCodeFormatException(e);
        }
        this.getLog().debug((CharSequence)("Formatted '" + this.gitBaseDir().relativize(path) + "'"));
    }
}

