/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.AbstractFormatMojo;
import com.cosium.code.format.FileExtension;
import com.cosium.code.format.MavenGitCodeFormatException;
import com.cosium.code.format.formatter.CodeFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="validate-code-format", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class ValidateCodeFormat
extends AbstractFormatMojo {
    @Override
    protected void process(Path path) throws MojoFailureException {
        if (this.validate(path)) {
            return;
        }
        throw new MojoFailureException(path + " is not correctly formatted !");
    }

    private boolean validate(Path path) {
        return this.codeFormatters().forFileExtension(FileExtension.parse(path)).stream().map(formatter -> this.doValidate(path, (CodeFormatter)formatter)).filter(valid -> valid == false).findFirst().orElse(true);
    }

    private boolean doValidate(Path path, CodeFormatter formatter) {
        boolean bl;
        block8: {
            this.getLog().debug((CharSequence)("Validating '" + this.gitBaseDir().relativize(path) + "'"));
            InputStream content = Files.newInputStream(path, new OpenOption[0]);
            try {
                bl = formatter.validate(content);
                if (content == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MavenGitCodeFormatException(e);
                }
            }
            content.close();
        }
        return bl;
    }
}

