/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.MavenGitCodeFormatException;
import com.cosium.code.format.formatter.CodeFormatterConfigurationFactory;
import com.cosium.code.format.formatter.CodeFormatters;
import com.cosium.code.format_spi.CodeFormatter;
import com.cosium.code.format_spi.CodeFormatterFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public abstract class AbstractMavenGitCodeFormatMojo
extends AbstractMojo {
    protected static final String HOOKS_DIR = "hooks";
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject currentProject;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding;
    @Parameter
    private Map<String, String> formatterOptions;

    protected final Repository gitRepository() {
        Repository gitRepository;
        try {
            FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(this.currentProject.getBasedir());
            String gitIndexFileEnvVariable = System.getenv("GIT_INDEX_FILE");
            if (StringUtils.isNotBlank((CharSequence)gitIndexFileEnvVariable)) {
                repositoryBuilder = (FileRepositoryBuilder)repositoryBuilder.setIndexFile(new File(gitIndexFileEnvVariable));
            }
            gitRepository = repositoryBuilder.build();
        }
        catch (IOException e) {
            throw new MavenGitCodeFormatException("Could not find the git repository. Run 'git init' if you did not.", e);
        }
        return gitRepository;
    }

    protected final Path pomFile() {
        return this.currentProject.getFile().toPath();
    }

    protected final List<Path> sourceDirs() {
        return Stream.of(this.currentProject.getCompileSourceRoots(), this.currentProject.getTestCompileSourceRoots()).flatMap(Collection::stream).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    protected final Path targetDir() {
        return Paths.get(this.currentProject.getBuild().getDirectory(), new String[0]);
    }

    protected final String artifactId() {
        return this.currentProject.getArtifactId();
    }

    protected final CodeFormatters codeFormatters() {
        return new CodeFormatters(this.createCodeFormatters());
    }

    private List<CodeFormatter> createCodeFormatters() {
        ArrayList formatterFactories = new ArrayList();
        ServiceLoader.load(CodeFormatterFactory.class).forEach(formatterFactories::add);
        CodeFormatterConfigurationFactory formatterConfigurationFactory = new CodeFormatterConfigurationFactory(this.formatterOptions);
        return formatterFactories.stream().map(codeFormatterFactory -> codeFormatterFactory.build(formatterConfigurationFactory.build(codeFormatterFactory.configurationId()), this.sourceEncoding)).collect(Collectors.toList());
    }

    protected final boolean isExecutionRoot() {
        return this.currentProject.isExecutionRoot();
    }

    protected final Path getOrCreateHooksDirectory() {
        Path hooksDirectory = this.gitRepository().getDirectory().toPath().resolve(HOOKS_DIR);
        if (!Files.exists(hooksDirectory, new LinkOption[0])) {
            this.getLog().debug((CharSequence)("Creating directory " + hooksDirectory));
            try {
                Files.createDirectories(hooksDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MavenGitCodeFormatException(e);
            }
        } else {
            this.getLog().debug((CharSequence)(hooksDirectory + " already exists"));
        }
        return hooksDirectory;
    }

    protected final Path gitBaseDir() {
        return this.gitRepository().getDirectory().getParentFile().toPath();
    }
}

