/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.AbstractFormatMojo;
import com.cosium.code.format.MavenGitCodeFormatException;
import com.cosium.code.format.TemporaryFile;
import com.cosium.code.format_spi.CodeFormatter;
import com.cosium.code.format_spi.FileExtension;
import com.cosium.code.format_spi.LineRanges;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="format-code", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class FormatCodeMojo
extends AbstractFormatMojo {
    @Override
    protected void process(Path path) {
        this.codeFormatters().forFileExtension(FileExtension.parse((Path)path)).forEach(formatter -> this.format(path, (CodeFormatter)formatter));
    }

    private void format(Path path, CodeFormatter formatter) {
        this.getLog().debug((CharSequence)("Formatting '" + this.gitBaseDir().relativize(path) + "'"));
        try (TemporaryFile temporaryFormattedFile = TemporaryFile.create(this.getLog(), path + ".formatted");){
            try (InputStream content = Files.newInputStream(path, new OpenOption[0]);
                 OutputStream formattedContent = temporaryFormattedFile.newOutputStream();){
                formatter.format(content, LineRanges.all(), formattedContent);
            }
            try (InputStream formattedContent = temporaryFormattedFile.newInputStream();
                 OutputStream unformattedContent = Files.newOutputStream(path, new OpenOption[0]);){
                IOUtils.copy((InputStream)formattedContent, (OutputStream)unformattedContent);
            }
        }
        catch (IOException e) {
            throw new MavenGitCodeFormatException(e);
        }
        this.getLog().debug((CharSequence)("Formatted '" + this.gitBaseDir().relativize(path) + "'"));
    }
}

