/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format_gjf;

import com.cosium.code.format_spi.CodeFormatterConfiguration;
import com.google.googlejavaformat.java.JavaFormatterOptions;

class GoogleJavaFormatterOptions {
    private final JavaFormatterOptions.Style style;
    private final boolean fixImportsOnly;
    private final boolean skipSortingImports;
    private final boolean skipRemovingUnusedImports;

    public GoogleJavaFormatterOptions(CodeFormatterConfiguration configuration) {
        boolean aosp = configuration.getValue("aosp").map(Boolean::parseBoolean).orElse(false);
        this.style = aosp ? JavaFormatterOptions.Style.AOSP : JavaFormatterOptions.Style.GOOGLE;
        this.fixImportsOnly = configuration.getValue("fixImportsOnly").map(Boolean::parseBoolean).orElse(false);
        this.skipSortingImports = configuration.getValue("skipSortingImports").map(Boolean::parseBoolean).orElse(false);
        this.skipRemovingUnusedImports = configuration.getValue("skipRemovingUnusedImports").map(Boolean::parseBoolean).orElse(false);
    }

    public JavaFormatterOptions javaFormatterOptions() {
        return JavaFormatterOptions.builder().style(this.style).build();
    }

    public boolean isFixImportsOnly() {
        return this.fixImportsOnly;
    }

    public boolean isSkipSortingImports() {
        return this.skipSortingImports;
    }

    public boolean isSkipRemovingUnusedImports() {
        return this.skipRemovingUnusedImports;
    }

    public String toString() {
        return "GoogleJavaFormatterOptions{style=" + this.style + ", fixImportsOnly=" + this.fixImportsOnly + ", skipSortingImports=" + this.skipSortingImports + ", skipRemovingUnusedImports=" + this.skipRemovingUnusedImports + '}';
    }
}

