/*
 * Decompiled with CFR 0.152.
 */
package com.creeaaakk.tools.concurrent;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class CountDownLatch {
    private AtomicInteger count;

    public CountDownLatch(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be at least 0");
        }
        if (count == 0) {
            this.onZero();
        }
        this.count = new AtomicInteger(count);
    }

    public void countDown() {
        if (this.count.decrementAndGet() == 0) {
            this.onZero();
        }
    }

    protected abstract void onZero();

    public int getCount() {
        return this.count.get();
    }
}

