/*
 * Decompiled with CFR 0.152.
 */
package com.creeaaakk.tools.concurrent;

import com.creeaaakk.tools.concurrent.ThreadedRunnable;
import com.creeaaakk.tools.util.InCallback;
import com.creeaaakk.tools.util.Once;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ThreadedQueue<T> {
    private static final long DEFAULT_TIMEOUT = 60000L;
    public static volatile ExecutorService defaultPool;
    private final ExecutorService pool;
    private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
    private final long timeoutMillis;
    private final Once setRunnable = new Once(new InCallback(){

        @Override
        public void callIn(Object object) {
            ThreadedQueue.this.runnable = (ThreadedRunnable)object;
        }
    });
    private ThreadedRunnable<T> runnable;
    private Future<?> task;

    public ThreadedQueue(ThreadedRunnable<T> runnable) {
        this(runnable, defaultPool, 60000L);
    }

    public ThreadedQueue(ThreadedRunnable<T> runnable, ExecutorService pool) {
        this(runnable, pool, 60000L);
    }

    public ThreadedQueue(ThreadedRunnable<T> runnable, long timeoutMillis) {
        this(runnable, defaultPool, timeoutMillis);
    }

    public ThreadedQueue(ThreadedRunnable<T> runnable, ExecutorService pool, long timeoutMillis) {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("negative timeoutMillis: " + timeoutMillis);
        }
        if (runnable != null) {
            this.setRunnable(runnable);
        }
        if (pool == null) {
            pool = Executors.newCachedThreadPool();
        }
        this.pool = pool;
        this.timeoutMillis = timeoutMillis;
    }

    public void setRunnable(ThreadedRunnable<T> runnable) {
        this.setRunnable.callIn(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(T item) {
        boolean put = false;
        while (!put) {
            try {
                this.queue.put(item);
                put = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        BlockingQueue<T> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            if (this.task == null || this.task.isDone()) {
                this.task = this.pool.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean done = false;
                        while (!done) {
                            try {
                                Object item = ThreadedQueue.this.queue.poll(ThreadedQueue.this.timeoutMillis, TimeUnit.MILLISECONDS);
                                if (item == null) {
                                    done = true;
                                    continue;
                                }
                                ThreadedQueue.this.runnable.run(item);
                            }
                            catch (InterruptedException exception) {
                            }
                            catch (Exception exception) {}
                        }
                        BlockingQueue blockingQueue = ThreadedQueue.this.queue;
                        synchronized (blockingQueue) {
                            ThreadedQueue.this.task = null;
                        }
                    }
                });
            }
        }
    }
}

