/*
 * Decompiled with CFR 0.152.
 */
package com.creeaaakk.tools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public class CycleQueue<T>
implements Queue<T>,
Iterable<T> {
    private final List<T> queue = new ArrayList<T>();
    private int index = 0;

    public CycleQueue() {
    }

    public CycleQueue(Collection<? extends T> c) {
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<T> iterator;
            {
                this.iterator = CycleQueue.this.queue.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                return this.iterator.next();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException("CycleQueue does not allow removal of elements.");
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean remove(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("CycleQueue does not allow removal of elements.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.queue.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean add(T e) {
        return this.queue.add(e);
    }

    @Override
    public boolean offer(T e) {
        return this.add(e);
    }

    @Override
    public T remove() {
        if (this.isEmpty()) {
            return null;
        }
        T ret = this.queue.get(this.getIndex());
        this.incIndex();
        return ret;
    }

    @Override
    public T poll() {
        return this.remove();
    }

    @Override
    public T element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.queue.get(this.getIndex());
    }

    @Override
    public T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.queue.get(this.getIndex());
    }

    private int getIndex() {
        if (this.index >= this.queue.size()) {
            this.index = 0;
        }
        return this.index;
    }

    private void incIndex() {
        ++this.index;
    }
}

