/*
 * Decompiled with CFR 0.152.
 */
package com.creeaaakk.tools.util;

public final class MathUtil {
    public static int percentDifference(int a, int b) {
        if (a < 0 || b < 0) {
            throw new IllegalArgumentException();
        }
        if (a + b == 0) {
            return 0;
        }
        return Math.abs(200 * (a - b) / (a + b));
    }

    public static long percentDifference(long a, long b) {
        if (a < 0L || b < 0L) {
            throw new IllegalArgumentException();
        }
        if (a + b == 0L) {
            return 0L;
        }
        return Math.abs(200L * (a - b) / (a + b));
    }

    public static float percentDifference(float a, float b) {
        if (a < 0.0f || b < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (a + b == 0.0f) {
            return 0.0f;
        }
        return Math.abs(200.0f * (a - b) / (a + b));
    }

    public static double percentDifference(double a, double b) {
        if (a < 0.0 || b < 0.0) {
            throw new IllegalArgumentException();
        }
        if (a + b == 0.0) {
            return 0.0;
        }
        return Math.abs(200.0 * (a - b) / (a + b));
    }

    public static double squareDistance(double x1, double y1, double x2, double y2) {
        double xDiff = x1 - x2;
        double yDiff = y1 - y2;
        return xDiff * xDiff + yDiff * yDiff;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(MathUtil.squareDistance(x1, y1, x2, y2));
    }

    public static double radiansToDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    public static double degreesToRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }
}

