/*
 * Decompiled with CFR 0.152.
 */
package com.creeaaakk.tools.util;

import com.creeaaakk.tools.util.InCallback;
import com.creeaaakk.tools.util.InOutCallback;
import com.creeaaakk.tools.util.OutCallback;
import java.util.concurrent.atomic.AtomicBoolean;

public class Once
implements Runnable,
InCallback,
OutCallback,
InOutCallback {
    private final AtomicBoolean doneNonBlocking;
    private final Runnable runnable;
    private final InCallback inCallback;
    private final OutCallback outCallback;
    private final InOutCallback inOutCallback;
    private boolean doneBlocking = false;

    public Once(Runnable runnable) {
        this(runnable, true);
    }

    public Once(InCallback inCallback) {
        this(inCallback, true);
    }

    public Once(OutCallback outCallback) {
        this(outCallback, true);
    }

    public Once(InOutCallback inOutCallback) {
        this(inOutCallback, true);
    }

    public Once(Runnable runnable, boolean blocking) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        this.runnable = runnable;
        this.inCallback = null;
        this.outCallback = null;
        this.inOutCallback = null;
        this.doneNonBlocking = blocking ? null : new AtomicBoolean(false);
    }

    public Once(InCallback inCallback, boolean blocking) {
        if (inCallback == null) {
            throw new IllegalArgumentException("inCallback is null");
        }
        this.runnable = null;
        this.inCallback = inCallback;
        this.outCallback = null;
        this.inOutCallback = null;
        this.doneNonBlocking = blocking ? null : new AtomicBoolean(false);
    }

    public Once(OutCallback outCallback, boolean blocking) {
        if (outCallback == null) {
            throw new IllegalArgumentException("outCallback is null");
        }
        this.runnable = null;
        this.inCallback = null;
        this.outCallback = outCallback;
        this.inOutCallback = null;
        this.doneNonBlocking = blocking ? null : new AtomicBoolean(false);
    }

    public Once(InOutCallback inOutCallback, boolean blocking) {
        if (inOutCallback == null) {
            throw new IllegalArgumentException("inOutCallback is null");
        }
        this.runnable = null;
        this.inCallback = null;
        this.outCallback = null;
        this.inOutCallback = inOutCallback;
        this.doneNonBlocking = blocking ? null : new AtomicBoolean(false);
    }

    @Override
    public void run() {
        this.callInOut(null);
    }

    @Override
    public void callIn(Object object) {
        this.callInOut(object);
    }

    @Override
    public Object callOut() {
        return this.callInOut(null);
    }

    @Override
    public Object callInOut(Object object) {
        if (this.doneNonBlocking != null) {
            return this.executeNonBlocking(object);
        }
        return this.executeBlocking(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeBlocking(Object object) {
        Object ret = null;
        if (!this.doneBlocking) {
            Once once = this;
            synchronized (once) {
                if (!this.doneBlocking) {
                    ret = this.execute(object);
                    this.doneBlocking = true;
                }
            }
        }
        return ret;
    }

    private Object executeNonBlocking(Object object) {
        Object ret = null;
        if (!this.doneNonBlocking.getAndSet(true)) {
            ret = this.execute(object);
        }
        return ret;
    }

    private Object execute(Object object) {
        if (this.runnable != null) {
            this.runnable.run();
        } else if (this.inCallback != null) {
            this.inCallback.callIn(object);
        } else {
            if (this.outCallback != null) {
                return this.outCallback.callOut();
            }
            if (this.inOutCallback != null) {
                return this.inOutCallback.callInOut(object);
            }
        }
        return null;
    }
}

