/*
 * Decompiled with CFR 0.152.
 */
package com.creeaaakk.tools.util;

import com.creeaaakk.tools.util.IReplaceable;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ReplaceSet<T extends IReplaceable>
implements Set<T>,
Serializable {
    private static final long serialVersionUID = 7976383212867753829L;
    private final Map<T, T> map = new HashMap<T, T>();
    private final Set<T> set = this.map.keySet();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object key) {
        if (key == null || !(key instanceof IReplaceable)) {
            return false;
        }
        IReplaceable replaceable = (IReplaceable)key;
        return this.map.containsKey(replaceable) && !replaceable.needReplace(this.map.get(replaceable));
    }

    @Override
    public Iterator<T> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <S> S[] toArray(S[] array) {
        return this.set.toArray(array);
    }

    @Override
    public boolean add(T element) {
        if (element == null) {
            throw new IllegalArgumentException("element is null");
        }
        if (element.needReplace(this.map.get(element))) {
            this.map.remove(element);
            this.map.put(element, element);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean changed = false;
        for (IReplaceable item : collection) {
            changed |= this.add((T)item);
        }
        return changed;
    }

    @Override
    public boolean remove(Object key) {
        return this.map.remove(key) != null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object object : collection) {
            if (this.set.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = this.set.retainAll(collection);
        for (Object object : collection) {
            if (object == null || !(object instanceof IReplaceable)) continue;
            IReplaceable replaceable = (IReplaceable)object;
            if (!this.map.containsKey(object) || !replaceable.needReplace(this.map.get(replaceable))) continue;
            this.map.remove(replaceable);
            this.map.put(replaceable, replaceable);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.set.removeAll(collection);
    }

    @Override
    public void clear() {
        this.set.clear();
    }
}

