/*
 * Criteo API Transition Swagger
 * This is used to help Criteo clients transition from MAPI to Criteo API
 *
 * The version of the OpenAPI document: 1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.criteo.marketing.api;

import com.criteo.marketing.ApiCallback;
import com.criteo.marketing.ApiClient;
import com.criteo.marketing.ApiException;
import com.criteo.marketing.ApiResponse;
import com.criteo.marketing.Configuration;
import com.criteo.marketing.Pair;
import com.criteo.marketing.ProgressRequestBody;
import com.criteo.marketing.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.criteo.marketing.model.CategoryMessage;
import com.criteo.marketing.model.GetPortfolioResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdvertiserApi {
    private ApiClient localVarApiClient;

    public AdvertiserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdvertiserApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for apiPortfolioGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call apiPortfolioGetCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/2021-04/advertisers/me";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain", "application/json", "text/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call apiPortfolioGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = apiPortfolioGetCall(_callback);
        return localVarCall;

    }

    /**
     * 
     * Use this call to fetch a list of all advertisers in your account.
     * @return GetPortfolioResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public GetPortfolioResponse apiPortfolioGet() throws ApiException {
        ApiResponse<GetPortfolioResponse> localVarResp = apiPortfolioGetWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Use this call to fetch a list of all advertisers in your account.
     * @return ApiResponse&lt;GetPortfolioResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetPortfolioResponse> apiPortfolioGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = apiPortfolioGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<GetPortfolioResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Use this call to fetch a list of all advertisers in your account.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call apiPortfolioGetAsync(final ApiCallback<GetPortfolioResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = apiPortfolioGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<GetPortfolioResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getCategories
     * @param advertiserId Mandatory. The id of the advertiser to return. (required)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The requested advertiser is missing from current user’s portfolio. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCategoriesCall(Integer advertiserId, Boolean enabledOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/legacy/marketing/v1/advertisers/{advertiserId}/categories"
            .replaceAll("\\{" + "advertiserId" + "\\}", localVarApiClient.escapeString(advertiserId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (enabledOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("enabledOnly", enabledOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json", "text/json", "application/xml", "text/xml", "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCategoriesValidateBeforeCall(Integer advertiserId, Boolean enabledOnly, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'advertiserId' is set
        if (advertiserId == null) {
            throw new ApiException("Missing the required parameter 'advertiserId' when calling getCategories(Async)");
        }
        

        okhttp3.Call localVarCall = getCategoriesCall(advertiserId, enabledOnly, _callback);
        return localVarCall;

    }

    /**
     * Gets all advertiser&#39;s categories
     * Get the list of all the categories linked to the requested advertiser.
     * @param advertiserId Mandatory. The id of the advertiser to return. (required)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @return List&lt;CategoryMessage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The requested advertiser is missing from current user’s portfolio. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public List<CategoryMessage> getCategories(Integer advertiserId, Boolean enabledOnly) throws ApiException {
        ApiResponse<List<CategoryMessage>> localVarResp = getCategoriesWithHttpInfo(advertiserId, enabledOnly);
        return localVarResp.getData();
    }

    /**
     * Gets all advertiser&#39;s categories
     * Get the list of all the categories linked to the requested advertiser.
     * @param advertiserId Mandatory. The id of the advertiser to return. (required)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @return ApiResponse&lt;List&lt;CategoryMessage&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The requested advertiser is missing from current user’s portfolio. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CategoryMessage>> getCategoriesWithHttpInfo(Integer advertiserId, Boolean enabledOnly) throws ApiException {
        okhttp3.Call localVarCall = getCategoriesValidateBeforeCall(advertiserId, enabledOnly, null);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Gets all advertiser&#39;s categories (asynchronously)
     * Get the list of all the categories linked to the requested advertiser.
     * @param advertiserId Mandatory. The id of the advertiser to return. (required)
     * @param enabledOnly Optional. Returns only categories you can bid on. Defaults to false. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Categories returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The requested advertiser is missing from current user’s portfolio. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCategoriesAsync(Integer advertiserId, Boolean enabledOnly, final ApiCallback<List<CategoryMessage>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCategoriesValidateBeforeCall(advertiserId, enabledOnly, _callback);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getCategory
     * @param advertiserId Mandatory. The id of the advertiser to return. (required)
     * @param categoryHashCode Mandatory. The id of the category to return. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Category returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The requested advertiser is missing from current user’s portfolio. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested category was not found for the advertiser. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCategoryCall(Integer advertiserId, Integer categoryHashCode, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/legacy/marketing/v1/advertisers/{advertiserId}/categories/{categoryHashCode}"
            .replaceAll("\\{" + "advertiserId" + "\\}", localVarApiClient.escapeString(advertiserId.toString()))
            .replaceAll("\\{" + "categoryHashCode" + "\\}", localVarApiClient.escapeString(categoryHashCode.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json", "text/json", "application/xml", "text/xml", "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "Authorization" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCategoryValidateBeforeCall(Integer advertiserId, Integer categoryHashCode, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'advertiserId' is set
        if (advertiserId == null) {
            throw new ApiException("Missing the required parameter 'advertiserId' when calling getCategory(Async)");
        }
        
        // verify the required parameter 'categoryHashCode' is set
        if (categoryHashCode == null) {
            throw new ApiException("Missing the required parameter 'categoryHashCode' when calling getCategory(Async)");
        }
        

        okhttp3.Call localVarCall = getCategoryCall(advertiserId, categoryHashCode, _callback);
        return localVarCall;

    }

    /**
     * Gets a specific advertiser&#39;s category
     * Get a specific category linked to the requested advertiser.
     * @param advertiserId Mandatory. The id of the advertiser to return. (required)
     * @param categoryHashCode Mandatory. The id of the category to return. (required)
     * @return List&lt;CategoryMessage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Category returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The requested advertiser is missing from current user’s portfolio. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested category was not found for the advertiser. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public List<CategoryMessage> getCategory(Integer advertiserId, Integer categoryHashCode) throws ApiException {
        ApiResponse<List<CategoryMessage>> localVarResp = getCategoryWithHttpInfo(advertiserId, categoryHashCode);
        return localVarResp.getData();
    }

    /**
     * Gets a specific advertiser&#39;s category
     * Get a specific category linked to the requested advertiser.
     * @param advertiserId Mandatory. The id of the advertiser to return. (required)
     * @param categoryHashCode Mandatory. The id of the category to return. (required)
     * @return ApiResponse&lt;List&lt;CategoryMessage&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Category returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The requested advertiser is missing from current user’s portfolio. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested category was not found for the advertiser. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CategoryMessage>> getCategoryWithHttpInfo(Integer advertiserId, Integer categoryHashCode) throws ApiException {
        okhttp3.Call localVarCall = getCategoryValidateBeforeCall(advertiserId, categoryHashCode, null);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Gets a specific advertiser&#39;s category (asynchronously)
     * Get a specific category linked to the requested advertiser.
     * @param advertiserId Mandatory. The id of the advertiser to return. (required)
     * @param categoryHashCode Mandatory. The id of the category to return. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Category returned OK. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication failed. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The requested advertiser is missing from current user’s portfolio. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested category was not found for the advertiser. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Throttling failure. Maximum sending rate exceeded. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Unknown error. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCategoryAsync(Integer advertiserId, Integer categoryHashCode, final ApiCallback<List<CategoryMessage>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCategoryValidateBeforeCall(advertiserId, categoryHashCode, _callback);
        Type localVarReturnType = new TypeToken<List<CategoryMessage>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
